/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;

public class AccessMethod {
    private final CClass type;
    private final Member member;
    private final boolean setter;
    private String name;
    private String descriptor;
    private int additionalArgCount;

    public AccessMethod(CClass cClass, Member member, boolean bl) {
        this.type = cClass;
        this.member = member;
        this.setter = bl;
    }

    public CClass getDeclaringClass() {
        return this.type;
    }

    public String getDescriptor() {
        StringBuffer stringBuffer;
        if (this.descriptor != null) {
            return this.descriptor;
        }
        if (this.member.getDescriptor().charAt(0) != 'f') {
            stringBuffer = new StringBuffer(this.member.getDescriptor());
            if ("<init>".equals(this.member.getName())) {
                assert (this.member.getDeclaringType() == this.type);
            } else {
                int n = stringBuffer.indexOf(this.member.getName());
                stringBuffer.replace(n, n + this.member.getName().length(), "access");
            }
            stringBuffer.setLength(stringBuffer.lastIndexOf(")") + 1);
            this.additionalArgCount = this.type.getAccessMethodDescriptor(stringBuffer, this.member);
            stringBuffer.append(((Method)this.member).getReturnType().getDescriptor());
        } else if (this.setter) {
            stringBuffer = new StringBuffer("maccess;(").append(((Field)this.member).getType().getDescriptor()).append(')');
            this.type.getAccessMethodDescriptor(stringBuffer, this.member);
            stringBuffer.append('V');
        } else {
            stringBuffer = new StringBuffer("maccess;()");
            this.type.getAccessMethodDescriptor(stringBuffer, this.member);
            stringBuffer.append(((Field)this.member).getType().getDescriptor());
        }
        this.name = stringBuffer.substring(1, stringBuffer.indexOf(";"));
        this.descriptor = stringBuffer.substring(stringBuffer.indexOf("("));
        return this.descriptor;
    }

    public String getName() {
        this.getDescriptor();
        return this.name;
    }

    public int getAdditionalArgumentCount() {
        this.getDescriptor();
        return this.additionalArgCount;
    }

    void write(BytecodeWriter bytecodeWriter) {
        if (this.member.getDescriptor().charAt(0) != 'f') {
            Method method = (Method)this.member;
            int n = 0;
            if (!Reflection.isStatic((Member)method)) {
                bytecodeWriter.visitVarInsn(25, 0);
                n = 1;
            }
            for (int i = 0; i < method.getParameterCount(); ++i) {
                bytecodeWriter.visitLoad(n, method.getParameterType(i).getTypeId());
                n += Reflection.hasCategory2((int)method.getParameterType(i).getTypeId()) ? 2 : 1;
            }
            bytecodeWriter.visitMethodInsn(Reflection.isStatic((Member)method) ? 184 : 183, method);
            bytecodeWriter.visitReturn(method.getReturnType().getTypeId());
        } else if (this.setter) {
            if (Reflection.isStatic((Member)this.member)) {
                bytecodeWriter.visitLoad(0, ((Field)this.member).getType().getTypeId());
                bytecodeWriter.visitFieldInsn(179, (Field)this.member, null);
            } else {
                bytecodeWriter.visitVarInsn(25, 0);
                bytecodeWriter.visitLoad(1, ((Field)this.member).getType().getTypeId());
                bytecodeWriter.visitFieldInsn(181, (Field)this.member, null);
            }
            bytecodeWriter.visitInsn(177);
        } else {
            if (Reflection.isStatic((Member)this.member)) {
                bytecodeWriter.visitFieldInsn(178, (Field)this.member, null);
            } else {
                bytecodeWriter.visitVarInsn(25, 0);
                bytecodeWriter.visitFieldInsn(180, (Field)this.member, null);
            }
            bytecodeWriter.visitReturn(((Field)this.member).getType().getTypeId());
        }
    }
}

