/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.util.PathListIterator;
import de.grogra.util.Utils;
import de.grogra.vfs.FSFile;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.compiler.ASMType;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.XHashMap;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASMTypeLoader
implements TypeLoader {
    private final TypeLoader parent;
    private final ASMTypeLoader asmParent;
    private ClassLoader loader = null;
    private final EHashMap types = new EHashMap(25000);
    private final HashSet<String> packages = new HashSet(2000);
    private final XHashMap<String, FSFile> filePackages = new XHashMap(100);
    private final HashSet<FSFile> added = new HashSet(100);
    private final TypeEntry getKey = new TypeEntry(null, (FSFile)null);

    public ASMTypeLoader(TypeLoader typeLoader, ClassLoader classLoader) {
        this.parent = typeLoader;
        this.asmParent = typeLoader instanceof ASMTypeLoader ? (ASMTypeLoader)typeLoader : null;
        this.loader = classLoader;
        this.packages.add("");
    }

    private void scanDirectory(FileSystem fileSystem, Object object, StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        Object[] objectArray = fileSystem.listFiles(object);
        for (int i = 0; i < objectArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            String string = fileSystem.getName(objectArray[i]);
            if (!fileSystem.isLeaf(objectArray[i])) {
                stringBuffer.append(string);
                this.filePackages.add((Object)stringBuffer.toString(), (Object)new FSFile(fileSystem, objectArray[i]));
            } else if (string.length() > 6 && string.endsWith(".class")) {
                stringBuffer.append(string);
                stringBuffer.setLength(stringBuffer.length() - 6);
                this.types.put((EHashMap.Entry)new TypeEntry(stringBuffer.toString(), new FSFile(fileSystem, objectArray[i])));
            }
            stringBuffer.setLength(n);
        }
        this.packages.add(stringBuffer.toString());
    }

    private void loadPackages(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            XHashMap.Entry entry;
            String string2;
            String string3 = string2 = (n = string.indexOf(46, n + 1)) < 0 ? string : string.substring(0, n);
            while ((entry = this.filePackages.getEntry((Object)string2)) != null) {
                stringBuffer.setLength(0);
                stringBuffer.append(string2);
                FSFile fSFile = (FSFile)entry.getValue();
                this.scanDirectory(fSFile.fileSystem, fSFile.file, stringBuffer);
                entry.remove();
            }
        } while (n > 0);
    }

    private void readZip(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.readZipEntry(zipEntry, zipInputStream, null);
        }
    }

    private void readZipEntry(ZipEntry zipEntry, InputStream inputStream, ZipFile zipFile) throws IOException {
        int n;
        String string = zipEntry.getName();
        if (string.endsWith(".class") && (n = (string = string.substring(0, string.length() - 6)).lastIndexOf(47)) + 1 < string.length()) {
            string = string.replace('/', '.');
            if (inputStream != null) {
                byte[] byArray = new byte[(int)zipEntry.getSize()];
                Utils.readFully((InputStream)inputStream, (byte[])byArray);
                this.types.put((EHashMap.Entry)new TypeEntry(string, byArray));
            } else {
                this.types.put((EHashMap.Entry)new TypeEntry(string, zipFile));
            }
            while (n > 0 && this.packages.add(string.substring(0, n))) {
                n = string.lastIndexOf(46, n - 1);
            }
        }
    }

    public synchronized void addJars(URL[] uRLArray, boolean bl) throws IOException {
        for (int i = 0; i < uRLArray.length; ++i) {
            this.readZip(uRLArray[i].openStream());
        }
        if (bl && uRLArray.length > 0) {
            this.loader = new URLClassLoader(uRLArray, this.loader);
        }
    }

    public synchronized void addFiles(FileSystem fileSystem, Object[] objectArray, boolean bl) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.added.add(new FSFile(fileSystem, objectArray[i]))) continue;
            if (fileSystem.isLeaf(objectArray[i])) {
                try {
                    Closeable closeable;
                    if (objectArray[i] instanceof File) {
                        closeable = new ZipFile((File)objectArray[i]);
                        Enumeration<? extends ZipEntry> enumeration = ((ZipFile)closeable).entries();
                        while (enumeration.hasMoreElements()) {
                            this.readZipEntry(enumeration.nextElement(), null, (ZipFile)closeable);
                        }
                    } else {
                        closeable = fileSystem.getInputStream(objectArray[i]);
                        this.readZip((InputStream)closeable);
                        ((InputStream)closeable).close();
                    }
                    arrayList.add(fileSystem.toURL(objectArray[i]));
                }
                catch (IOException iOException) {}
                continue;
            }
            this.scanDirectory(fileSystem, objectArray[i], new StringBuffer());
            arrayList.add(fileSystem.toURL(objectArray[i]));
        }
        if (bl && !arrayList.isEmpty()) {
            this.loader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), this.loader);
        }
    }

    public synchronized boolean hasPackage(String string) {
        if (this.packages.contains(string)) {
            return true;
        }
        this.loadPackages(string);
        return this.packages.contains(string) || this.parent instanceof ASMTypeLoader && ((ASMTypeLoader)this.parent).hasPackage(string);
    }

    public synchronized Type typeForNameOrNull(String string) throws ClassNotFoundException {
        ClassReader classReader;
        this.getKey.setKey(string);
        TypeEntry typeEntry = (TypeEntry)this.types.get((EHashMap.Entry)this.getKey);
        if (typeEntry == null) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                this.loadPackages(string.substring(0, n));
            }
            typeEntry = (TypeEntry)this.types.get((EHashMap.Entry)this.getKey);
        }
        if (typeEntry == null || typeEntry.value == null) {
            return this.asmParent != null ? this.asmParent.typeForNameOrNull(string) : (this.parent != null ? this.parent.typeForName(string) : null);
        }
        if (typeEntry.value instanceof ASMType) {
            return (ASMType)((Object)typeEntry.value);
        }
        try {
            classReader = new ClassReader(typeEntry.getStream());
        }
        catch (IOException iOException) {
            typeEntry.value = null;
            throw new ClassNotFoundException(string + " " + iOException.getMessage());
        }
        ASMType aSMType = new ASMType(this);
        typeEntry.value = aSMType;
        classReader.accept((ClassVisitor)aSMType, 7);
        return aSMType;
    }

    public Type typeForName(String string) throws ClassNotFoundException {
        Type type = this.typeForNameOrNull(string);
        if (type == null) {
            throw new ClassNotFoundException(string);
        }
        return type;
    }

    public Class classForName(String string) throws ClassNotFoundException {
        return Class.forName(string, false, this.loader);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static void main(String[] stringArray) throws Exception {
        Object[] objectArray = ASMTypeLoader.getExtensionClassPath(System.getProperty("java.ext.dirs"));
        System.out.println(Arrays.toString(objectArray));
        Object[] objectArray2 = ASMTypeLoader.getBootClassPath((File[])objectArray);
        System.out.println(Arrays.toString(objectArray2));
        new ASMTypeLoader(null, null).addFiles((FileSystem)LocalFileSystem.FILE_ADAPTER, objectArray2, false);
        new ASMTypeLoader(null, null).addFiles((FileSystem)LocalFileSystem.FILE_ADAPTER, new File[]{new File("/home/okn/platform/Platform/build")}, false);
    }

    public static File[] getClassPath(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        PathListIterator pathListIterator = new PathListIterator(string);
        while (pathListIterator.hasNext()) {
            File file = pathListIterator.nextPath();
            if (file.isDirectory()) {
                arrayList.add(file);
                continue;
            }
            String string2 = file.getName().toLowerCase();
            if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static File[] getExtensionClassPath(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        PathListIterator pathListIterator = new PathListIterator(string);
        while (pathListIterator.hasNext()) {
            File file = pathListIterator.nextPath();
            if (!file.isDirectory()) continue;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getName().toLowerCase();
                if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
                arrayList.add(fileArray[i]);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static File[] getBootClassPath(File[] fileArray) throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            hashSet.add(fileArray[i].getCanonicalFile());
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getProperty("sun.boot.class.path");
        if (string != null) {
            PathListIterator pathListIterator = new PathListIterator(string);
            while (pathListIterator.hasNext()) {
                File file = pathListIterator.nextPath();
                if (!file.exists()) continue;
                arrayList.add(file);
            }
        } else {
            File file = new File(System.getProperty("java.home")).getCanonicalFile();
            if (!file.isDirectory()) {
                throw new IOException("java.home does not point to a directory");
            }
            ASMTypeLoader.scan(file, hashSet, arrayList);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static void scan(File file, HashSet hashSet, ArrayList<File> arrayList) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i].getCanonicalFile();
            if (!hashSet.add(file2)) continue;
            if (file2.isDirectory()) {
                if (file2.getName().equalsIgnoreCase("classes")) {
                    arrayList.add(file2);
                }
                ASMTypeLoader.scan(file2, hashSet, arrayList);
                continue;
            }
            String string = file2.getName().toLowerCase();
            if (!string.endsWith(".jar") && !string.endsWith(".zip")) continue;
            arrayList.add(file2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TypeEntry
    extends EHashMap.ObjectEntry<String, Object> {
        TypeEntry(String string, FSFile fSFile) {
            this.setKey(string);
            this.value = fSFile;
        }

        TypeEntry(String string, byte[] byArray) {
            this.setKey(string);
            this.value = byArray;
        }

        TypeEntry(String string, ZipFile zipFile) {
            this.setKey(string);
            this.value = zipFile;
        }

        InputStream getStream() throws IOException {
            InputStream inputStream;
            if (this.value instanceof FSFile) {
                FSFile fSFile = (FSFile)this.value;
                inputStream = fSFile.fileSystem.getInputStream(fSFile.file);
            } else if (this.value instanceof byte[]) {
                inputStream = new ByteArrayInputStream((byte[])this.value);
            } else {
                ZipFile zipFile = (ZipFile)this.value;
                inputStream = zipFile.getInputStream(zipFile.getEntry(((String)this.getKey()).replace('.', '/') + ".class"));
            }
            this.value = null;
            return new BufferedInputStream(inputStream);
        }
    }
}

