/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp.objects.ImageAdapter;
import de.grogra.imp3d.shading.ChannelMapNodeVisitor;
import de.grogra.imp3d.shading.SurfaceMap;
import de.grogra.math.ChannelData;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ImageMap
extends SurfaceMap {
    ImageAdapter image;
    boolean bilinearFiltering = true;
    private transient Raster raster;
    private transient Object dataElements;
    public static final Node.NType $TYPE = new Node.NType((Node)new ImageMap());
    public static final Node.NType.Field image$FIELD = new _Field("image", 0x200000, (Type)ClassAdapter.wrap(ImageAdapter.class), null, 0);
    public static final Node.NType.Field bilinearFiltering$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new ImageMap();
    }

    public ImageAdapter getImageAdapter() {
        return this.image;
    }

    public void setImageAdapter(ImageAdapter imageAdapter) {
        this.image = imageAdapter;
    }

    public boolean hasBilinearFiltering() {
        return this.bilinearFiltering;
    }

    public void setBilinearFiltering(boolean bl) {
        this.bilinearFiltering = bl;
    }

    public int getAverageColor() {
        return -8355712;
    }

    protected float getDu() {
        BufferedImage bufferedImage = this.getBufferedImage();
        return bufferedImage != null ? 1.0f / (float)bufferedImage.getWidth() : 0.01f;
    }

    protected float getDv() {
        BufferedImage bufferedImage = this.getBufferedImage();
        return bufferedImage != null ? 1.0f / (float)bufferedImage.getHeight() : 0.01f;
    }

    private BufferedImage getBufferedImage() {
        return this.image != null ? this.image.getNativeImage() : null;
    }

    protected synchronized float getFloatValueImpl(float f, float f2, ChannelData channelData, int n) {
        float f3 = this.bilinearFiltering ? this.getFloatValueImplBilinear(f, f2, channelData, n) : this.getFloatValueImplSimple(f, f2, channelData, n);
        return f3;
    }

    protected float getFloatValueImplSimple(float f, float f2, ChannelData channelData, int n) {
        int n2;
        BufferedImage bufferedImage = this.getBufferedImage();
        if (bufferedImage == null) {
            return (n & 3) < 3 ? 0.5f : 1.0f;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (writableRaster != this.raster) {
            this.raster = writableRaster;
            this.dataElements = null;
        }
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getHeight();
        if ((f -= (float)((int)f)) < 0.0f) {
            f += 1.0f;
        }
        if ((f *= (float)n3) <= 0.0f || f >= (float)n3) {
            f = 0.0f;
        }
        if ((f2 -= (float)((int)f2)) < 0.0f) {
            f2 += 1.0f;
        }
        if ((f2 *= (float)n4) <= 0.0f || f2 >= (float)n4) {
            f2 = 0.0f;
        }
        int n5 = (int)f;
        int n6 = (int)f2;
        float f3 = 0.0f;
        this.dataElements = writableRaster.getDataElements(n5, n4 - 1 - n6, this.dataElements);
        switch (n & 3) {
            case 0: {
                n2 = bufferedImage.getColorModel().getRed(this.dataElements);
                break;
            }
            case 1: {
                n2 = bufferedImage.getColorModel().getGreen(this.dataElements);
                break;
            }
            case 2: {
                n2 = bufferedImage.getColorModel().getBlue(this.dataElements);
                break;
            }
            case 3: {
                n2 = bufferedImage.getColorModel().getAlpha(this.dataElements);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        f3 = n2;
        return f3 / 255.0f;
    }

    protected synchronized float getFloatValueImplBilinear(float f, float f2, ChannelData channelData, int n) {
        BufferedImage bufferedImage = this.getBufferedImage();
        if (bufferedImage == null) {
            return (n & 3) < 3 ? 0.5f : 1.0f;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (writableRaster != this.raster) {
            this.raster = writableRaster;
            this.dataElements = null;
        }
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        if ((f -= (float)((int)f)) < 0.0f) {
            f += 1.0f;
        }
        if ((f *= (float)n2) <= 0.0f || f >= (float)n2) {
            f = 0.0f;
        }
        if ((f2 -= (float)((int)f2)) < 0.0f) {
            f2 += 1.0f;
        }
        if ((f2 *= (float)n3) <= 0.0f || f2 >= (float)n3) {
            f2 = 0.0f;
        }
        int n4 = (int)f;
        f -= (float)n4;
        int n5 = (int)f2;
        f2 -= (float)n5;
        float f3 = 0.0f;
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                int n6;
                this.dataElements = writableRaster.getDataElements((n4 + i) % n2, n3 - 1 - (n5 + j) % n3, this.dataElements);
                switch (n & 3) {
                    case 0: {
                        n6 = bufferedImage.getColorModel().getRed(this.dataElements);
                        break;
                    }
                    case 1: {
                        n6 = bufferedImage.getColorModel().getGreen(this.dataElements);
                        break;
                    }
                    case 2: {
                        n6 = bufferedImage.getColorModel().getBlue(this.dataElements);
                        break;
                    }
                    case 3: {
                        n6 = bufferedImage.getColorModel().getAlpha(this.dataElements);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                f3 += (i == 0 ? 1.0f - f : f) * (j == 0 ? 1.0f - f2 : f2) * (float)n6;
            }
        }
        return f3 / 255.0f;
    }

    public void accept(ChannelMapNodeVisitor channelMapNodeVisitor) {
        channelMapNodeVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)image$FIELD);
        bilinearFiltering$FIELD = new _Field("bilinearFiltering", 0x200000, Type.BOOLEAN, null, 1);
        $TYPE.addManagedField((ManageableType.Field)bilinearFiltering$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 1: {
                    ((ImageMap)((Object)object)).bilinearFiltering = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 1: {
                    return ((ImageMap)((Object)object)).bilinearFiltering;
                }
            }
            return super.getBoolean(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((ImageMap)((Object)object)).image = (ImageAdapter)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((ImageMap)((Object)object)).image;
                }
            }
            return super.getObject(object);
        }
    }
}

