/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray2;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.imp3d.DisplayVisitor;
import de.grogra.imp3d.IMP3D;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.VolumeBuilder;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.SensorNode;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.ray2.VolumeListener;
import de.grogra.imp3d.shading.AlgorithmSwitchShader;
import de.grogra.imp3d.shading.ShaderRef;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Interior;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Sensor;
import de.grogra.ray.physics.Shader;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.Options;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Scene;
import de.grogra.util.Disposable;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.CSGComplement;
import de.grogra.vecmath.geom.CSGDifference;
import de.grogra.vecmath.geom.CSGIntersection;
import de.grogra.vecmath.geom.CSGUnion;
import de.grogra.vecmath.geom.CellIterator;
import de.grogra.vecmath.geom.DefaultCellIterator;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.MeshVolume;
import de.grogra.vecmath.geom.Octree;
import de.grogra.vecmath.geom.OctreeUnion;
import de.grogra.vecmath.geom.SensorDisc;
import de.grogra.vecmath.geom.SkySphere;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Volume;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;

public class SceneVisitor
extends DisplayVisitor
implements Scene,
ProgressMonitor,
Cloneable,
Disposable {
    private ObjectList<Interior> interiorStack = new ObjectList();
    private Interior interior;
    private OctreeUnion sceneVolume;
    private Octree sceneOctree;
    private Octree.State sceneVolumeState;
    private ObjectList<ArrayList<Volume>> volumeStack = new ObjectList();
    private BoundingBox bounds;
    private ArrayList<Volume> volumes;
    private ArrayList<Volume> infiniteVolumes;
    private ArrayList<Volume> nonCSGVolumes;
    private ObjectList<Light> lights = new ObjectList();
    private Light[] lightsArray;
    private ObjectList<Sensor> sensors = new ObjectList();
    private Sensor[] sensorsArray;
    private ObjectList<Matrix4d> lightTransformations = new ObjectList();
    private Matrix4d[] lightTransformationsArray;
    private Matrix4d[] inverseLightTransformationsArray;
    private ObjectList<Matrix4d> sensorTransformations = new ObjectList();
    private Matrix4d[] sensorTransformationsArray;
    private Matrix4d[] inverseSensorTransformationsArray;
    private ObjectList<de.grogra.imp3d.shading.Shader> shaders = new ObjectList();
    private ObjectList<Interior> interiors = new ObjectList();
    private ObjectList<Matrix4d> transforms = new ObjectList();
    private IntList volumeLights = new IntList();
    private IntList volumeSensors = new IntList();
    private VolumeListener mapping;
    private ViewConfig3D view;
    private boolean[] visibleLayers;
    private Workbench workbench;
    private final Spectrum spectrumFactory;
    int volumeCount = 0;
    int csgCount = 0;
    int polyCount = 0;
    private Volume addedVolume;
    private boolean infinite;
    private boolean haveRealLight;
    private final long startTime;
    private long time;
    private VolumeBuilder builder;
    private long nextProgressTime = 0L;
    public static int MIN_OBJ = 2;

    void addVolume(Volume volume, Matrix4d matrix4d, de.grogra.imp3d.shading.Shader shader) {
        int n = this.addVolume(volume);
        if (shader == null) {
            shader = this.getCurrentShader();
        }
        this.shaders.set(n, (Object)shader);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.m33 = 1.0;
        Math2.invertAffine((Matrix4d)matrix4d, (Matrix4d)matrix4d2);
        this.transforms.set(n, (Object)matrix4d2);
    }

    private int addVolume(Volume volume) {
        long l;
        int n = this.volumeCount++;
        volume.setId(n);
        (this.infinite ? this.infiniteVolumes : this.volumes).add(volume);
        this.interiors.set(n, (Object)this.interior);
        if (this.volumeCount % 50 == 0 && (l = System.currentTimeMillis()) >= this.nextProgressTime) {
            this.nextProgressTime = l + 200L;
            this.setProgress(IMP3D.I18N.msg("ray.constructing-geometry", (Object)this.volumeCount), -1.0f);
        }
        this.addedVolume = volume;
        if (volume instanceof MeshVolume) {
            this.polyCount += ((MeshVolume)volume).getPolygonCount();
        }
        return n;
    }

    public OctreeUnion getOctree() {
        return this.sceneVolume;
    }

    public Scene dup() {
        try {
            SceneVisitor sceneVisitor = (SceneVisitor)this.clone();
            sceneVisitor.sceneVolumeState = this.sceneOctree.createState();
            return sceneVisitor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public Shader getShader(Volume volume) {
        return (Shader)this.shaders.get(volume.getId());
    }

    public Interior getInterior(Volume volume) {
        return (Interior)this.interiors.get(volume.getId());
    }

    public int getLight(Volume volume) {
        return this.volumeLights.get(volume.getId()) - 1;
    }

    public int getSensor(Volume volume) {
        return this.volumeSensors.get(volume.getId()) - 1;
    }

    public void transform(Volume volume, Tuple3d tuple3d, Tuple3d tuple3d2) {
        Math2.transformPoint((Matrix4d)((Matrix4d)this.transforms.get(volume.getId())), (Tuple3d)tuple3d, (Tuple3d)tuple3d2);
    }

    protected boolean isInVisibleLayer(Object object, boolean bl) {
        if (this.visibleLayers == null) {
            return super.isInVisibleLayer(object, bl);
        }
        int n = this.state.getIntDefault(object, bl, Attributes.LAYER, 0);
        return n < 0 || n >= this.visibleLayers.length || this.visibleLayers[n];
    }

    public SceneVisitor(Workbench workbench, Graph graph, float f, Options options, ViewConfig3D viewConfig3D, boolean[] blArray, VolumeListener volumeListener, Spectrum spectrum) {
        this.workbench = workbench;
        this.spectrumFactory = spectrum;
        this.view = viewConfig3D;
        this.visibleLayers = blArray;
        this.mapping = volumeListener;
        this.startTime = System.currentTimeMillis();
        workbench.beginStatus((Object)this);
        this.setProgress(IMP3D.I18N.msg("ray.constructing-geometry", (Object)0), -1.0f);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        this.init(GraphState.current((Graph)graph), matrix4d, viewConfig3D, viewConfig3D != null);
        this.builder = new VolumeBuilder(new PolygonizationCache(this.state, 3, ((Number)options.get("flatness", (Object)new Float(1.0f))).floatValue(), true), f){

            protected void addVolume(Volume volume, Matrix4d matrix4d, de.grogra.imp3d.shading.Shader shader) {
                SceneVisitor.this.addVolume(volume, matrix4d, shader);
            }

            protected Matrix4d getCurrentTransformation() {
                return SceneVisitor.this.getCurrentTransformation();
            }

            public de.grogra.imp3d.shading.Shader getCurrentShader() {
                return SceneVisitor.this.getCurrentShader();
            }

            public GraphState getRenderGraphState() {
                return SceneVisitor.this.getGraphState();
            }
        };
        this.volumes = new ArrayList();
        this.nonCSGVolumes = this.volumes;
        this.infiniteVolumes = new ArrayList();
        this.state.getGraph().accept(null, (Visitor)this, null);
        this.volumeStack.clear();
        this.volumeStack = null;
        this.interiorStack.clear();
        this.interiorStack = null;
        this.setProgress(IMP3D.I18N.msg("ray.constructing-octree"), -1.0f);
        OctreeUnion octreeUnion = new OctreeUnion();
        octreeUnion.volumes.addAll(this.volumes);
        this.volumes.clear();
        this.volumes = null;
        octreeUnion.initialize(Octree.suggestDepth((int)octreeUnion.volumes.size()), MIN_OBJ, (CellIterator)new DefaultCellIterator());
        for (int i = 0; i < this.infiniteVolumes.size(); ++i) {
            octreeUnion.addInfiniteVolume(this.infiniteVolumes.get(i));
        }
        this.sceneVolume = octreeUnion;
        this.sceneOctree = octreeUnion.getOctree();
        this.sceneVolumeState = this.sceneOctree.createState();
        this.bounds = new BoundingBox(this.sceneOctree.getMin(), this.sceneOctree.getMax());
        if (!this.haveRealLight && viewConfig3D != null) {
            this.lights.add((Object)viewConfig3D.getDefaultLight(matrix4d));
            this.lightTransformations.add((Object)matrix4d);
        }
        this.time = System.currentTimeMillis() - this.startTime;
        this.lightsArray = new Light[this.lights.size()];
        this.lights.toArray((Object[])this.lightsArray);
        this.lights = null;
        this.sensorsArray = new Sensor[this.sensors.size()];
        this.sensors.toArray((Object[])this.sensorsArray);
        this.sensors = null;
        this.lightTransformationsArray = new Matrix4d[this.lightTransformations.size()];
        this.lightTransformations.toArray((Object[])this.lightTransformationsArray);
        this.inverseLightTransformationsArray = new Matrix4d[this.lightTransformationsArray.length];
        this.lightTransformations = null;
        this.sensorTransformationsArray = new Matrix4d[this.sensorTransformations.size()];
        this.sensorTransformations.toArray((Object[])this.sensorTransformationsArray);
        this.inverseSensorTransformationsArray = new Matrix4d[this.sensorTransformationsArray.length];
        this.sensorTransformations = null;
        this.setProgress("", 2.0f);
    }

    protected de.grogra.imp3d.shading.Shader resolveShader(de.grogra.imp3d.shading.Shader shader) {
        return shader instanceof AlgorithmSwitchShader ? (this.view != null ? ((AlgorithmSwitchShader)shader).getRaytracerShader() : ((AlgorithmSwitchShader)shader).getRadiationShader()) : (shader instanceof ShaderRef ? ((ShaderRef)shader).resolve() : shader);
    }

    protected void visitImpl(Object object, boolean bl, de.grogra.imp3d.shading.Shader shader, Path path) {
        Matrix4d matrix4d;
        CSGUnion cSGUnion;
        Interior interior = (Interior)this.state.getObjectDefault(object, bl, Attributes.INTERIOR, (Object)this.interior);
        if (interior != null) {
            this.interior = interior;
        } else {
            interior = this.interior;
        }
        boolean bl2 = false;
        switch (this.state.getIntDefault(object, bl, Attributes.CSG_OPERATION, -1)) {
            case 0: {
                cSGUnion = new CSGUnion();
                break;
            }
            case 1: {
                cSGUnion = new CSGIntersection();
                break;
            }
            case 2: {
                cSGUnion = new CSGDifference();
                break;
            }
            case 3: {
                bl2 = true;
                cSGUnion = new CSGUnion();
                break;
            }
            default: {
                cSGUnion = null;
            }
        }
        boolean bl3 = this.volumes == this.nonCSGVolumes;
        this.addedVolume = null;
        this.infinite = this.state.getBooleanDefault(object, bl, Attributes.TREATED_AS_INFINITE, false);
        if (cSGUnion != null) {
            this.addVolume((Volume)(bl2 ? new CSGComplement((Volume)cSGUnion) : cSGUnion), this.getCurrentTransformation(), shader);
            this.volumes = cSGUnion.volumes;
            ++this.csgCount;
        } else {
            Object object2 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null);
            if (object2 instanceof Sky) {
                matrix4d = this.getCurrentTransformation();
                SkySphere skySphere = new SkySphere();
                this.builder.setInvTransformation((TransformableVolume)skySphere, matrix4d, 0.0);
                this.addVolume((Volume)skySphere, matrix4d, shader);
            } else if (object2 instanceof SensorNode) {
                double d;
                if (this.view == null && !(Math.abs(d = (double)((SensorNode)object2).getRadius()) < (double)this.builder.epsilon)) {
                    Matrix4d matrix4d2 = this.getCurrentTransformation();
                    SensorDisc sensorDisc = new SensorDisc();
                    this.builder.setInvTransformation((TransformableVolume)sensorDisc, matrix4d2, 0.0);
                    d = 1.0 / d;
                    sensorDisc.scale(d, d, d);
                    this.addVolume((Volume)sensorDisc, matrix4d2, shader);
                    this.shaders.set(sensorDisc.getId(), null);
                    int n = this.sensors.size();
                    this.sensors.add((Object)((SensorNode)object2));
                    this.sensorTransformations.add((Object)new Matrix4d(matrix4d2));
                    this.volumeSensors.set(sensorDisc.getId(), n + 1);
                }
            } else if (object2 instanceof Renderable) {
                ((Renderable)object2).draw(object, bl, this.builder);
            }
        }
        matrix4d = (Light)this.state.getObjectDefault(object, bl, Attributes.LIGHT, null);
        if (matrix4d != null) {
            int n = this.lights.size();
            this.lights.add((Object)matrix4d);
            this.lightTransformations.add((Object)new Matrix4d(this.getCurrentTransformation()));
            if (this.addedVolume != null) {
                this.volumeLights.set(this.addedVolume.getId(), n + 1);
            }
            if (matrix4d.getLightType() != 0) {
                this.haveRealLight = true;
            }
        }
        if (bl3 && this.mapping != null && this.addedVolume != null) {
            this.mapping.volumeCreated(object, bl, this.addedVolume);
        }
    }

    public Object visitInstanceEnter() {
        if (this.mapping != null) {
            this.mapping.beginGroup(this.lastEntered, this.lastEnteredIsNode);
        }
        return super.visitInstanceEnter();
    }

    public boolean visitInstanceLeave(Object object) {
        if (this.mapping != null) {
            this.mapping.endGroup();
        }
        return super.visitInstanceLeave(object);
    }

    protected void visitEnterImpl(Object object, boolean bl, Path path) {
        this.interiorStack.push((Object)this.interior);
        this.volumeStack.push(this.volumes);
        super.visitEnterImpl(object, bl, path);
    }

    protected void visitLeaveImpl(Object object, boolean bl, Path path) {
        super.visitLeaveImpl(object, bl, path);
        this.volumes = (ArrayList)this.volumeStack.pop();
        this.interior = (Interior)this.interiorStack.pop();
    }

    public Light[] getLights() {
        return this.lightsArray;
    }

    public Sensor[] getSensors() {
        return this.sensorsArray;
    }

    public int getStamp() {
        return this.getGraphState().getGraph().getStamp();
    }

    public String getUniqueName() {
        return this.workbench.getRegistry().getFileSystemName();
    }

    public Object getGraph() {
        return this.getGraphState().getGraph();
    }

    public Matrix4d getLightTransformation(int n) {
        return this.lightTransformationsArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix4d getInverseLightTransformation(int n) {
        Matrix4d[] matrix4dArray = this.inverseLightTransformationsArray;
        synchronized (this.inverseLightTransformationsArray) {
            Matrix4d matrix4d = this.inverseLightTransformationsArray[n];
            if (matrix4d == null) {
                matrix4d = new Matrix4d();
                matrix4d.m33 = 1.0;
                Math2.invertAffine((Matrix4d)this.lightTransformationsArray[n], (Matrix4d)matrix4d);
                this.inverseLightTransformationsArray[n] = matrix4d;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return matrix4d;
        }
    }

    public Matrix4d getSensorTransformation(int n) {
        return this.sensorTransformationsArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix4d getInverseSensorTransformation(int n) {
        Matrix4d[] matrix4dArray = this.inverseSensorTransformationsArray;
        synchronized (this.inverseSensorTransformationsArray) {
            Matrix4d matrix4d = this.inverseSensorTransformationsArray[n];
            if (matrix4d == null) {
                matrix4d = new Matrix4d();
                matrix4d.m33 = 1.0;
                Math2.invertAffine((Matrix4d)this.sensorTransformationsArray[n], (Matrix4d)matrix4d);
                this.inverseSensorTransformationsArray[n] = matrix4d;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return matrix4d;
        }
    }

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        return this.sceneOctree.computeIntersections(line, n, intersectionList, intersection, intersection2, this.sceneVolumeState);
    }

    public BoundingBox getBoundingBox() {
        return this.bounds;
    }

    public void appendStatistics(StringBuffer stringBuffer) {
        stringBuffer.append(IMP3D.I18N.msg("ray.scene-statistics", new Object[]{(int)(this.time / 60000L), Float.valueOf((float)(this.time % 60000L) * 0.001f), this.volumeCount - this.csgCount, this.csgCount, this.polyCount, this.getLights().length, this.sceneOctree.getDepth(), this.sceneOctree.getCellCount()}));
    }

    public void dispose() {
        this.lightsArray = null;
        this.lightTransformationsArray = null;
        this.inverseLightTransformationsArray = null;
        this.sensorsArray = null;
        this.sensorTransformationsArray = null;
        this.inverseSensorTransformationsArray = null;
        this.sceneOctree = null;
        this.sceneVolume = null;
        this.sceneVolumeState = null;
        this.shaders = null;
        this.interiors = null;
        this.transforms = null;
        this.volumeLights = null;
        this.volumeSensors = null;
        this.workbench = null;
        this.mapping = null;
    }

    public void setProgress(String string, float f) {
        this.workbench.setStatus((Object)this, string);
        if (f < 0.0f) {
            this.workbench.setIndeterminateProgress((Object)this);
        } else if (f == 2.0f) {
            this.workbench.clearProgress((Object)this);
        } else {
            this.workbench.setProgress((Object)this, f);
        }
    }

    public void showMessage(String string) {
        this.workbench.logGUIInfo(string);
    }

    public Spectrum createSpectrum() {
        return this.spectrumFactory.newInstance();
    }
}

