/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.ray.RTFakeObject;
import de.grogra.ray.RTObject;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class RTSky
extends RaytracerLeaf
implements RTFakeObject {
    private static final float FLOAT_PI = (float)Math.PI;
    private static final float LESS_THAN_FLOAT_MAX_VALUE = 3.3994207E38f;
    private float m_angle;
    private Ray m_lastRay;
    private final Vector3f m_vec = new Vector3f();
    private final ShadingEnvironment m_shaderInput = new ShadingEnvironment();

    public RTSky(Object object, boolean bl, long l) {
        super(object, bl, l);
        this.m_shaderInput.localPoint.set(0.0f, 0.0f, 0.0f);
        this.m_shaderInput.normal.set(0.0f, 0.0f, 1.0f);
        this.m_shaderInput.photonDirection = false;
        this.m_shaderInput.point.set(0.0f, 0.0f, 0.0f);
        Ray ray = this.m_shaderInput.rays.nextRay();
        ray.getOrigin().set(0.0f, 0.0f, 0.0f);
        ray.getDirection().set(0.0f, 0.0f, 1.0f);
        ray.getColor().set(1.0f, 1.0f, 1.0f);
        this.m_shaderInput.solid = false;
        this.m_shaderInput.dpdu.set(1.0f, 0.0f, 0.0f);
        this.m_shaderInput.dpdv.set(0.0f, 1.0f, 0.0f);
        this.m_shaderInput.view.set(0.0f, 0.0f, 1.0f);
    }

    public boolean isConvex() {
        return false;
    }

    public void setTransformation(Matrix4f matrix4f) {
        super.setTransformation(matrix4f);
        this.setShader(this.shader);
    }

    public float getDistance(Ray ray, RayContext rayContext) {
        this.m_lastRay = ray;
        return 3.3994207E38f;
    }

    public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
        if (this.m_lastRay.getDirection().x == 0.0f && this.m_lastRay.getDirection().y == 0.0f) {
            intersectionDescription.getUVCoordinate().x = 0.0f;
        } else {
            this.m_vec.x = this.m_lastRay.getDirection().x;
            this.m_vec.y = this.m_lastRay.getDirection().y;
            this.m_vec.z = 0.0f;
            this.m_vec.normalize();
            if ((double)this.m_vec.y >= 0.0) {
                this.m_angle = (float)Math.acos(this.m_vec.x);
                intersectionDescription.getUVCoordinate().x = this.m_angle / (float)Math.PI * 0.5f;
            } else {
                this.m_angle = (float)Math.acos(-this.m_vec.x);
                intersectionDescription.getUVCoordinate().x = 0.5f + this.m_angle / (float)Math.PI * 0.5f;
            }
        }
        this.m_angle = (float)Math.asin(this.m_lastRay.getDirection().z);
        intersectionDescription.getUVCoordinate().y = (this.m_angle + 1.5707964f) / (float)Math.PI;
        intersectionDescription.setPoint(null, 3.3994207E38f);
        intersectionDescription.setRTObject((RTObject)this);
    }

    public boolean isShadeable() {
        return true;
    }

    public boolean isSolid() {
        return false;
    }

    public BoundingVolume getBoundingVolume() {
        return null;
    }

    public void getColor(Ray ray, IntersectionDescription intersectionDescription, Color3f color3f) {
        this.m_shaderInput.localPoint.set((Tuple3f)ray.getDirection());
        this.m_shaderInput.uv.set((Tuple2f)intersectionDescription.getUVCoordinate());
        this.getRTShader().getShadingColor(this.m_shaderInput, color3f);
    }
}

