/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.ray.GroIMPShader;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.shading.Light;
import de.grogra.ray.RTLight;
import de.grogra.ray.Raytracer;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.light.NoShadows;
import de.grogra.ray.light.ShadowProcessor;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import de.grogra.ray.util.RayList;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.goui.util.MTRandom;

public class RTAreaLight
extends RaytracerLeaf
implements RTLight {
    private Light m_light = null;
    private boolean m_isShadowless = true;
    private final ShadingEnvironment m_env = new ShadingEnvironment();
    private final RayList m_rayList = new RayList();
    private final int m_seed = (int)System.currentTimeMillis();
    private ShadowProcessor m_noShadows = new NoShadows();
    private int m_added;
    private final Ray m_tmpRay1 = new Ray();
    private Ray m_tmpRay2 = null;
    private float m_rayLength;
    private final Vector3f m_out = new Vector3f();
    private final Spectrum3f m_bsdfColor = new Spectrum3f();
    private final RayContext m_rayContext = new RayContext();
    private int m_maximalLightRays = 50;
    private final MTRandom rnd = new MTRandom();
    private final Spectrum3f spectrum = new Spectrum3f();

    public RTAreaLight(Object object, boolean bl, long l, Light light, Vector3f vector3f, Vector3f vector3f2) {
        super(object, bl, l);
        this.m_light = light;
        this.m_isShadowless = this.m_light.isShadowless();
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        this.m_rayList.setSize(this.m_maximalLightRays);
    }

    public boolean isConvex() {
        return false;
    }

    public void setTransformation(Matrix4f matrix4f) {
        super.setTransformation(matrix4f);
        this.m_env.localToGlobal = new Matrix4f(matrix4f);
        this.m_env.globalToLocal = new Matrix4f(matrix4f);
        this.m_env.globalToLocal.invert();
    }

    public boolean isShadowless() {
        return this.m_isShadowless;
    }

    public boolean isShadeable() {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public int getLightRays(Ray ray, IntersectionDescription intersectionDescription, ShadowProcessor shadowProcessor, RayList rayList) {
        this.m_added = 0;
        this.m_light.generateRandomOrigins((Environment)this.m_env, this.m_rayList, (Random)this.rnd);
        ShadowProcessor shadowProcessor2 = this.m_isShadowless ? this.m_noShadows : shadowProcessor;
        for (int i = 0; i < this.m_maximalLightRays; ++i) {
            this.m_tmpRay1.getOrigin().set((Tuple3f)this.m_rayList.rays[i].origin);
            this.m_tmpRay1.getDirection().set(intersectionDescription.getPoint().x - this.m_rayList.rays[i].origin.x, intersectionDescription.getPoint().y - this.m_rayList.rays[i].origin.y, intersectionDescription.getPoint().z - this.m_rayList.rays[i].origin.z);
            this.m_tmpRay1.getDirection().normalize();
            this.m_rayLength = Raytracer.getT((Ray)this.m_tmpRay1, (Point3f)intersectionDescription.getPoint());
            this.m_rayContext.excludeObject = intersectionDescription.getRTObject();
            if (shadowProcessor2.shadowRay(this.m_tmpRay1, this.m_rayLength, ray, intersectionDescription)) continue;
            this.m_tmpRay2 = rayList.nextRay();
            this.m_tmpRay2.getDirection().set(-this.m_tmpRay1.getDirection().x, -this.m_tmpRay1.getDirection().y, -this.m_tmpRay1.getDirection().z);
            this.m_tmpRay2.getOrigin().set((Tuple3f)intersectionDescription.getPoint());
            this.m_tmpRay2.getColor().set((Tuple3f)this.m_rayList.rays[i].color);
            this.m_out.set((Tuple3f)intersectionDescription.getPoint());
            this.m_out.sub((Tuple3f)this.m_rayList.rays[i].origin);
            this.m_out.normalize();
            this.m_light.computeBSDF((Environment)this.m_env, null, (Spectrum)GroIMPShader.ID, this.m_out, false, (Spectrum)this.m_bsdfColor);
            this.m_tmpRay2.getColor().x *= this.m_bsdfColor.x;
            this.m_tmpRay2.getColor().y *= this.m_bsdfColor.y;
            this.m_tmpRay2.getColor().z *= this.m_bsdfColor.z;
            ++this.m_added;
        }
        return this.m_added;
    }

    public float getDistance(Ray ray, RayContext rayContext) {
        return 0.0f;
    }

    public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
    }

    public BoundingVolume getBoundingVolume() {
        return null;
    }

    public void generateRandomOrigins(RayList rayList, int n) {
        this.m_light.generateRandomOrigins((Environment)this.m_env, rayList, (Random)this.rnd);
    }

    public void generateRandomRays(Vector3f vector3f, RayList rayList, boolean bl, int n) {
        this.m_light.generateRandomRays((Environment)this.m_env, vector3f, (Spectrum)GroIMPShader.ID, rayList, bl, (Random)this.rnd);
    }

    public float computeBSDF(ShadingEnvironment shadingEnvironment, Vector3f vector3f, Vector3f vector3f2, boolean bl, Color3f color3f) {
        float f = this.m_light.computeBSDF((Environment)shadingEnvironment, vector3f, (Spectrum)GroIMPShader.ID, vector3f2, bl, (Spectrum)this.spectrum);
        this.spectrum.get((Tuple3f)color3f);
        return f;
    }

    public Point3f getGlobalOrigin() {
        this.m_light.generateRandomOrigins((Environment)this.m_env, this.m_rayList, (Random)this.rnd);
        return this.m_rayList.rays[0].origin;
    }
}

