/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.ray.RTSphere;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Field;
import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.FieldListPattern;
import de.grogra.xl.query.UserDefinedPattern;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Sphere
extends ShadedNull
implements Pickable,
Renderable,
Raytraceable {
    protected float radius;
    public static final Node.NType $TYPE = new Node.NType((Node)new Sphere());
    public static final Node.NType.Field radius$FIELD = new _Field("radius", 0x200004, Type.FLOAT, null, 0);

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
    }

    public Sphere() {
        this(1.0f);
    }

    public Sphere(float f) {
        this.radius = f;
    }

    public static void pick(float f, Point3d point3d, Vector3d vector3d, PickList pickList) {
        double d = -point3d.x;
        double d2 = -point3d.y;
        double d3 = -point3d.z;
        double d4 = d * vector3d.x + d2 * vector3d.y + d3 * vector3d.z;
        double d5 = vector3d.lengthSquared();
        if ((d = d4 * d4 + d5 * ((double)(f * f) - d * d - d2 * d2 - d3 * d3)) < 0.0) {
            return;
        }
        double d6 = d = d <= 0.0 ? 0.0 : Math.sqrt(d);
        if (d4 >= d) {
            pickList.add((d4 - d) / d5);
        } else if (d4 + d >= 0.0) {
            pickList.add((d4 + d) / d5);
        }
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        GraphState graphState = pickList.getGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                Sphere.pick(this.radius, point3d, vector3d, pickList);
            } else {
                Sphere.pick(graphState.checkFloat((Object)this, true, Attributes.RADIUS, this.radius), point3d, vector3d, pickList);
            }
        } else {
            Sphere.pick(graphState.getFloat(object, bl, Attributes.RADIUS), point3d, vector3d, pickList);
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        GraphState graphState = renderState.getRenderGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                renderState.drawSphere(this.radius, null, -1, null);
            } else {
                renderState.drawSphere(graphState.checkFloat((Object)this, true, Attributes.RADIUS, this.radius), null, -1, null);
            }
        } else {
            renderState.drawSphere(graphState.getFloat(object, bl, Attributes.RADIUS), null, -1, null);
        }
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        float f = 0.0f;
        f = object == this ? (graphState.getInstancingPathIndex() <= 0 ? this.radius : graphState.checkFloat((Object)this, true, Attributes.RADIUS, this.radius)) : graphState.getFloat(object, bl, Attributes.RADIUS);
        return new RTSphere(object, bl, l, f);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Sphere();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)radius$FIELD);
        $TYPE.declareFieldAttribute(radius$FIELD, (Attribute)Attributes.RADIUS);
        Sphere.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((Sphere)object).radius = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Sphere)object).getRadius();
                }
            }
            return super.getFloat(object);
        }
    }

    public static class Pattern
    extends FieldListPattern {
        public Pattern() {
            super((Type)$TYPE, (Field)radius$FIELD);
        }

        public static void signature(@UserDefinedPattern.In @UserDefinedPattern.Out Sphere sphere, float f) {
        }
    }
}

