/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.GraphState;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.LightBase;
import de.grogra.imp3d.ray.RTPointLight;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PointLight
extends LightBase
implements Raytraceable {
    float power = 100.0f;
    float attenuationExponent = 0.0f;
    float attenuationDistance = 1.0f;
    public static final Type $TYPE = new Type(PointLight.class);
    public static final SCOType.Field power$FIELD = Type._addManagedField($TYPE, "power", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field attenuationExponent$FIELD = Type._addManagedField($TYPE, "attenuationExponent", 0x200000, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field attenuationDistance$FIELD = Type._addManagedField($TYPE, "attenuationDistance", 0x200000, de.grogra.reflect.Type.FLOAT, null, 4);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float f) {
        this.power = f;
    }

    public float getAttenuationExponent() {
        return this.attenuationExponent;
    }

    public void setAttenuationExponent(float f) {
        this.attenuationExponent = f;
    }

    public float getAttenuationDistance() {
        return this.attenuationDistance;
    }

    public void setAttenuationDistance(float f) {
        this.attenuationDistance = f;
    }

    public int getLightType() {
        return 1;
    }

    protected float getDensityAt(Vector3f vector3f) {
        return Math2.M_1_2PI / 2.0f;
    }

    public double getTotalPower(Environment environment) {
        return this.power;
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        Matrix4f matrix4f = environment.localToGlobal;
        for (int i = 0; i < rayList.getSize(); ++i) {
            Ray ray = rayList.rays[i];
            ray.origin.set(matrix4f.m03, matrix4f.m13, matrix4f.m23);
            if (i == 0) {
                ray.spectrum.set((Tuple3f)this.color);
                ray.spectrum.scale((double)this.power / ray.spectrum.integrate());
            } else {
                ray.spectrum.set(rayList.rays[0].spectrum);
            }
            ray.originDensity = 1.0E10f;
        }
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        spectrum.setZero();
        return 0.0;
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            int n = random.nextInt();
            float f = 1.0f - 1.5258789E-5f * (float)(2 * (n >>> 16) + 1);
            float f2 = (float)Math.sqrt(1.0f - f * f);
            char c = (char)n;
            Ray ray = rayList.rays[i];
            ray.direction.set(Math2.ccos((char)c) * f2, Math2.csin((char)c) * f2, f);
            environment.localToGlobal.transform(ray.direction);
            ray.direction.normalize();
            ray.spectrum.set(spectrum);
            ray.directionDensity = Math2.M_1_2PI / 2.0f;
        }
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        environment.globalToLocal.transform(vector3f2, environment.userVector);
        environment.userVector.normalize();
        float f = this.getDensityAt(environment.userVector);
        spectrum2.set(spectrum);
        spectrum2.scale((double)f);
        return f;
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        Light light = (Light)graphState.getObjectDefault(object, bl, Attributes.LIGHT, null);
        if (light == null) {
            System.err.println("PointLight::createRaytracerLeaf - light is null");
        }
        if (light.getLightType() != 1) {
            System.err.println("PointLight::createRaytracerLeaf - unexpected light type");
        }
        return new RTPointLight(object, bl, l, light);
    }

    public void accept(LightVisitor lightVisitor) {
        lightVisitor.visit(this);
    }

    static {
        power$FIELD.setQuantity(Quantity.POWER);
        attenuationDistance$FIELD.setQuantity(Quantity.LENGTH);
        $TYPE.validate();
    }

    public static class Type
    extends LightBase.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(PointLight pointLight, SCOType sCOType) {
            super(pointLight, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)LightBase.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((PointLight)object).power = f;
                    return;
                }
                case 3: {
                    ((PointLight)object).attenuationExponent = f;
                    return;
                }
                case 4: {
                    ((PointLight)object).attenuationDistance = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((PointLight)object).getPower();
                }
                case 3: {
                    return ((PointLight)object).getAttenuationExponent();
                }
                case 4: {
                    return ((PointLight)object).getAttenuationDistance();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new PointLight();
        }
    }
}

