/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.LineArray;
import de.grogra.imp3d.LineSegmentizable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ColoredNull;
import de.grogra.imp3d.objects.NURBSSubdivisionHelper;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.Circle;
import de.grogra.math.Pool;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;

public class NURBSCurve
extends ColoredNull
implements LineSegmentizable {
    protected BSplineCurve curve;
    public static final Node.NType $TYPE = new Node.NType((Node)new NURBSCurve());
    public static final Node.NType.Field curve$FIELD = new _Field("curve", 0x200004, (Type)ClassAdapter.wrap(BSplineCurve.class), null, 0);

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.declareAlias("radius", (PersistenceField)curve$FIELD.concat((PersistenceField)Circle.radius$FIELD));
    }

    public NURBSCurve() {
        this((BSplineCurve)null);
    }

    public NURBSCurve(BSplineCurve bSplineCurve) {
        this.curve = bSplineCurve;
        this.setLayer(2);
    }

    public ContextDependent getSegmentizableSource(GraphState graphState) {
        return this.curve;
    }

    public void segmentize(ContextDependent contextDependent, GraphState graphState, LineArray lineArray, float f) {
        lineArray.init(3);
        final Pool pool = Pool.get((GraphState)graphState);
        if (BSpline.isValid((BSplineCurve)this.curve, (GraphState)graphState)) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Helper
            extends NURBSSubdivisionHelper
            implements BSpline.BezierSegmentVisitor {
                private final IntList vertexIndices;

                Helper(LineArray lineArray, boolean bl) {
                    super(lineArray.vertices, bl);
                    this.vertexIndices = lineArray.lines;
                }

                public void visit(int n, float[] fArray, int n2, int n3, float f, float f2) {
                    this.dimension = n2;
                    this.degree = n3;
                    FloatList floatList = pool.fv;
                    floatList.clear();
                    floatList.addAll(fArray, 0, n2 * (n3 + 1));
                    this.vertexIndices.add(this.addVertex(floatList.elements, 0));
                    this.subdivideCurve(floatList, fArray, 0, 0);
                    this.vertexIndices.add(-1);
                }

                protected void visitFlat(float[] fArray, int n) {
                    this.vertexIndices.add(this.addVertex(fArray, n + this.dimension * this.degree));
                }
            }
            Helper helper = new Helper(lineArray, this.curve.isRational(graphState));
            helper.setFlatness(0.001f * f);
            BSpline.decompose((BSpline.BezierSegmentVisitor)helper, (BSplineCurve)this.curve, (boolean)false, (GraphState)graphState);
        }
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new NURBSCurve();
    }

    public BSplineCurve getCurve() {
        return this.curve;
    }

    public void setCurve(BSplineCurve bSplineCurve) {
        curve$FIELD.setObject((Object)this, (Object)bSplineCurve);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)curve$FIELD);
        $TYPE.declareFieldAttribute(curve$FIELD, (Attribute)Attributes.CURVE);
        NURBSCurve.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((NURBSCurve)object).curve = (BSplineCurve)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((NURBSCurve)object).getCurve();
                }
            }
            return super.getObject(object);
        }
    }
}

