/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.msml;

import de.grogra.imp3d.shading.ImageMap;
import de.grogra.math.ChannelMap;
import de.grogra.math.ColorMap;
import de.grogra.math.Tuple3fType;
import de.grogra.msml.MSMLDatatype;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.w3c.dom.Node;

public abstract class X3DMSMLDatatype
implements MSMLDatatype {
    static final String GROIMPDATATYPE_NAMESPACE = "http://grogra.de/msml/datatypes/groimp";
    static final String X3D_NAMESPACE = "http://www.web3d.org/specifications";

    protected static String getStringFromVector3f(Vector3f vector3f) {
        return String.valueOf(vector3f.x) + " " + String.valueOf(vector3f.y) + " " + String.valueOf(vector3f.z);
    }

    protected static String getStringFromVector2f(Vector2f vector2f) {
        return String.valueOf(vector2f.x) + " " + String.valueOf(vector2f.y);
    }

    protected static String getStringFromVector3d(Vector3d vector3d) {
        return String.valueOf(vector3d.x) + " " + String.valueOf(vector3d.y) + " " + String.valueOf(vector3d.z);
    }

    protected static String getStringFromAxisAngle4d(AxisAngle4d axisAngle4d) {
        return String.valueOf(axisAngle4d.x) + " " + String.valueOf(axisAngle4d.y) + " " + String.valueOf(axisAngle4d.z) + " " + String.valueOf(axisAngle4d.angle);
    }

    public static AxisAngle4d convertMatrix2AxisAngle(Matrix3d matrix3d) {
        AxisAngle4d axisAngle4d = new AxisAngle4d();
        axisAngle4d.angle = Math.acos((matrix3d.m00 + matrix3d.m11 + matrix3d.m22 - 1.0) / 2.0);
        if (Math.sin(axisAngle4d.angle) != 0.0) {
            double d = 2.0 * Math.sin(axisAngle4d.angle);
            axisAngle4d.x = (matrix3d.m21 - matrix3d.m12) / d;
            axisAngle4d.y = (matrix3d.m02 - matrix3d.m20) / d;
            axisAngle4d.z = (matrix3d.m10 - matrix3d.m01) / d;
        }
        return axisAngle4d;
    }

    protected static Vector3f getVector3fFromChannelMap(ChannelMap channelMap) {
        Vector3f vector3f = new Vector3f();
        if (channelMap instanceof ColorMap) {
            Tuple3fType.setColor((Tuple3f)vector3f, (int)((ColorMap)channelMap).getAverageColor());
        } else if (channelMap instanceof ImageMap) {
            Tuple3fType.setColor((Tuple3f)vector3f, (int)((ImageMap)channelMap).getAverageColor());
        } else {
            vector3f = null;
        }
        return vector3f;
    }

    protected static Vector2f getVector2fFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        return new Vector2f(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
    }

    protected static Vector3f getVector3fFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        return new Vector3f(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
    }

    protected static AxisAngle4f getAxisAngle4fFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        return new AxisAngle4f(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
    }

    protected static String getStringFromBufferedImage(BufferedImage bufferedImage) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!bufferedImage.equals(null)) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = writableRaster.getNumBands();
            stringBuffer.append("" + n + " " + n2 + " " + n3 + " ");
            StringBuffer stringBuffer2 = new StringBuffer("0x");
            int[] nArray = new int[n3];
            int n4 = n2 - 1;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray = writableRaster.getPixel(j, Math.abs(n4 - i), nArray);
                    switch (n3) {
                        case 1: {
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[0])));
                            break;
                        }
                        case 2: {
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[0])));
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[1])));
                            break;
                        }
                        case 3: {
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[0])));
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[1])));
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[2])));
                            break;
                        }
                        case 4: {
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[0])));
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[1])));
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[2])));
                            stringBuffer2.append(X3DMSMLDatatype.checkLength(Integer.toHexString(nArray[3])));
                        }
                    }
                    stringBuffer.append(stringBuffer2 + " ");
                    stringBuffer2.setLength(0);
                    stringBuffer2.append("0x");
                }
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private static String checkLength(String string) {
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    protected static BufferedImage getBufferedImageFromSFImage(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        BufferedImage bufferedImage = null;
        n = Integer.parseInt(stringTokenizer.nextToken());
        n2 = Integer.parseInt(stringTokenizer.nextToken());
        n3 = Integer.parseInt(stringTokenizer.nextToken());
        switch (n3) {
            case 1: {
                n4 = 10;
                break;
            }
            case 2: {
                n4 = 10;
                break;
            }
            case 3: {
                n4 = 1;
                break;
            }
            case 4: {
                n4 = 2;
            }
        }
        bufferedImage = new BufferedImage(n, n2, n4);
        int n7 = n2 - 1;
        while (stringTokenizer.hasMoreTokens()) {
            bufferedImage.setRGB(n5 % n, n7 - n6, X3DMSMLDatatype.makeColor(stringTokenizer.nextToken(), n3));
            if (++n5 % n != 0) continue;
            ++n6;
        }
        return bufferedImage;
    }

    private static int makeColor(String string, int n) {
        if (n == 4) {
            if (string.toLowerCase().startsWith("0x")) {
                int n2 = string.length();
                String string2 = "0x" + string.substring(n2 - 2, n2);
                String string3 = string.substring(0, n2 - 2);
                return Integer.decode(string2) << 24 | Integer.decode(string3);
            }
            int n3 = Integer.parseInt(string);
            int n4 = n3 >> 8;
            int n5 = n3 & 0xFF;
            return n5 << 24 | n4;
        }
        return Integer.decode(string);
    }

    protected static URL getURLfromString(URL uRL, String string) throws IOException {
        return new URL(uRL, string);
    }

    protected static String getAttributeContent(Node node, String string) {
        String string2 = "";
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            string2 = node2.getNodeValue();
        }
        return string2;
    }
}

