/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.msml;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class CoordTransformer {
    protected Matrix3f baseTransformMatrix = new Matrix3f();
    protected float angleDirection;

    public CoordTransformer(Matrix3f matrix3f, Matrix3f matrix3f2) {
        matrix3f.invert();
        this.baseTransformMatrix.mul(matrix3f, matrix3f2);
        this.angleDirection = this.isRightHandedCS(matrix3f) == this.isRightHandedCS(matrix3f2) ? 1.0f : -1.0f;
    }

    protected boolean isRightHandedCS(Matrix3f matrix3f) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        matrix3f.getColumn(0, vector3f);
        matrix3f.getColumn(1, vector3f2);
        matrix3f.getColumn(2, vector3f3);
        vector3f4.cross(vector3f, vector3f2);
        vector3f4.normalize();
        vector3f3.normalize();
        vector3f4.add((Tuple3f)vector3f3);
        return vector3f4.length() != 0.0f;
    }

    public Point3d transform(Point3d point3d) {
        Matrix3d matrix3d = new Matrix3d(this.baseTransformMatrix);
        matrix3d.invert(matrix3d);
        Point3d point3d2 = new Point3d();
        matrix3d.transform((Tuple3d)point3d, (Tuple3d)point3d2);
        return point3d2;
    }

    public Vector3d transform(Vector3d vector3d) {
        Matrix3d matrix3d = new Matrix3d(this.baseTransformMatrix);
        matrix3d.invert(matrix3d);
        Vector3d vector3d2 = new Vector3d();
        matrix3d.transform((Tuple3d)vector3d, (Tuple3d)vector3d2);
        return vector3d2;
    }

    public Point3f transform(Point3f point3f) {
        Matrix3f matrix3f = new Matrix3f(this.baseTransformMatrix);
        matrix3f.invert(matrix3f);
        Point3f point3f2 = new Point3f();
        matrix3f.transform((Tuple3f)point3f, (Tuple3f)point3f2);
        return point3f2;
    }

    public Vector3f transform(Vector3f vector3f) {
        Matrix3f matrix3f = new Matrix3f(this.baseTransformMatrix);
        matrix3f.invert(matrix3f);
        Vector3f vector3f2 = new Vector3f();
        matrix3f.transform((Tuple3f)vector3f, (Tuple3f)vector3f2);
        return vector3f2;
    }

    public AxisAngle4f transform(AxisAngle4f axisAngle4f) {
        Matrix3f matrix3f = new Matrix3f(this.baseTransformMatrix);
        matrix3f.invert(matrix3f);
        Vector3f vector3f = new Vector3f();
        matrix3f.transform((Tuple3f)new Vector3f(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z), (Tuple3f)vector3f);
        return new AxisAngle4f(vector3f.x, vector3f.y, vector3f.z, this.angleDirection * axisAngle4f.angle);
    }

    public AxisAngle4d transform(AxisAngle4d axisAngle4d) {
        Matrix3d matrix3d = new Matrix3d(this.baseTransformMatrix);
        matrix3d.invert(matrix3d);
        Vector3d vector3d = new Vector3d();
        matrix3d.transform((Tuple3d)new Vector3d(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z), (Tuple3d)vector3d);
        return new AxisAngle4d(vector3d.x, vector3d.y, vector3d.z, (double)this.angleDirection * axisAngle4d.angle);
    }

    public Matrix3f transform(Matrix3f matrix3f) {
        Matrix3f matrix3f2 = new Matrix3f(this.baseTransformMatrix);
        Matrix3f matrix3f3 = new Matrix3f();
        matrix3f3.mul(matrix3f, matrix3f2);
        matrix3f2 = new Matrix3f(this.baseTransformMatrix);
        matrix3f2.invert(matrix3f2);
        matrix3f3.mul(matrix3f2, matrix3f3);
        return matrix3f3;
    }

    public Matrix3d transform(Matrix3d matrix3d) {
        Matrix3d matrix3d2 = new Matrix3d(this.baseTransformMatrix);
        Matrix3d matrix3d3 = new Matrix3d();
        matrix3d3.mul(matrix3d, matrix3d2);
        matrix3d2 = new Matrix3d(this.baseTransformMatrix);
        matrix3d2.invert(matrix3d2);
        matrix3d3.mul(matrix3d2, matrix3d3);
        return matrix3d3;
    }

    public Matrix4f transform(Matrix4f matrix4f) {
        Matrix3f matrix3f = new Matrix3f(matrix4f.m00, matrix4f.m01, matrix4f.m02, matrix4f.m10, matrix4f.m11, matrix4f.m12, matrix4f.m20, matrix4f.m21, matrix4f.m22);
        Vector3f vector3f = new Vector3f(matrix4f.m03, matrix4f.m13, matrix4f.m23);
        matrix3f = this.transform(matrix3f);
        vector3f = this.transform(vector3f);
        Matrix4f matrix4f2 = new Matrix4f(matrix3f.m00, matrix3f.m01, matrix3f.m02, vector3f.x, matrix3f.m10, matrix3f.m11, matrix3f.m12, vector3f.y, matrix3f.m20, matrix3f.m21, matrix3f.m22, vector3f.z, 0.0f, 0.0f, 0.0f, 1.0f);
        return matrix4f2;
    }

    public Matrix4d transform(Matrix4d matrix4d) {
        Matrix3d matrix3d = new Matrix3d(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m20, matrix4d.m21, matrix4d.m22);
        Vector3d vector3d = new Vector3d(matrix4d.m03, matrix4d.m13, matrix4d.m23);
        matrix3d = this.transform(matrix3d);
        vector3d = this.transform(vector3d);
        return new Matrix4d(matrix3d.m00, matrix3d.m01, matrix3d.m02, vector3d.x, matrix3d.m10, matrix3d.m11, matrix3d.m12, vector3d.y, matrix3d.m20, matrix3d.m21, matrix3d.m22, vector3d.z, 0.0, 0.0, 0.0, 1.0);
    }
}

