/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.GLSLOpenGLObject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;

public class GLSLTexture
implements GLSLOpenGLObject {
    protected int width;
    protected int height;
    protected int index = 0;
    protected int internalFormat;
    protected int texType;
    protected int type;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType() {
        return this.type;
    }

    public int getTexType() {
        return this.texType;
    }

    boolean create(GL gL, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.create(gL, n, n2, n3, n4, n5, n6, 3553);
    }

    boolean create(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = new int[1];
        if (this.index != 0 && this.internalFormat == n4 && this.texType == n7 && this.height == n2 && this.width == n) {
            return true;
        }
        if (this.index != 0) {
            this.delete(gL, false);
        }
        gL.glGenTextures(1, nArray, 0);
        this.index = nArray[0];
        gL.glBindTexture(n7, this.getIndex());
        gL.glTexParameteri(n7, 10240, n3);
        gL.glTexParameteri(n7, 10241, n3);
        gL.glTexImage2D(n7, 0, n4, n, n2, 0, n5, n6, null);
        this.width = n;
        this.height = n2;
        this.type = n6;
        this.internalFormat = n4;
        this.texType = n7;
        return gL.glGetError() != 0;
    }

    boolean createFloat(GL gL, int n, int n2, float[] fArray) {
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        this.index = nArray[0];
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray);
        gL.glBindTexture(3553, this.getIndex());
        gL.glTexParameterf(3553, 10242, 33071.0f);
        gL.glTexParameterf(3553, 10243, 33071.0f);
        gL.glTexParameteri(3553, 10240, 9728);
        gL.glTexParameteri(3553, 10241, 9728);
        gL.glTexImage2D(3553, 0, 34840, n, n2, 0, 6409, 5126, (Buffer)floatBuffer);
        this.type = 5126;
        this.internalFormat = 34840;
        this.texType = 3553;
        this.width = n;
        this.height = n2;
        return gL.glGetError() != 0;
    }

    public void bindTo(GL gL, int n) {
        gL.glActiveTexture(n);
        gL.glBindTexture(this.texType, this.index);
    }

    boolean createByte(GL gL, int n, int[] nArray) {
        int[] nArray2 = new int[1];
        gL.glGenTextures(1, nArray2, 0);
        this.index = nArray2[0];
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        gL.glBindTexture(3553, this.getIndex());
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexImage2D(3553, 0, 6408, n, n, 0, 32993, 5121, (Buffer)intBuffer);
        this.internalFormat = 6408;
        this.texType = 3553;
        this.type = 5121;
        this.width = n;
        this.height = n;
        return gL.glGetError() != 0;
    }

    public void delete(GL gL, boolean bl) {
        if (this.index == 0) {
            return;
        }
        int[] nArray = new int[]{this.index};
        if (!bl) {
            gL.glDeleteTextures(1, nArray, 0);
        }
        this.index = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void cleanup(OpenGLState openGLState, boolean bl) {
        this.delete(openGLState.getGL(), bl);
    }

    private int estimateBPP() {
        switch (this.internalFormat) {
            case 6408: {
                return 4;
            }
            case 34840: {
                return 4;
            }
            case 34842: {
                return 8;
            }
            case 32856: {
                return 4;
            }
            case 6402: {
                return 3;
            }
            case 34836: {
                return 16;
            }
            case 36214: {
                return 8;
            }
        }
        return 0;
    }

    public int estimateSizeInByte() {
        if (this.index == 0) {
            return 0;
        }
        return this.width * this.height * this.estimateBPP() * (this.texType == 34067 ? 6 : 1);
    }
}

