/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.GLSLOpenGLObject;
import javax.media.opengl.GL;

public abstract class GLSLShader
implements GLSLOpenGLObject {
    static final String[] vStdSrc = new String[]{"#version 110\n", "varying vec3 normal;", "varying vec4 pos;", "varying vec3 n_pos;", "varying vec3 g_pos;", "varying vec4 u_pos;", "varying vec2 uv;", "varying vec2 TexUnit2;", "void main() {", " uv = gl_MultiTexCoord0.st;", " TexUnit2 = gl_MultiTexCoord1.st;", " gl_Position = ftransform();", " u_pos = gl_Position;", " pos = gl_ModelViewMatrix * gl_Vertex;", " n_pos = gl_Vertex.xyz;", " g_pos = (gl_TextureMatrix[3]*gl_Vertex).xyz;", " normal = normalize(gl_NormalMatrix * gl_Normal);", "}"};
    static final int PROGRAM = 0;
    static final int VERTEX_SHADER = 1;
    static final int FRAGMENT_SHADER = 2;
    private int[] GLSLProgramNumber = new int[]{0, 0, 0};

    public GLSLShader(OpenGLState openGLState) {
        if (openGLState != null) {
            openGLState.staticObjects.add(this);
        }
    }

    private static void printShaderInfoLog(GL gL, int n) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        gL.glGetShaderiv(n, 35716, nArray, 0);
        if (nArray[0] > 0) {
            GLSLDisplay.printDebugInfoN("Shader-Log for " + n);
            byte[] byArray = new byte[nArray[0]];
            gL.glGetShaderInfoLog(n, nArray[0], nArray2, 0, byArray, 0);
            String string = new String(byArray);
            GLSLDisplay.printDebugInfoN(string);
        }
    }

    protected static void printProgramInfoLog(GL gL, int n) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        gL.glGetProgramiv(n, 35716, nArray, 0);
        if (nArray[0] > 0) {
            GLSLDisplay.printDebugInfoN("Program-Log for " + n);
            byte[] byArray = new byte[nArray[0]];
            gL.glGetProgramInfoLog(n, nArray[0], nArray2, 0, byArray, 0);
            String string = new String(byArray);
            GLSLDisplay.printDebugInfoN(string);
        }
    }

    private static int[] compileShader(GL gL, String[] stringArray, String[] stringArray2) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[1];
        nArray[1] = gL.glCreateShader(35633);
        nArray[2] = gL.glCreateShader(35632);
        gL.glShaderSource(nArray[1], stringArray2.length, stringArray2, (int[])null, 0);
        gL.glCompileShader(nArray[1]);
        GLSLShader.printShaderInfoLog(gL, nArray[1]);
        gL.glShaderSource(nArray[2], stringArray.length, stringArray, (int[])null, 0);
        gL.glCompileShader(nArray[2]);
        GLSLShader.printShaderInfoLog(gL, nArray[2]);
        if (GLSLDisplay.DEBUG) {
            GLSLDisplay.printDebugInfoN("--- Compiled fragment program");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
            GLSLDisplay.printDebugInfoN("---");
        }
        nArray[0] = gL.glCreateProgram();
        gL.glAttachShader(nArray[0], nArray[1]);
        gL.glAttachShader(nArray[0], nArray[2]);
        gL.glLinkProgram(nArray[0]);
        return nArray;
    }

    public int getShaderProgramNumber() {
        return this.GLSLProgramNumber[0];
    }

    public boolean needsRecompilation(Object object) {
        return false;
    }

    public Class instanceFor() {
        return null;
    }

    public GLSLShader getInstance() {
        return this;
    }

    protected String[] getVertexShader(Object object) {
        return vStdSrc;
    }

    protected abstract String[] getFragmentShader(Object var1);

    protected void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
    }

    protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
    }

    public void activateShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay, Object object) {
        GL gL = openGLState.getGL();
        if (this.getShaderProgramNumber() == 0 || this.needsRecompilation(object)) {
            if (this.getShaderProgramNumber() != 0) {
                this.deleteShader(gL, false);
            }
            this.GLSLProgramNumber = GLSLShader.compileShader(gL, this.getFragmentShader(object), this.getVertexShader(object));
            openGLState.setActiveProgram(this.getShaderProgramNumber());
            this.setupShader(gL, gLSLDisplay, object);
        }
        if (!GLSLDisplay.DEBUG) {
            openGLState.setActiveProgram(this.getShaderProgramNumber());
        } else {
            openGLState.setActiveProgram(this.getShaderProgramNumber());
        }
        this.setupDynamicUniforms(gL, gLSLDisplay, object, this.getShaderProgramNumber());
        if (this.getShaderProgramNumber() == 0) {
            GLSLDisplay.printDebugInfoN("! Error activating Shader: " + this);
        }
        if (GLSLDisplay.DEBUG) {
            gL.glValidateProgram(this.getShaderProgramNumber());
            int[] nArray = new int[1];
            gL.glGetProgramiv(this.getShaderProgramNumber(), 35715, nArray, 0);
            if (nArray[0] == 0) {
                GLSLShader.printProgramInfoLog(gL, this.getShaderProgramNumber());
            }
        }
    }

    public void deleteShader(GL gL, boolean bl) {
        if (this.GLSLProgramNumber[0] == 0) {
            return;
        }
        if (!bl) {
            gL.glDetachShader(this.GLSLProgramNumber[0], this.GLSLProgramNumber[1]);
            gL.glDetachShader(this.GLSLProgramNumber[0], this.GLSLProgramNumber[2]);
            gL.glDeleteShader(this.GLSLProgramNumber[1]);
        }
        this.GLSLProgramNumber[1] = 0;
        if (!bl) {
            gL.glDeleteShader(this.GLSLProgramNumber[2]);
        }
        this.GLSLProgramNumber[2] = 0;
        if (!bl) {
            gL.glDeleteProgram(this.GLSLProgramNumber[0]);
        }
        this.GLSLProgramNumber[0] = 0;
        gL.glGetError();
    }

    public void cleanup(OpenGLState openGLState, boolean bl) {
        this.deleteShader(openGLState.getGL(), bl);
    }
}

