/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.glsl.GLSLDisplay;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class FrustumCullingTester {
    boolean isPerspective;
    float angleX;
    float near;
    float far;
    float fov;
    float sphereFactorX;
    float sphereFactorY;
    float ratio;
    float width;
    float height;
    Vector3d X = new Vector3d(1.0, 0.0, 0.0);
    Vector3d Y = new Vector3d(0.0, 1.0, 0.0);
    Vector3d Z = new Vector3d(0.0, 0.0, -1.0);

    public void setupViewFrustum(GLSLDisplay gLSLDisplay) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        this.far = camera.getZFar();
        this.near = camera.getZNear();
        this.ratio = camera.getProjection().getAspect();
        if (camera.getProjection() instanceof ParallelProjection) {
            ParallelProjection parallelProjection = (ParallelProjection)camera.getProjection();
            this.isPerspective = false;
            this.width = parallelProjection.getWidth();
            this.height = this.width * this.ratio;
        } else if (camera.getProjection() instanceof PerspectiveProjection) {
            PerspectiveProjection perspectiveProjection = (PerspectiveProjection)camera.getProjection();
            this.isPerspective = true;
            this.fov = PerspectiveProjection.clampFieldOfView(perspectiveProjection.getFieldOfView());
            double d = Math.tan(this.fov);
            this.height = (float)((double)this.near * d);
            this.width = this.height * this.ratio;
            this.sphereFactorX = (float)(1.0 / Math.cos(this.fov));
            double d2 = Math.atan(d * (double)this.ratio);
            this.sphereFactorY = (float)(1.0 / Math.cos(d2));
        }
    }

    boolean isPointInFrustum(Matrix4d matrix4d) {
        if (-matrix4d.m32 > (double)this.far || -matrix4d.m32 < (double)this.near) {
            return false;
        }
        double d = -matrix4d.m32 * (double)this.fov;
        if (matrix4d.m31 > d || matrix4d.m31 < -d) {
            return false;
        }
        return !(matrix4d.m30 > (d *= (double)this.ratio)) && !(matrix4d.m30 < -d);
    }

    boolean isSphereInFrustum(Matrix4d matrix4d, float f) {
        if ((double)f < 0.0) {
            return this.isPointInFrustum(matrix4d);
        }
        double d = -matrix4d.m33;
        if (d > (double)(this.far + f) || d < (double)(this.near - f)) {
            return false;
        }
        double d2 = this.sphereFactorY * f;
        if (matrix4d.m31 > (d *= (double)this.fov) + d2 || matrix4d.m31 < -d - d2) {
            return false;
        }
        d2 = this.sphereFactorX * f;
        return !(matrix4d.m30 > (d *= (double)this.ratio) + d2) && !(matrix4d.m30 < -d - d2);
    }
}

