/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass.nostencil;

import com.sun.opengl.util.GLUT;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.RenderPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import java.awt.Dimension;
import javax.media.opengl.GL;

public class PresentDebugImagePass
extends RenderPass {
    GLSLRenderImage presentShader = null;
    TextureCollection txC = new TextureCollection();
    private final GLUT glut = new GLUT();
    private static final float[] black = new float[]{0.0f, 0.0f, 0.0f, 1.0f};

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        openGLState.setDepthMask(true);
        openGLState.enable('\u0002');
        PresentDebugImagePass.deactivateTextures(gL, 1, 34037);
        PresentDebugImagePass.ViewPerspective(openGLState);
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        GL gL = openGLState.getGL();
        PresentDebugImagePass.ViewOrtho(openGLState);
        openGLState.setFBO(0);
        if (this.presentShader == null) {
            this.presentShader = new GLSLRenderImage(openGLState);
        }
        this.presentShader.activateShader(openGLState, gLSLDisplay, new Boolean(false));
        openGLState.disable('\u0002');
        openGLState.setDepthMask(false);
        gL.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL.glClear(16384);
    }

    void activate(OpenGLState openGLState, int n) {
        switch (n) {
            case 0: {
                openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 0, 0);
                break;
            }
            case 1: {
                openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 1, 0);
                break;
            }
            case 2: {
                openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, 0, 0);
                break;
            }
            case 3: {
                openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 2, 0);
                break;
            }
            case 4: {
                openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 3, 0);
                break;
            }
            case 5: {
                openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, 1, 0);
                break;
            }
            case 6: {
                openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 0, 0);
                break;
            }
            case 7: {
                openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 1, 0);
                break;
            }
            default: {
                PresentDebugImagePass.deactivateTextures(openGLState.getGL(), 1);
            }
        }
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        Camera camera = gLSLDisplay.getView3D().getCamera();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.txC.showStencil[i * 3 + j]) continue;
                int n = gL.glGetUniformLocation(this.presentShader.getShaderProgramNumber(), "showAlpha");
                gL.glUniform1i(n, this.txC.showAlpha[i * 3 + j] ? 1 : 0);
                this.activate(openGLState, i * 3 + j);
                PresentDebugImagePass.drawPrjQuad(openGLState, camera, j * (openGLState.width / 3), i * (openGLState.height / 3), openGLState.width / 3, openGLState.height / 3);
            }
        }
    }

    protected void drawString(GL gL, GLSLDisplay gLSLDisplay, String string, int n, int n2) {
        int n3 = gLSLDisplay.getView().getSize().width;
        int n4 = gLSLDisplay.getView().getSize().height;
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(-5.0, 5.0, -5.0, 5.0, 0.0, 100.0);
        gL.glViewport(2 * n3 / 3 + n, n4 / 3 - 30 - n2, 100, 30);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glDisable(2903);
        gL.glClear(256);
        gL.glLoadIdentity();
        gL.glMaterialfv(1028, 5634, black, 0);
        gL.glRasterPos3d(-4.0, 0.0, 0.0);
        this.glut.glutBitmapString(7, string);
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glEnable(2903);
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
    }

    public class TextureCollection {
        int[] img;
        boolean[] showAlpha = new boolean[]{false, false, false, false, false, false, true, true, false};
        boolean[] showStencil = new boolean[]{false, false, false, false, false, false, false, false, true};

        public TextureCollection() {
            this.img = new int[9];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GLSLRenderImage
    extends GLSLShader {
        String[] shaderF;

        public GLSLRenderImage(OpenGLState openGLState) {
            super(openGLState);
            this.shaderF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect tex;\n", "uniform vec2 size;\n", "uniform bool showAlpha;\n", "varying vec2 uv;\n", "void main() {\n", "\tvec4 col = texture2DRect(tex, uv * size);", "\tcol.rgb = showAlpha ? vec3(col.a) : col.rgb;\n", "\tgl_FragColor = clamp(vec4(col.rgb, 1.0), 0.0, 1.0);\n", "}"};
        }

        @Override
        protected String[] getFragmentShader(Object object) {
            return this.shaderF;
        }

        @Override
        public GLSLShader getInstance() {
            return null;
        }

        @Override
        public Class<?> instanceFor() {
            return null;
        }

        @Override
        public boolean needsRecompilation(Object object) {
            return false;
        }

        @Override
        protected void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
            assert (object instanceof Boolean);
            int n2 = gL.glGetUniformLocation(n, "size");
            int n3 = gL.glGetUniformLocation(n, "showAlpha");
            Dimension dimension = gLSLDisplay.getView3D().getSize();
            gL.glUniform2f(n2, (float)dimension.width, (float)dimension.height);
            gL.glUniform1i(n3, (Boolean)object != false ? 1 : 0);
        }

        @Override
        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "tex");
            gL.glUniform1i(n, 0);
        }
    }
}

