/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass.nostencil;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.renderpass.nostencil.CopyFloatTexturePass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class DrawTranspBackgroundPass
extends FullRenderPass {
    GLSLShader presentCheckboardBG = null;
    CopyFloatTexturePass cftp = new CopyFloatTexturePass();

    protected int getID() {
        return 3;
    }

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        openGLState.setDepthMask(true);
        DrawTranspBackgroundPass.ViewPerspective(openGLState);
        gL.glPopAttrib();
        DrawTranspBackgroundPass.deactivateTextures(gL, 2);
        openGLState.enable('\u0002');
        openGLState.disable('\u0001');
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        GL gL = openGLState.getGL();
        openGLState.getHDRFBO().attachDepthStencil(openGLState, openGLState.getDepthRB());
        gL.glStencilFunc(518, 1, 3);
        gL.glStencilOp(7680, 7680, 7680);
        openGLState.enable('\u0001');
        this.cftp.process(gLSLDisplay, openGLState, null);
        openGLState.switchFloatRT();
        GLSLDisplay.printDebugInfoN("Render Transp BG to: " + (4 + openGLState.getFloatRT()));
        openGLState.getHDRFBO().drawBuffer(openGLState, openGLState.getFloatRT());
        gL.glPushAttrib(2048);
        openGLState.disable('\u0002');
        openGLState.enable('\u0001');
        gL.glStencilFunc(514, 0, 3);
        gL.glStencilOp(7680, 7680, 7680);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRTLast(), 0);
        openGLState.getAlphaFBO().bindAttachmentAsTexture(openGLState, 0, 1);
        if (this.presentCheckboardBG == null) {
            this.presentCheckboardBG = new CheckBoardBGShader(openGLState);
        }
        this.presentCheckboardBG.activateShader(openGLState, gLSLDisplay, gLSLDisplay);
        DrawTranspBackgroundPass.ViewOrtho(openGLState);
        openGLState.setDepthMask(false);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        DrawTranspBackgroundPass.drawPrjQuad(openGLState, camera);
    }

    class CheckBoardBGShader
    extends GLSLShader {
        final String[] checkboardF;

        public CheckBoardBGShader(OpenGLState openGLState) {
            super(openGLState);
            this.checkboardF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect inputTex;\n", "uniform sampler2DRect alphaTex;\n", "float checkBoard() {\n", " \tfloat tmp = (mod(floor(0.05* gl_FragCoord.x) + floor(0.05* gl_FragCoord.y),2.0));\n", "\treturn tmp*0.15 + 0.6;\n", "}\n", "void main() {\n", " vec4 lastCol = texture2DRect(inputTex, gl_FragCoord.st);\n", " vec4 alpha = texture2DRect(alphaTex, gl_FragCoord.st);\n", " gl_FragColor = clamp(vec4(alpha.rgb, 1.0) * vec4(checkBoard()) + lastCol, 0.0, 1.0);\n", "}"};
        }

        protected String[] getFragmentShader(Object object) {
            return this.checkboardF;
        }

        public GLSLShader getInstance() {
            return this;
        }

        public Class instanceFor() {
            return null;
        }

        public boolean needsRecompilation(Object object) {
            return false;
        }

        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 0);
            int n2 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "alphaTex");
            gL.glUniform1i(n2, 1);
        }
    }
}

