/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass.nostencil;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class CopyFloatTexturePass
extends FullRenderPass {
    GLSLShader cs = null;

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        openGLState.disable('\u0001');
        openGLState.setDepthMask(true);
        openGLState.enable('\u0002');
        CopyFloatTexturePass.deactivateTextures(gL, 1);
        CopyFloatTexturePass.ViewPerspective(openGLState);
        gL.glPopAttrib();
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        GLSLDisplay.printDebugInfoN("Copying: " + (4 + openGLState.getFloatRT()) + " to " + (4 + openGLState.getFloatRTLast()));
        openGLState.getHDRFBO().drawBuffer(openGLState, openGLState.getFloatRTLast());
        gL.glPushAttrib(2048);
        gL.glViewport(0, 0, openGLState.width, openGLState.height);
        if (this.cs == null) {
            this.cs = new CopyFloatTextureShader(openGLState);
        }
        this.cs.activateShader(openGLState, gLSLDisplay, null);
        CopyFloatTexturePass.ViewOrtho(openGLState);
        openGLState.disable('\u0002');
        openGLState.setDepthMask(false);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRT(), 0);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        CopyFloatTexturePass.drawPrjQuad(openGLState, camera);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyFloatTextureShader
    extends GLSLShader {
        final String[] baseLightF;

        public CopyFloatTextureShader(OpenGLState openGLState) {
            super(openGLState);
            this.baseLightF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect inputTex;\n", "void main() {\n", "\tgl_FragColor = texture2DRect(inputTex, gl_FragCoord.st);\n", "}"};
        }

        @Override
        public String[] getFragmentShader(Object object) {
            return this.baseLightF;
        }

        @Override
        public boolean needsRecompilation(Object object) {
            return false;
        }

        @Override
        public Class<?> instanceFor() {
            return null;
        }

        @Override
        public void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 0);
        }

        @Override
        public GLSLShader getInstance() {
            return this;
        }
    }
}

