/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.ExtractLayerPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import java.awt.Dimension;
import javax.media.opengl.GL;

public class ExtractSucessiveLayerPass
extends ExtractLayerPass {
    protected GLSLShader sdt = null;

    protected int getID() {
        return 1;
    }

    protected void loadTexture(OpenGLState openGLState) {
        GL gL = openGLState.getGL();
        openGLState.getDualDepthFBO().bind(openGLState);
        openGLState.getPeelingNearDepthTRT().bindTo(openGLState, 0);
        gL.glDrawBuffer(0);
        gL.glReadBuffer(0);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        gL.glBeginQuery(35092, openGLState.occlusionQuery[0]);
        if (this.sdt == null) {
            this.sdt = new ExtractSucessiveLayerShader(openGLState);
        }
        this.sdt.activateShader(openGLState, gLSLDisplay, null);
        this.renderVector(gLSLDisplay, openGLState.getWorldToView(), true, openGLState.deferredTranspRenderable);
        gL.glEndQuery(35092);
    }

    class ExtractSucessiveLayerShader
    extends GLSLShader {
        final String[] vStdSrc;
        final String[] simpleDepthF;
        int screenDimLoc;

        public ExtractSucessiveLayerShader(OpenGLState openGLState) {
            super(openGLState);
            this.vStdSrc = new String[]{"#version 110\n", "varying vec3 normal;\n", "void main() {", "\tgl_Position = ftransform();", "}"};
            this.simpleDepthF = new String[]{"#version 110\n", "uniform sampler2D DepthMinTex;\n", "uniform sampler2D DepthMaxTex;\n", "uniform vec2 screenDim;\n", "void main(void)\n", "{\n", "\tfloat fragDepth = gl_FragCoord.z;\n", "\tfloat nearestDepth = texture2D(DepthMinTex, gl_FragCoord.xy*screenDim).r;\n", "\tfloat farthestDepth = texture2D(DepthMaxTex, gl_FragCoord.xy*screenDim).r;\n", "\tif (fragDepth <= nearestDepth || gl_FragCoord.z >= farthestDepth) {\n", "\t\tdiscard;\n", "\t}\n", "\tgl_FragColor = vec4(1.0);\n", "}"};
            this.screenDimLoc = -1;
        }

        protected String[] getVertexShader(Object object) {
            return this.vStdSrc;
        }

        protected String[] getFragmentShader(Object object) {
            return this.simpleDepthF;
        }

        protected void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
            Dimension dimension = gLSLDisplay.getView().getSize();
            gL.glUniform2f(this.screenDimLoc, 1.0f / (float)dimension.width, 1.0f / (float)dimension.height);
        }

        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "DepthMinTex");
            int n2 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "DepthMaxTex");
            gL.glUniform1i(n, 0);
            gL.glUniform1i(n2, 1);
            this.screenDimLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), "screenDim");
        }
    }
}

