/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.material.channel.GLSLFloatToFloat;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.math.Abs;
import de.grogra.math.Acos;
import de.grogra.math.Asin;
import de.grogra.math.Atan;
import de.grogra.math.Ceil;
import de.grogra.math.Cos;
import de.grogra.math.Cosh;
import de.grogra.math.Cubic;
import de.grogra.math.E;
import de.grogra.math.Exp;
import de.grogra.math.Exp2;
import de.grogra.math.Expm1;
import de.grogra.math.Floor;
import de.grogra.math.Log;
import de.grogra.math.Log10;
import de.grogra.math.Phi;
import de.grogra.math.Pi;
import de.grogra.math.Ramp;
import de.grogra.math.Scallop;
import de.grogra.math.Sin;
import de.grogra.math.Sin01;
import de.grogra.math.Sinh;
import de.grogra.math.Sqr;
import de.grogra.math.Sqrt;
import de.grogra.math.Tan;
import de.grogra.math.Tanh;
import de.grogra.math.Triangle;
import de.grogra.vecmath.Math2;
import de.grogra.xl.lang.FloatToFloat;
import java.util.HashMap;

public class FloatToFloatCollection {
    static HashMap<Class, GLSLFloatToFloat> ftf = new HashMap();

    private static void insertIntoHashMap(GLSLFloatToFloat gLSLFloatToFloat) {
        ftf.put(gLSLFloatToFloat.instanceFor(), gLSLFloatToFloat);
    }

    public static void initMap() {
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Abs.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("abs(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Acos.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("acos(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Asin.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("asin(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Atan.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("atan(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Ceil.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("ceil(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Cos.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("cos(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Cosh.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                String string = shaderConfiguration.registerNewTmpVar(0, result.convert(0));
                return new Result("((exp(" + string + ")+exp(-" + string + "))*0.5)", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Cubic.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                String string = shaderConfiguration.registerNewTmpVar(0, result.convert(0));
                String string2 = shaderConfiguration.registerNewTmpVar(0, string + "-floor(" + string + ")");
                String string3 = shaderConfiguration.registerNewTmpVar(0, string2 + "<0.?" + string2 + "+1.<0.?0.:" + string2 + "+1.:" + string2 + ">1.?1.:" + string2);
                return new Result("(" + string3 + "*" + string3 + "*(6.-4.*" + string3 + ")-1.)", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return E.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("(2.7182818284590452354*" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Exp.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("exp(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Exp2.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("exp2(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Expm1.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("exp(" + result.convert(0) + "-1.)", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Floor.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("floor(" + result.convert(0) + "-1.)", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Log.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("log(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){
            private final double M_1_LN10 = 1.0 / Math.log(10.0);

            @Override
            public Class<?> instanceFor() {
                return Log10.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("log(" + result.convert(0) + ")*" + this.M_1_LN10, 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Log.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("log(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){
            private final double factor = (Math.sqrt(5.0) + 1.0) / 2.0;

            @Override
            public Class<?> instanceFor() {
                return Phi.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result(result.convert(0) + "*" + this.factor, 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Pi.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result(result.convert(0) + "*" + Math.PI, 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){
            private final double factor = Math.PI / 180;

            @Override
            public Class<?> instanceFor() {
                return Phi.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result(result.convert(0) + "*" + Math.PI / 180, 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Ramp.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                String string = shaderConfiguration.registerNewTmpVar(0, result.convert(0));
                String string2 = shaderConfiguration.registerNewTmpVar(0, string + "-floor(" + string + ")");
                return new Result("2.*(" + string2 + "<0.?" + string2 + "+1.<0.?0.:" + string2 + "+1.:" + string2 + ">1.?1.:" + string2 + ")-1.", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Scallop.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("2.*abs(sin(" + result.convert(0) + "*" + Math.PI + "))-1.", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Sin.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("sin(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Sin01.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("sin(" + result.convert(0) + "*" + Math2.M_2PI + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Sinh.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                String string = shaderConfiguration.registerNewTmpVar(0, result.convert(0));
                return new Result("((exp(" + string + ")-exp(-" + string + "))*0.5)", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Sqr.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                String string = shaderConfiguration.registerNewTmpVar(0, result.convert(0));
                return new Result(string + "*" + string, 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Sqrt.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("sqrt(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Tan.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                return new Result("tan(" + result.convert(0) + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Tanh.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                String string = shaderConfiguration.registerNewTmpVar(0, result.convert(0));
                String string2 = shaderConfiguration.registerNewTmpVar(0, "exp(" + string + ")");
                String string3 = shaderConfiguration.registerNewTmpVar(0, "exp(-" + string + ")");
                return new Result("(" + string2 + "-" + string3 + ")/(" + string2 + "+" + string3 + ")", 0);
            }
        });
        FloatToFloatCollection.insertIntoHashMap(new GLSLFloatToFloat(){

            @Override
            public Class<?> instanceFor() {
                return Triangle.class;
            }

            @Override
            public Result process(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
                String string = shaderConfiguration.registerNewTmpVar(0, result.convert(0));
                String string2 = shaderConfiguration.registerNewTmpVar(0, string + "-floor(" + string + ")");
                String string3 = shaderConfiguration.registerNewTmpVar(0, string2 + "<0.?" + string2 + "+1.<0.?0.:" + string2 + "+1.:" + string2 + ">1.?1.:" + string2);
                return new Result("(" + string3 + " < 0.25) ? 4. * " + string3 + " : (" + string3 + " < 0.75) ? -4. * " + string3 + " + 2. : 4. * " + string3 + " - 4.", 0);
            }
        });
    }

    public static Result addFloatToFloat(Result result, FloatToFloat floatToFloat, ShaderConfiguration shaderConfiguration) {
        GLSLFloatToFloat gLSLFloatToFloat = floatToFloat != null ? ftf.get(floatToFloat.getClass()) : null;
        return gLSLFloatToFloat != null ? gLSLFloatToFloat.process(result, floatToFloat, shaderConfiguration) : result;
    }
}

