/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.material.GLSLMaterial;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.shading.SunSkyLight;
import javax.vecmath.Vector3d;
import org.sunflow.math.MathUtils;

public class GLSLSunSky
extends GLSLMaterial {
    int oldStamp = -1;

    public Class instanceFor() {
        return SunSkyLight.class;
    }

    protected Result[] getAllChannels(Object object) {
        assert (object instanceof SunSkyLight);
        SunSkyLight sunSkyLight = (SunSkyLight)object;
        this.config.setVersion(110);
        double d = sunSkyLight.getTurbidity();
        GLSLDisplay.printDebugInfoN(" - SunSky: Turbidity: " + sunSkyLight.getTurbidity());
        Vector3d vector3d = new Vector3d(sunSkyLight.getSun());
        vector3d.normalize();
        GLSLDisplay.printDebugInfoN(" - SunSky: SunDir: " + vector3d);
        double d2 = MathUtils.clamp((double)vector3d.z, (double)-1.0, (double)1.0);
        double d3 = Math.acos(d2);
        double d4 = (0.4444444444444444 - d / 120.0) * (Math.PI - 2.0 * d3);
        double d5 = 0.1787 * d - 1.463;
        double d6 = -0.3554 * d + 0.4275;
        double d7 = -0.0227 * d + 5.3251;
        double d8 = 0.1206 * d - 2.5771;
        double d9 = -0.067 * d + 0.3703;
        double d10 = (4.0453 * d - 4.971) * Math.tan(d4) - 0.2155 * d + 2.4192;
        double d11 = -0.0193 * d - 0.2592;
        double d12 = -0.0665 * d + 8.0E-4;
        double d13 = -4.0E-4 * d + 0.2125;
        double d14 = -0.0641 * d - 0.8989;
        double d15 = -0.0033 * d + 0.0452;
        double d16 = new Vector3d(d * d, d, 1.0).dot(new Vector3d(0.0017 * d3 * d3 * d3 - 0.0037 * d3 * d3 + 0.0021 * d3, -0.029 * d3 * d3 * d3 + 0.0638 * d3 * d3 - 0.032 * d3 + 0.0039, 0.1169 * d3 * d3 * d3 - 0.212 * d3 * d3 + 0.0605 * d3 + 0.2589));
        double d17 = -0.0167 * d - 0.2608;
        double d18 = -0.095 * d + 0.0092;
        double d19 = -0.0079 * d + 0.2102;
        double d20 = -0.0441 * d - 1.6537;
        double d21 = -0.0109 * d + 0.0529;
        double d22 = new Vector3d(d * d, d, 1.0).dot(new Vector3d(0.0028 * d3 * d3 * d3 - 0.0061 * d3 * d3 + 0.0032 * d3, -0.0421 * d3 * d3 * d3 + 0.0897 * d3 * d3 - 0.0415 * d3 + 0.0052, 0.1535 * d3 * d3 * d3 - 0.2676 * d3 * d3 + 0.0667 * d3 + 0.2669));
        this.config.registerFunc("float F_Y(float theta, float gamma)", "\treturn (1.0 + " + d5 + " * exp(" + d6 + " / cos(theta))) *" + " (1.0 + " + d7 + " * exp(" + d8 + " * gamma) + " + d9 + " * cos(gamma) * cos(gamma));");
        this.config.registerFunc("float F_x(float theta, float gamma)", "\treturn (1.0 + " + d11 + " * exp(" + d12 + " / cos(theta))) *" + " (1.0 + " + d13 + " * exp(" + d14 + " * gamma) + " + d15 + " * cos(gamma) * cos(gamma));");
        this.config.registerFunc("float F_y(float theta, float gamma)", "\treturn (1.0 + " + d17 + " * exp(" + d18 + " / cos(theta))) *" + " (1.0 + " + d19 + " * exp(" + d20 + " * gamma) + " + d21 + " * cos(gamma) * cos(gamma));");
        String string = "\tif(view.z < 0.0) \t\treturn vec4(0.0, 0.0, 0.0, 1.0);\n\tfloat theta = acos(view.z);\n\tfloat gamma = acos(dot(vec3" + vector3d + ", view));\n" + "\tfloat Y = " + d10 + " * F_Y(theta, gamma) / F_Y(0.0, " + d3 + ");\n" + "\tfloat x = " + d16 + " * F_x(theta, gamma) / F_x(0.0, " + d3 + ");\n" + "\tfloat y = " + d22 + " * F_y(theta, gamma) / F_y(0.0, " + d3 + ");\n" + "\tY /= 10.0;\n" + "\tfloat M1 = (-1.3515 - 1.7703*x + 5.9114*y) /\n" + "\t\t(0.0241 + 0.2562*x - 0.7341*y);\n" + "\tfloat M2 = (0.0300 - 31.4424*x + 30.0717*y) /\n" + "\t\t(0.0241 + 0.2562*x - 0.7341*y);\n" + "\tvec3 c = mat3(\n" + "\t\t10246.121, 10676.695, 12372.502,\n" + "\t\t187.75537, 192.59651, 3482.8762,\n" + "\t\t213.14803, 76.29493, -235.71611\n" + "\t) * vec3(1, M1, M2);\n" + "\tfloat X = c.x * Y / c.y;\n" + "\tfloat Z = c.z * Y / c.y;\n" + "\tvec3 XYZ = vec3(X, Y, Z);\n" + "\tvec3 RGB = mat3(\n" + "\t\t3.2410, -0.9692, 0.0556,\n" + "\t\t-1.5374, 1.8760, -0.2040,\n" + "\t\t-0.4986, 0.0416, 1.0571\n" + "\t) * XYZ;\n" + "\tRGB *= " + Math.PI * (double)sunSkyLight.getRadianceFactor() + ";\n" + "\tfloat m = -min(RGB.r, min(RGB.g, RGB.b));" + "\tif(m > 0.0) RGB += m;" + "\treturn vec4(RGB, 1.0);";
        this.config.registerFunc("vec4 sunsky(vec3 view, vec2 uv)", string);
        GLSLChannelMap gLSLChannelMap = this.getMaterialConfig().getDefaultInputChannel();
        Result result = gLSLChannelMap.generate(sunSkyLight.getInput(), this.getMaterialConfig(), null, 20);
        Result result2 = gLSLChannelMap.generate(sunSkyLight.getInput(), this.getMaterialConfig(), null, 16);
        Result[] resultArray = new Result[]{new Result("normal", 2), new Result("pos", 2), new Result("4.0", 0), new Result("sunsky(" + result + ", " + result2 + ").rgb", 2), new Result("0.0", 0), new Result("0.0", 0), new Result("vec3(0.0)", 2), new Result("vec3(0.0)", 2), new Result("0.0", 0), new Result("0.0", 0), new Result("", -1)};
        this.oldStamp = sunSkyLight.getStamp();
        return resultArray;
    }

    public GLSLShader getInstance() {
        return new GLSLSunSky();
    }

    public boolean needsRecompilation(Object object) {
        int n;
        return !(object instanceof SunSkyLight) || (n = ((SunSkyLight)object).getStamp()) != this.oldStamp;
    }
}

