/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.objects.Parallelogram;
import de.grogra.imp3d.shading.Light;
import de.grogra.vecmath.Matrix34d;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

public class LightPos {
    Light light = null;
    Point4d lightPos = new Point4d();
    Vector3d lightDir = new Vector3d();
    Matrix4d lightTransform = new Matrix4d();

    public LightPos(Light light) {
        this.setLight(light);
    }

    public LightPos(Light light, Matrix4d matrix4d) {
        this.setLight(light);
        this.setLightPos(matrix4d);
    }

    public Light getLight() {
        return this.light;
    }

    public Point4d getLightPos() {
        return this.lightPos;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    void setRotateFront(Matrix4d matrix4d) {
        matrix4d.m01 *= -1.0;
        matrix4d.m02 *= -1.0;
        matrix4d.m11 *= -1.0;
        matrix4d.m12 *= -1.0;
        matrix4d.m21 *= -1.0;
        matrix4d.m22 *= -1.0;
        matrix4d.m31 *= -1.0;
        matrix4d.m32 *= -1.0;
    }

    public void setLightPos(Matrix4d matrix4d) {
        if (matrix4d == null) {
            return;
        }
        this.lightTransform.set(matrix4d);
        this.updateDerived();
        if (!this.isArea()) {
            this.setRotateFront(this.lightTransform);
        }
    }

    boolean isArea() {
        return this.light.getLightType() == 2;
    }

    private void updateDerived() {
        if (this.isArea()) {
            this.lightPos.set(0.0, 0.0, (double)((Parallelogram)this.light).getLength() * 0.5, 1.0);
        } else {
            this.lightPos.set(0.0, 0.0, 0.0, 1.0);
        }
        this.lightTransform.transform((Tuple4d)this.lightPos);
        if (this.isArea()) {
            this.lightDir.set(-this.lightTransform.m22, this.lightTransform.m12, this.lightTransform.m02);
        } else {
            this.lightDir.set(this.lightTransform.m02, this.lightTransform.m12, this.lightTransform.m22);
        }
    }

    public void setLightDir(Vector3d vector3d) {
        this.lightDir.set((Tuple3d)vector3d);
    }

    public Vector3d getLightDir() {
        return this.lightDir;
    }

    public Matrix4d getLightTransform() {
        return this.lightTransform;
    }

    public void setLightTransform(Matrix4d matrix4d) {
        this.lightTransform = matrix4d;
    }

    double[] toGLMatrix(Matrix4d matrix4d) {
        double[] dArray = new double[]{matrix4d.m00, matrix4d.m10, matrix4d.m20, matrix4d.m30, matrix4d.m01, matrix4d.m11, matrix4d.m21, matrix4d.m31, matrix4d.m02, matrix4d.m12, matrix4d.m22, matrix4d.m32, matrix4d.m03, matrix4d.m13, matrix4d.m23, matrix4d.m33};
        return dArray;
    }

    public void setupView(GL gL) {
        gL.glPushMatrix();
        gL.glMatrixMode(5889);
        Matrix4d matrix4d = new Matrix4d(this.lightTransform);
        double d = 1.0;
        matrix4d.mul(new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        gL.glMatrixMode(5888);
    }

    void updateMat(Matrix4d matrix4d, Matrix34d matrix34d) {
        if (matrix34d == null) {
            return;
        }
        matrix4d.m00 = matrix34d.m00;
        matrix4d.m01 = matrix34d.m01;
        matrix4d.m02 = matrix34d.m02;
        matrix4d.m03 = matrix34d.m03;
        matrix4d.m10 = matrix34d.m10;
        matrix4d.m11 = matrix34d.m11;
        matrix4d.m12 = matrix34d.m12;
        matrix4d.m13 = matrix34d.m13;
        matrix4d.m20 = matrix34d.m20;
        matrix4d.m21 = matrix34d.m21;
        matrix4d.m22 = matrix34d.m22;
        matrix4d.m23 = matrix34d.m23;
    }
}

