/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.LineSegmentizationCache;
import de.grogra.imp3d.glsl.GLDisplay;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.GLSLFBOManager;
import de.grogra.imp3d.glsl.GLSLVolumeBuilder;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.light.shadow.ShadowMapCollection;
import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.SkyMaterialConfiguration;
import de.grogra.imp3d.glsl.material.SkyPreviewConfiguration;
import de.grogra.imp3d.glsl.material.SkyReflectionMaterialConfiguration;
import de.grogra.imp3d.glsl.material.TranspMaterialConfiguration;
import de.grogra.imp3d.glsl.renderable.PlaneMaterialConfiguration;
import de.grogra.imp3d.glsl.renderable.RenderableCollection;
import de.grogra.imp3d.glsl.renderable.vbo.VBOManager;
import de.grogra.imp3d.glsl.renderpass.PresentDebugImagePass;
import de.grogra.imp3d.glsl.utility.CachedShaderCollection;
import de.grogra.imp3d.glsl.utility.DrawableContainer;
import de.grogra.imp3d.glsl.utility.FrameBufferObject;
import de.grogra.imp3d.glsl.utility.FrustumCullingTester;
import de.grogra.imp3d.glsl.utility.GLSLOpenGLObject;
import de.grogra.imp3d.glsl.utility.GLSLSkyCube;
import de.grogra.imp3d.glsl.utility.RenderBuffer;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.imp3d.glsl.utility.TextureRenderTarget;
import de.grogra.imp3d.shading.Shader;
import de.grogra.pf.boot.Main;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class OpenGLState {
    private RenderableCollection shapeManager = new RenderableCollection();
    private PresentDebugImagePass pip = new PresentDebugImagePass();
    public boolean debugDrawn = false;
    public String currentPassName;
    public int renderPass = 0;
    public int width = 512;
    public int height = 512;
    public int[] occlusionQuery = null;
    private GLSLFBOManager fboManager = new GLSLFBOManager();
    public ShadowMapCollection SM_Manager = new ShadowMapCollection();
    public VBOManager VBO_Manager = new VBOManager();
    public Vector<LightPos> defLight = new Vector();
    public LineSegmentizationCache lineCache;
    public Vector<GLSLOpenGLObject> staticObjects = new Vector();
    public DrawableContainer deferredSolidRenderable = new DrawableContainer();
    public DrawableContainer deferredToolRenderable = new DrawableContainer();
    public DrawableContainer deferredLabelRenderable = new DrawableContainer();
    public DrawableContainer deferredTranspRenderable = new DrawableContainer();
    public GLSLVolumeBuilder volume = new GLSLVolumeBuilder();
    public Vector<LightPos> lights = new Vector();
    public CachedShaderCollection csc = new CachedShaderCollection();
    protected static final int RT_NORM_POS_SHINE = 0;
    protected static final int RT_DIFF_SPEC = 1;
    protected static final int RT_EMIS_FREE = 2;
    protected static final int RT_TRANSP_SPECTRANSP = 3;
    protected static final int RT_FIRSTHDR = 0;
    protected static final int RT_SECONDHDR = 1;
    protected static final int DEFERRED_FBO = 0;
    protected static final int HDR_FBO = 1;
    protected static final int SHADOWMAP_FBO = 2;
    public static final int[] attachPoints = new int[]{36064, 36065, 36066, 36067, 36068, 36069, 36070, 36071};
    final Logger logger = Main.getLogger();
    GL context = null;
    public static final char ALPHA_TEST = '\u0000';
    public static final char STENCIL_TEST = '\u0001';
    public static final char DEPTH_TEST = '\u0002';
    public static final char LIGHTING = '\u0003';
    public static final char TEXTURE_2D = '\u0004';
    public static final char BLEND = '\u0005';
    public static final char CULLING = '\u0006';
    public static final char FREE2 = '\u0007';
    public static final char ALPHA_TEST_BIT = '\u0001';
    public static final char STENCIL_TEST_BIT = '\u0002';
    public static final char DEPTH_TEST_BIT = '\u0004';
    public static final char LIGHTING_BIT = '\b';
    public static final char TEXTURE_2D_BIT = '\u0010';
    public static final char BLEND_BIT = ' ';
    public static final char CULLING_BIT = '@';
    public static final char FREE2_BIT = '\u0080';
    private static final char[] stateToInternalState = new char[]{'\u0001', '\u0002', '\u0004', '\b', '\u0010', ' ', '@', '\u0080'};
    private static final int[] stateToGLState = new int[]{3008, 2960, 2929, 2896, 3553, 3042, 2884, 0};
    char state = (char)53;
    int activeShader = 0;
    int matrixMode = 5888;
    boolean depthMask = true;
    int currentFBO = 0;
    int face_culling = 1029;
    private double[] matrixArray = new double[16];
    private float[] matrixArray3 = new float[9];
    public GLSLSkyCube skyCube = new GLSLSkyCube();
    public GLSLSkyCube skyDiffuseCube = new GLSLSkyCube();
    Shader bgShader = null;
    public boolean BGFound = false;
    float bgPowerDensity = 50.0f;
    public int floatRT = 0;
    int shaderConfSwitch = 0;
    MaterialConfiguration matConf = new MaterialConfiguration();
    MaterialConfiguration skyMatConf = new SkyMaterialConfiguration();
    MaterialConfiguration skyReflMatConf = new SkyReflectionMaterialConfiguration();
    MaterialConfiguration matTranspConf = new TranspMaterialConfiguration();
    MaterialConfiguration infPlaneMat = new PlaneMaterialConfiguration();
    MaterialConfiguration skyPrevMat = new SkyPreviewConfiguration();
    public static final int DEFAULT_MATERIAL = 0;
    public static final int SKY_MATERIAL = 1;
    public static final int SKY_REFLECTION_MATERIAL = 2;
    public static final int TRANSP_DEPTH_ONLY_MATERIAL = 3;
    public static final int DEPTH_PEELIG_MATERIAL = 4;
    public static final int INFINITY_PLANE_MATERIAL = 5;
    public static final int SKY_PREVIEW_MATERIAL = 6;
    GLU glu = new GLU();
    Stack<Long> timerStack = new Stack();
    int sceneGraphStamp = -1;
    boolean sceneGraphChanged = true;
    private boolean assumeTranspMaterials = true;
    Matrix4d curWorldToView = new Matrix4d();
    Matrix4d invWorldToView = new Matrix4d();
    Matrix4d viewToClip = new Matrix4d();
    Matrix4d invViewToClip = new Matrix4d();
    public boolean resetCache = true;
    public FrustumCullingTester frustumCullingTester = new FrustumCullingTester();
    TextureRenderTarget dsDTRT = null;
    Vector3f[] paraLight = new Vector3f[5];

    public RenderableCollection getShapeManager() {
        return this.shapeManager;
    }

    public void presentDebugScreen(GLSLDisplay gLSLDisplay) {
        this.pip.process(gLSLDisplay, this, null);
    }

    public void initSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void initLineCache(GLDisplay gLDisplay) {
        if (this.lineCache == null) {
            this.lineCache = new LineSegmentizationCache(gLDisplay.getRenderGraphState(), 1.0f);
        }
    }

    public void info(String string) {
        this.logger.info(string);
    }

    public void warning(String string) {
        this.logger.warning(string);
    }

    public void setGL(GL gL) {
        this.context = gL;
    }

    public GL getGL() {
        return this.context;
    }

    public int getActiveShader() {
        return this.activeShader;
    }

    public void setActiveProgram(int n) {
        if (n != this.activeShader) {
            this.getGL().glUseProgram(n);
            this.activeShader = n;
        }
    }

    public void enable(char c) {
        if (c > '\u0005') {
            return;
        }
        if ((this.state & stateToInternalState[c]) == 0) {
            this.state = (char)(this.state | stateToInternalState[c]);
            this.getGL().glEnable(stateToGLState[c]);
        }
    }

    public void disable(char c) {
        if (c > '\u0005') {
            return;
        }
        if ((this.state & stateToInternalState[c]) != 0) {
            this.state = (char)(this.state & 255 - stateToInternalState[c]);
            this.getGL().glDisable(stateToGLState[c]);
        }
    }

    public boolean getState(char c) {
        return (this.state & stateToInternalState[c]) != 0;
    }

    public void setState(char c) {
        char c2 = (char)(this.state ^ c);
        for (int n = 0; n < 6; n = (int)((char)(n + 1))) {
            if ((c2 & 1 << n) <= 0) continue;
            if ((c & 1 << n) > 0) {
                this.getGL().glEnable(stateToGLState[n]);
                continue;
            }
            this.getGL().glDisable(stateToGLState[n]);
        }
        this.state = c;
    }

    public void setMatrixMode(int n) {
        if (this.matrixMode != n) {
            this.matrixMode = n;
            this.getGL().glMatrixMode(n);
        }
    }

    public void setDepthMask(boolean bl) {
        if (this.depthMask != bl) {
            this.depthMask = bl;
            this.getGL().glDepthMask(bl);
        }
    }

    public void setFBO(int n) {
        if (this.currentFBO != n) {
            this.getGL().glBindFramebufferEXT(36160, n);
            this.currentFBO = n;
        }
    }

    public void setFaceCullingMode(int n) {
        if (this.face_culling != n) {
            this.getGL().glCullFace(n);
            this.face_culling = n;
        }
    }

    public int getFaceCullingMode() {
        return this.face_culling;
    }

    public double[] toGLMatrix4(Matrix4d matrix4d) {
        this.matrixArray[0] = matrix4d.m00;
        this.matrixArray[1] = matrix4d.m10;
        this.matrixArray[2] = matrix4d.m20;
        this.matrixArray[3] = matrix4d.m30;
        this.matrixArray[4] = matrix4d.m01;
        this.matrixArray[5] = matrix4d.m11;
        this.matrixArray[6] = matrix4d.m21;
        this.matrixArray[7] = matrix4d.m31;
        this.matrixArray[8] = matrix4d.m02;
        this.matrixArray[9] = matrix4d.m12;
        this.matrixArray[10] = matrix4d.m22;
        this.matrixArray[11] = matrix4d.m32;
        this.matrixArray[12] = matrix4d.m03;
        this.matrixArray[13] = matrix4d.m13;
        this.matrixArray[14] = matrix4d.m23;
        this.matrixArray[15] = matrix4d.m33;
        return this.matrixArray;
    }

    public float[] toGLMatrix3f(Matrix3f matrix3f) {
        this.matrixArray3[0] = matrix3f.m00;
        this.matrixArray3[1] = matrix3f.m10;
        this.matrixArray3[2] = matrix3f.m20;
        this.matrixArray3[3] = matrix3f.m01;
        this.matrixArray3[4] = matrix3f.m11;
        this.matrixArray3[5] = matrix3f.m21;
        this.matrixArray3[6] = matrix3f.m02;
        this.matrixArray3[7] = matrix3f.m12;
        this.matrixArray3[8] = matrix3f.m22;
        return this.matrixArray3;
    }

    public void loadMatrixd(Matrix4d matrix4d) {
        this.getGL().glLoadMatrixd(this.toGLMatrix4(matrix4d), 0);
    }

    public void cleanUp(boolean bl) {
        this.getFboManager().deleteAll(this, bl);
        this.csc.deleteAll(this, bl);
        this.SM_Manager.cleanUp(this, bl);
        Iterator<GLSLOpenGLObject> iterator = this.staticObjects.iterator();
        while (iterator.hasNext()) {
            iterator.next().cleanup(this, bl);
        }
        this.skyCube.delete(this.getGL(), bl);
        this.skyDiffuseCube.delete(this.getGL(), bl);
    }

    public void setupBGShader(Shader shader) {
        if (this.BGFound) {
            return;
        }
        this.bgShader = shader;
        if (shader != null) {
            this.BGFound = true;
        }
    }

    public Shader getBGShader() {
        return this.bgShader;
    }

    public void setupBGPowerDensity(float f) {
        this.bgPowerDensity = f;
    }

    public float getBgPowerDensity() {
        return this.bgPowerDensity;
    }

    public void switchFloatRT() {
        this.floatRT = (this.floatRT + 1) % 2;
    }

    public int getFloatRT() {
        return this.floatRT;
    }

    public int getFloatRTLast() {
        return (this.floatRT + 1) % 2;
    }

    public void setShaderConfSwitch(int n) {
        this.shaderConfSwitch = n;
    }

    ShaderConfiguration getCurrentShaderConfiguration() {
        switch (this.shaderConfSwitch) {
            case 0: {
                return this.matConf;
            }
            case 1: {
                return this.skyMatConf;
            }
            case 2: {
                return this.skyReflMatConf;
            }
            case 3: {
                return this.matTranspConf;
            }
            case 5: {
                return this.infPlaneMat;
            }
            case 6: {
                return this.skyPrevMat;
            }
        }
        return null;
    }

    public void testFBO() {
        if (GLSLDisplay.DEBUG) {
            switch (this.getGL().glCheckFramebufferStatusEXT(36160)) {
                case 36053: {
                    GLSLDisplay.printDebugInfoN("Framebuffer complete");
                    break;
                }
                case 36058: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete format");
                    break;
                }
                case 36054: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete attachment");
                    break;
                }
                case 36057: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete dimensions");
                    break;
                }
                case 36059: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete draw buffer");
                    break;
                }
                case 36056: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete duplicate attachment");
                    break;
                }
                case 36055: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete missing attachment");
                    break;
                }
                case 36182: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete multisample");
                    break;
                }
                case 36060: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete missing attachment");
                    break;
                }
                case 36265: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete layer count");
                    break;
                }
                case 36264: {
                    GLSLDisplay.printDebugInfoN("Framebuffer incomplete layer targets");
                    break;
                }
                case 36061: {
                    GLSLDisplay.printDebugInfoN("Framebuffer unsupported");
                    break;
                }
                default: {
                    GLSLDisplay.printDebugInfoN("ERROR!!!!");
                }
            }
        }
    }

    public boolean testGLError() {
        return this.testGLError("");
    }

    public boolean testGLError(String string) {
        boolean bl = true;
        int n = 0;
        boolean bl2 = true;
        while ((n = this.getGL().glGetError()) != 0) {
            bl = false;
            if (bl2) {
                GLSLDisplay.printDebugInfo(string);
                bl2 = false;
            }
            GLSLDisplay.printDebugInfo(this.glu.gluErrorString(n) + " ");
        }
        if (!bl) {
            GLSLDisplay.printDebugInfoN("");
        }
        return bl;
    }

    public void startClock() {
        Long l = new Long(System.nanoTime());
        this.timerStack.add(l);
    }

    public long printClock(String string) {
        long l = System.nanoTime();
        long l2 = this.timerStack.peek();
        long l3 = (l - l2) / 1000L;
        System.out.printf(string + "<%d \ufffds\n", l3);
        return l3;
    }

    public long popClock() {
        return System.nanoTime() - this.timerStack.pop();
    }

    void updateStamp(int n) {
        if (this.sceneGraphStamp != n) {
            this.sceneGraphChanged = true;
            this.sceneGraphStamp = n;
        } else {
            this.sceneGraphChanged = false;
        }
    }

    public int getGraphStamp() {
        return this.sceneGraphStamp;
    }

    public boolean hasGraphChanged() {
        return this.sceneGraphChanged;
    }

    public boolean isAssumeTranspMaterials() {
        return this.assumeTranspMaterials;
    }

    public void setAssumeTranspMaterials(boolean bl) {
        this.assumeTranspMaterials = bl;
    }

    public void updateTransformations(GLSLDisplay gLSLDisplay) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        this.curWorldToView.set(camera.getWorldToViewTransformation());
        this.invWorldToView.invert(this.curWorldToView);
        camera.getViewToClipTransformation(this.viewToClip);
        this.invViewToClip.invert(this.viewToClip);
    }

    public Matrix4d getWorldToView() {
        return this.curWorldToView;
    }

    public Matrix4d getInvWorldToView() {
        return this.invWorldToView;
    }

    public Matrix4d getViewToClip() {
        return this.viewToClip;
    }

    public Matrix4d getInvViewToClip() {
        return this.invViewToClip;
    }

    public void printGPUMemoryUsage(GLSLDisplay gLSLDisplay) {
        long l = 0L;
        int n = 0;
        n += this.getDeferredShadingFBO().estimateSizeInByteForColor();
        l += (long)(n += this.getDepthRB().estimateSizeInByte());
        System.out.println("Deferred Shading: " + n + " Bytes");
        n = this.getHDRFBO().estimateSizeInByteForColor();
        l += (long)n;
        System.out.println("HDR: " + n + " Bytes");
        n = this.skyDiffuseCube.estimateSizeInByte() + this.skyCube.estimateSizeInByte();
        l += (long)n;
        System.out.println("SkyLight: " + n + " Bytes");
        n = this.getAlphaFBO().estimateSizeInByteForColor();
        n += this.getPeelingFarDepthTRT().estimateSizeInByte();
        l += (long)(n += this.getPeelingNearDepthTRT().estimateSizeInByte());
        System.out.println("Depth Peeling: " + n + " Bytes");
        n = this.SM_Manager.getShadowMapMemoryConsumption();
        l += (long)n;
        System.out.println("Shadow Maps: " + n + " Bytes");
        n = gLSLDisplay.getTextureManager().estimateSizeInByte();
        System.out.println("Textures: " + n + " Bytes");
        System.out.println("Total: ~" + (l += (long)n) / 0x100000L + " MBytes");
    }

    public void invalidateCache() {
        this.resetCache = true;
    }

    public FrameBufferObject getDeferredShadingFBO() {
        return this.fboManager.deferredShadingFBO;
    }

    public FrameBufferObject getHDRFBO() {
        return this.fboManager.HDRFBO;
    }

    public FrameBufferObject getAlphaFBO() {
        return this.fboManager.alphaFBO;
    }

    public FrameBufferObject getShadowFBO() {
        return this.fboManager.shadowFBO;
    }

    public FrameBufferObject getDualDepthFBO() {
        return this.fboManager.dualDepthFBO;
    }

    public FrameBufferObject getCubeFBO() {
        return this.fboManager.cubeFBO;
    }

    public RenderBuffer getDepthRB() {
        return this.fboManager.depthRB;
    }

    public TextureRenderTarget getPeelingFarDepthTRT() {
        return this.fboManager.peelingFarDepthTRT;
    }

    public RenderBuffer getPeelingRB() {
        return this.fboManager.peelingRB;
    }

    public TextureRenderTarget getPeelingNearDepthTRT() {
        return this.fboManager.peelingNearDepthTRT;
    }

    public void setDeferredShadingDepthTRT(TextureRenderTarget textureRenderTarget) {
        this.dsDTRT = textureRenderTarget;
    }

    public TextureRenderTarget getDeferredShadingDepthTRT() {
        return this.dsDTRT;
    }

    public GLSLFBOManager getFboManager() {
        return this.fboManager;
    }

    public void setPoint(Vector3f vector3f, int n) {
        if (this.paraLight[n] == null) {
            this.paraLight[n] = new Vector3f();
        }
        this.paraLight[n].set((Tuple3f)vector3f);
    }

    public void printPoints() {
        GL gL = this.getGL();
        gL.glDisable(2929);
        gL.glDisable(2896);
        gL.glEnable(2903);
        this.loadMatrixd(this.curWorldToView);
        gL.glPointSize(8.0f);
        gL.glBegin(0);
        gL.glColor3f(1.0f, 1.0f, 1.0f);
        for (int i = 3; i >= 0; --i) {
            gL.glVertex3f(this.paraLight[i].x, this.paraLight[i].y, this.paraLight[i].z);
            System.out.println(this.paraLight[i]);
        }
        gL.glEnd();
        gL.glEnable(2929);
    }
}

