/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import com.sun.opengl.util.ImageUtil;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.View;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.glsl.CacheData;
import de.grogra.imp3d.glsl.GLDisplay;
import de.grogra.imp3d.glsl.JOGL_Test;
import de.grogra.imp3d.glsl.Measures;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.Texture;
import de.grogra.imp3d.glsl.TextureManager;
import de.grogra.imp3d.glsl.light.LightCollection;
import de.grogra.imp3d.glsl.light.shadow.ShadowLightCollection;
import de.grogra.imp3d.glsl.material.MaterialCollection;
import de.grogra.imp3d.glsl.material.channel.FloatToFloatCollection;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.Transform3DCollection;
import de.grogra.imp3d.glsl.renderpass.RenderPass;
import de.grogra.imp3d.glsl.renderpass.nostencil.FullQualityRenderPass;
import de.grogra.imp3d.glsl.utility.GLSLManagedShader;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Shader;
import de.grogra.pf.boot.Main;
import de.grogra.pf.ui.Context;
import de.grogra.util.Debug;
import de.grogra.util.EnumerationType;
import de.grogra.util.EventListener;
import de.grogra.util.I18NBundle;
import de.grogra.util.WrapException;
import de.grogra.xl.lang.ObjectConsumer;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPbuffer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class GLSLDisplay
extends GLDisplay {
    public static final boolean DEBUG = Debug.debug((String)"GLSLDisplay");
    private static int TONEMAPPING_MAX = 1;
    private static final I18NBundle I18N = I18NBundle.getInstance(GLSLDisplay.class);
    public static final EnumerationType TONEMAPPING_TYPE = new EnumerationType("tonemapping", I18N, TONEMAPPING_MAX + 1);
    private static final String OPTION_NAME_TONEMAPPING = "tonemapping";
    private int tonemapping = 0;
    private static final String OPTION_NAME_BRIGHTNESS = "brightness";
    private float brightness = 1.0f;
    private static final String OPTION_NAME_AUTOADJUSTBRIGHTNESS = "autoAdjustBrightness";
    private boolean optionAutoAdjustBrightness = true;
    private static final String OPTION_NAME_EDGEFILTERING = "edgeFiltering";
    private boolean optionEdgeFiltering = false;
    private static final String OPTION_NAME_SHADERANTIALIASING = "shaderAntialiasing";
    private boolean optionShaderAntialiasing = false;
    private static final String OPTION_NAME_ALTDRAWING = "altDrawing";
    private boolean optionAltDrawing = false;
    private static final String OPTION_NAME_PHYSICALLIGHTING = "physicalLighting";
    private boolean optionPhysicalLighting = false;
    private static final String OPTION_NAME_DIFFUSESKYLIGHT = "diffuseSkyLight";
    private boolean optionShowDiffuseSkyLight = false;
    private static final String OPTION_NAME_SHOWSKY = "showSky";
    private boolean optionShowSky = true;
    private static final String OPTION_NAME_SHOWSHADOWS = "showShadows";
    private boolean optionShowShadows = true;
    private static final String OPTION_NAME_MAXDEPTH = "maxDepth";
    private int optionMaxDepth = 4;
    private static final String OPTION_NAME_DEBUGRENDERPASS = "debugRenderPass";
    private int optionDebugRenderPass = 0;
    private static final String OPTION_NAME_BACKGROUND_COLOR_R = "backgroundColorR";
    private float optionBackgroundColorR = 1.0f;
    private static final String OPTION_NAME_BACKGROUND_COLOR_G = "backgroundColorG";
    private float optionBackgroundColorG = 1.0f;
    private static final String OPTION_NAME_BACKGROUND_COLOR_B = "backgroundColorB";
    private float optionBackgroundColorB = 1.0f;
    private static final String OPTION_NAME_BACKGROUND_ALPHA = "backgroundAlpha";
    private float optionBackgroundAlpha = 1.0f;
    private static final String OPTION_NAME_SHOW_BACKGROUND_IMAGE = "showBGImage";
    protected boolean optionShowBGImage = true;
    static boolean checked = false;
    static boolean ok = false;
    static int DEPTH_STENCIL_SETUP;
    static final float PLANE_SIZE = 100.0f;
    boolean[] visible = null;
    private GLContext oldContext;
    OpenGLState glState = new OpenGLState();
    static final RenderPass fqrp;
    Matrix4d LightWorldToView = new Matrix4d();
    Matrix4d LightViewToClip = new Matrix4d();
    int i = 0;

    public static void printDebugInfoN(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void printDebugInfo(String string) {
        if (DEBUG) {
            System.out.print(string);
        }
    }

    public void initView(View view, EventListener eventListener) {
        super.initView(view, eventListener);
        this.optionShowSky = (Boolean)this.getOption(OPTION_NAME_SHOWSKY, true);
        this.optionShowShadows = (Boolean)this.getOption(OPTION_NAME_SHOWSHADOWS, true);
        this.optionAutoAdjustBrightness = (Boolean)this.getOption(OPTION_NAME_AUTOADJUSTBRIGHTNESS, true);
        this.optionEdgeFiltering = (Boolean)this.getOption(OPTION_NAME_EDGEFILTERING, false);
        this.optionShaderAntialiasing = (Boolean)this.getOption(OPTION_NAME_SHADERANTIALIASING, false);
        this.optionAltDrawing = (Boolean)this.getOption(OPTION_NAME_ALTDRAWING, false);
        this.brightness = ((Float)this.getOption(OPTION_NAME_BRIGHTNESS, Float.valueOf(1.0f))).floatValue();
        this.tonemapping = (Integer)this.getOption(OPTION_NAME_TONEMAPPING, 0);
        this.optionPhysicalLighting = (Boolean)this.getOption(OPTION_NAME_PHYSICALLIGHTING, false);
        this.optionShowDiffuseSkyLight = (Boolean)this.getOption(OPTION_NAME_DIFFUSESKYLIGHT, false);
        this.optionMaxDepth = (Integer)this.getOption(OPTION_NAME_MAXDEPTH, 4);
        this.optionDebugRenderPass = (Integer)this.getOption(OPTION_NAME_DEBUGRENDERPASS, 0);
        this.optionBackgroundColorR = ((Float)this.getOption(OPTION_NAME_BACKGROUND_COLOR_R, Float.valueOf(1.0f))).floatValue();
        this.optionBackgroundColorG = ((Float)this.getOption(OPTION_NAME_BACKGROUND_COLOR_G, Float.valueOf(1.0f))).floatValue();
        this.optionBackgroundColorB = ((Float)this.getOption(OPTION_NAME_BACKGROUND_COLOR_B, Float.valueOf(1.0f))).floatValue();
        this.optionBackgroundAlpha = ((Float)this.getOption(OPTION_NAME_BACKGROUND_ALPHA, Float.valueOf(1.0f))).floatValue();
        this.optionShowBGImage = (Boolean)this.getOption(OPTION_NAME_SHOW_BACKGROUND_IMAGE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(int n) throws InterruptedException {
        GLContext gLContext;
        ObjectConsumer objectConsumer;
        Object object = this.callbackLock;
        synchronized (object) {
            objectConsumer = this.callback;
            this.callback = null;
        }
        this.getView3D().setExtent(null, Float.NaN);
        this.visible = (boolean[])View.visibleLayers$FIELD.getObject((Object)this.getView());
        object = this.canvas.getGL();
        this.setGL((GL)object);
        if (this.canvasChanged) {
            this.canvasChanged = false;
            this.dlSphere = 0;
            this.supportsVBO = object.isExtensionAvailable("GL_ARB_vertex_buffer_object");
            if (DEBUG) {
                System.err.println("supportsVBO = " + this.supportsVBO);
            }
            this.supportsVBO = false;
        }
        if ((gLContext = this.canvas.getContext()) != this.oldContext) {
            this.textureManager.deleteTextures((GL)object);
            this.setUpContext(this.canvas.getContext());
            object.glGetError();
            this.oldContext = gLContext;
        }
        if (this.reshaped) {
            this.reshaped = false;
            this.resize();
        }
        object.glClearColor(0.75f, 0.75f, 0.75f, 0.0f);
        int n2 = this.canvas.getWidth();
        int n3 = this.canvas.getHeight();
        ((View3D)this.getView()).getCanvasCamera().setDimension(n2, n3);
        object.glClear(16384);
        Object object2 = this.imageLock;
        synchronized (object2) {
            if (this.img != null) {
                if (this.imgChanged) {
                    this.grabBackground((GL)object);
                }
                this.drawBackground((GL)object);
                if (objectConsumer != null) {
                    objectConsumer.consume((Object)GLSLDisplay.convert(this.img));
                }
                if ((n & 9) == 9) {
                    this.img = null;
                } else {
                    return;
                }
            }
        }
        Measures.getInstance().startTimer();
        object.glClear(256);
        object.glMatrixMode(5889);
        object2 = ((View3D)this.getView()).getCamera();
        Matrix4d matrix4d = new Matrix4d();
        ((Camera)object2).getViewToClipTransformation(matrix4d);
        double d = (double)n2 / (double)n3;
        matrix4d.mul(new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
        object.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        object.glMatrixMode(5888);
        int n4 = this.getView().getGraph().getStamp();
        if (n4 != this.oldStamp) {
            this.oldStamp = n4;
        }
        this.curHighlight = 0;
        try {
            this.renderScene();
            ArrayPath arrayPath = new ArrayPath(this.getView().getGraph());
            ViewSelection.Entry[] entryArray = ViewSelection.get((Context)this.getView()).getAll(-1);
            for (int i = 0; i < entryArray.length; ++i) {
                Path path = entryArray[i].getPath();
                this.curHighlight = entryArray[i].getValue();
                this.visitor.init(this.getRenderGraphState(), this.glState.getWorldToView(), path.getNodeAndEdgeCount(), true);
                GraphUtils.acceptPath((Path)path, (Visitor)this.visitor, (ArrayPath)arrayPath);
            }
            this.disableLighting((GL)object);
            object.glDisable(2929);
            Tool tool = this.getView().getActiveTool();
            if (tool != null) {
                this.curHighlight = 0;
                this.visitor.init(GraphManager.STATIC_STATE, this.glState.getWorldToView(), 0, false);
                arrayPath.clear((Graph)GraphManager.STATIC);
                for (int i = 0; i < tool.getToolCount(); ++i) {
                    GraphManager.acceptGraph((Node)tool.getRoot(i), (Visitor)this.visitor, (ArrayPath)arrayPath);
                }
            }
            this.enableLighting((GL)object);
            object.glEnable(16384);
            object.glEnable(2929);
            if (this.optionShowAxes) {
                this.drawAxes((GL)object, (Camera)object2);
            }
            if (this.optionShowDisplaySize) {
                this.drawDisplaySize((GL)object, (Camera)object2);
            }
        }
        catch (WrapException wrapException) {
            if (wrapException.getCause() instanceof InterruptedException) {
                throw (InterruptedException)wrapException.getCause();
            }
            throw wrapException;
        }
        finally {
            object.glFinish();
        }
        Measures.getInstance().stopTimer(this);
        if (Measures.getInstance().shouldRedraw()) {
            this.repaint(7);
        }
        if (objectConsumer != null) {
            objectConsumer.consume((Object)this.readCurrentToBufferedImage((GL)object));
        }
    }

    private BufferedImage readCurrentToBufferedImage(GL gL) {
        int n = 32993;
        DataBufferFloat dataBufferFloat = new DataBufferFloat(this.glState.width * this.glState.height * 4);
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(dataBufferFloat.getDataType(), this.glState.width, this.glState.height, 4, this.glState.width * 4, new int[]{2, 1, 0, 3});
        WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferFloat, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, false, 3, dataBufferFloat.getDataType());
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        this.glState.getHDRFBO().bind(this.glState);
        gL.glReadBuffer(36064 + this.glState.getFloatRT());
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        pixelStorageModes.save(gL);
        gL.glReadPixels(0, 0, this.glState.width, this.glState.height, n, 5126, (Buffer)FloatBuffer.wrap(dataBufferFloat.getData()));
        pixelStorageModes.restore(gL);
        this.glState.setFBO(0);
        ImageUtil.flipImageVertically((BufferedImage)bufferedImage);
        return bufferedImage;
    }

    private static int glGetInteger(GL gL, int n, int[] nArray) {
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        if (DEBUG) {
            gLAutoDrawable.setGL((GL)new DebugGL(gLAutoDrawable.getGL()));
        }
        super.init(gLAutoDrawable);
    }

    Texture prologue(GL gL, Shader shader, int n) {
        Texture texture = null;
        int n2 = 0xB0B0B0;
        if (shader != null) {
            n2 = shader.getAverageColor();
        }
        if (texture != null) {
            n2 = -1;
        }
        byte by = (byte)(n2 >> 16 & 0xFF);
        byte by2 = (byte)(n2 >> 8 & 0xFF);
        byte by3 = (byte)(n2 >> 0 & 0xFF);
        byte by4 = (byte)(n2 >> 24 & 0xFF);
        this.highlightPrologue(n, gL, by, by2, by3, by4);
        return texture;
    }

    void epilogue(GL gL, Shader shader, Texture texture, int n) {
        this.highlightEpilogue(n, gL);
    }

    public void drawBoxImpl(GL gL, float f, float f2, float f3, float f4, float f5, float f6) {
        super.drawBoxImpl(gL, f, f2, f3, f4, f5, f6);
    }

    void drawPlaneImpl(GL gL, int n, int n2, int n3) {
        gL.glBegin(8);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        for (int i = 0; i < n3; ++i) {
            float f = (float)n * ((float)i / (float)n3 - 0.5f);
            float f2 = (float)n * ((float)(i + 1) / (float)n3 - 0.5f);
            for (int j = 0; j <= n2; ++j) {
                float f3 = (float)n * ((float)j / (float)n2 - 0.5f);
                gL.glTexCoord2f((float)(n * j) / (float)n2, (float)(n * (i + 1)) / (float)n3);
                gL.glVertex3f(f3, f2, 0.0f);
                gL.glTexCoord2f((float)(n * j) / (float)n2, (float)(n * i) / (float)n3);
                gL.glVertex3f(f3, f, 0.0f);
            }
        }
        gL.glEnd();
    }

    public void drawPlane(Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        Texture texture = this.prologue(gL, shader, n);
        this.drawPlaneImpl(gL, 100, 1, 1);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        this.drawPolygons(polygonizable, object, bl, shader, n, matrix4d, -1, true, true);
    }

    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d, int n2, boolean bl2, boolean bl3) {
        CacheData cacheData;
        if (this.polyCache != null && this.polyCache.getGraphState() != this.getRenderGraphState()) {
            this.polyCache.clear();
            this.polyCache = null;
        }
        if (this.polyCache == null) {
            this.polyCache = new PolygonizationCache(this.getRenderGraphState(), 3, 10.0f, true);
        }
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        PolygonArray polygonArray = this.polyCache.get(object, bl, polygonizable);
        if (polygonArray.wasCleared() || !(polygonArray.userObject instanceof CacheData)) {
            cacheData = new CacheData();
            cacheData.polygonSize = polygonArray.polygons.size;
            if (cacheData.polygonSize > 0) {
                cacheData.ib = GLSLDisplay.newByteBuffer(polygonArray.polygons.size * 4).asIntBuffer();
                polygonArray.polygons.writeTo(cacheData.ib);
                cacheData.vb = GLSLDisplay.newByteBuffer(polygonArray.vertices.size * 4).asFloatBuffer();
                polygonArray.vertices.writeTo(cacheData.vb);
                cacheData.nb = GLSLDisplay.newByteBuffer(polygonArray.normals.size);
                polygonArray.normals.writeTo(cacheData.nb);
                cacheData.uvb = GLSLDisplay.newByteBuffer(polygonArray.uv.size * 4).asFloatBuffer();
                polygonArray.uv.writeTo(cacheData.uvb);
            }
            polygonArray.userObject = cacheData;
        } else {
            cacheData = (CacheData)polygonArray.userObject;
        }
        if (cacheData.polygonSize > 0) {
            cacheData.ib.rewind();
            cacheData.vb.rewind();
            cacheData.nb.rewind();
            cacheData.uvb.rewind();
            GL gL = this.canvas.getGL();
            if (n2 != -1) {
                switch (polygonArray.visibleSides) {
                    case 0: {
                        if (!bl2) {
                            gL.glEnable(2884);
                            gL.glCullFace(1029);
                            break;
                        }
                        if (n2 != 1028) break;
                        return;
                    }
                    case 1: {
                        if (!bl2) {
                            gL.glEnable(2884);
                            gL.glCullFace(1028);
                            break;
                        }
                        if (n2 != 1029) break;
                        return;
                    }
                }
            } else {
                switch (polygonArray.visibleSides) {
                    case 1: {
                        gL.glCullFace(1028);
                        break;
                    }
                    case 2: {
                        gL.glDisable(2884);
                    }
                }
            }
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
            Texture texture = this.prologue(gL, shader, n);
            gL.glEnableClientState(32884);
            gL.glEnableClientState(32885);
            gL.glEnableClientState(32888);
            gL.glVertexPointer(polygonArray.dimension, 5126, 0, (Buffer)cacheData.vb);
            gL.glNormalPointer(5120, 0, (Buffer)cacheData.nb);
            gL.glTexCoordPointer(2, 5126, 0, (Buffer)cacheData.uvb);
            gL.glDrawElements(polygonArray.edgeCount == 3 ? 4 : 7, cacheData.polygonSize, 5125, (Buffer)cacheData.ib);
            gL.glDisableClientState(32884);
            gL.glDisableClientState(32885);
            gL.glDisableClientState(32888);
            this.epilogue(gL, shader, texture, n);
            if (n2 != -1) {
                if (!bl2) {
                    if (polygonArray.visibleSides == 0 && n2 != 1029) {
                        gL.glDisable(2884);
                        gL.glCullFace(n2);
                    } else if (polygonArray.visibleSides == 1 && n2 != 1028) {
                        gL.glDisable(2884);
                        gL.glCullFace(n2);
                    }
                }
            } else {
                switch (polygonArray.visibleSides) {
                    case 1: {
                        gL.glCullFace(1029);
                        break;
                    }
                    case 2: {
                        gL.glEnable(2884);
                    }
                }
            }
            gL.glMatrixMode(5888);
            gL.glPopMatrix();
        }
    }

    public void drawParallelogram(float f, Vector3f vector3f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        Texture texture = this.prologue(gL, shader, n);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, f);
        vector3f2.cross(vector3f, vector3f2);
        gL.glDisable(2884);
        gL.glBegin(7);
        gL.glNormal3f(-vector3f2.x, -vector3f2.y, -vector3f2.z);
        gL.glTexCoord2f(0.0f, f3);
        gL.glVertex3f(-vector3f.x, -vector3f.y, f - vector3f.z);
        gL.glTexCoord2f(f2, f3);
        gL.glVertex3f(vector3f.x, vector3f.y, f + vector3f.z);
        gL.glTexCoord2f(f2, 0.0f);
        gL.glVertex3f(vector3f.x, vector3f.y, vector3f.z);
        gL.glTexCoord2f(0.0f, 0.0f);
        gL.glVertex3f(-vector3f.x, -vector3f.y, -vector3f.z);
        gL.glEnd();
        gL.glEnable(2884);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    public void drawGrid(GL gL) {
        super.drawGrid(gL);
    }

    public static void ViewOrtho(GL gL, int n, int n2) {
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, (double)n, (double)n2, 0.0, -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
    }

    public static void ViewPerspective(GL gL) {
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
    }

    public void drawRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        GL gL = this.canvas.getGL();
        gL.glDisable(2929);
        gL.glDisable(2896);
        GLSLDisplay.ViewOrtho(gL, this.canvas.getWidth(), this.canvas.getHeight());
        gL.glColor3f(tuple3f.x, tuple3f.y, tuple3f.z);
        gL.glBegin(2);
        gL.glVertex2f((float)n, (float)n2);
        gL.glVertex2f((float)(n + n3), (float)n2);
        gL.glVertex2f((float)(n + n3), (float)(n2 + n4));
        gL.glVertex2f((float)n, (float)(n2 + n4));
        gL.glEnd();
        GLSLDisplay.ViewPerspective(gL);
        gL.glEnable(2929);
        gL.glEnable(2896);
    }

    public void fillRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        GL gL = this.canvas.getGL();
        gL.glDisable(2929);
        gL.glDisable(2896);
        GLSLDisplay.ViewOrtho(gL, this.canvas.getWidth(), this.canvas.getHeight());
        gL.glColor3f(tuple3f.x, tuple3f.y, tuple3f.z);
        gL.glBegin(7);
        gL.glVertex2f((float)n, (float)n2);
        gL.glVertex2f((float)n, (float)(n2 + n4));
        gL.glVertex2f((float)(n + n3), (float)(n2 + n4));
        gL.glVertex2f((float)(n + n3), (float)n2);
        gL.glEnd();
        GLSLDisplay.ViewPerspective(gL);
        gL.glEnable(2929);
        gL.glEnable(2896);
    }

    public void drawPoint(Tuple3f tuple3f, int n, Tuple3f tuple3f2, int n2, Matrix4d matrix4d) {
        if (this.optionShowPoints) {
            matrix4d = this.getTransformation(matrix4d);
            GL gL = this.canvas.getGL();
            float f = (float)n / this.estimateScaleAt(tuple3f);
            Matrix4d matrix4d2 = new Matrix4d();
            matrix4d2.set((double)f, new Vector3d(tuple3f));
            matrix4d2.mul(matrix4d, matrix4d2);
            gL.glPushMatrix();
            gL.glLoadMatrixd(this.toGLMatrix(matrix4d2), 0);
            gL.glColor3f(tuple3f2.x, tuple3f2.y, tuple3f2.z);
            this.disableLighting(gL);
            this.dlSphere = this.drawWithDisplayList(this.dlSphere, gL, new GLDisplay.SphereDisplayListRenderable(gL), 8, 4.0f);
            this.enableLighting(gL);
            gL.glPopMatrix();
        }
    }

    public Matrix4d getTransformation(Matrix4d matrix4d) {
        return super.getTransformation(matrix4d);
    }

    protected void optionValueChanged(String string, Object object) {
        if (OPTION_NAME_SHOWSKY.equals(string)) {
            this.optionShowSky = (Boolean)object;
            this.repaint(7);
        } else if (OPTION_NAME_SHOWSHADOWS.equals(string)) {
            this.optionShowShadows = (Boolean)object;
            this.repaint(7);
        } else if (OPTION_NAME_TONEMAPPING.equals(string)) {
            this.tonemapping = ((Number)object).intValue();
            this.repaint(7);
        } else if (OPTION_NAME_BRIGHTNESS.equals(string)) {
            this.brightness = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_AUTOADJUSTBRIGHTNESS.equals(string)) {
            this.optionAutoAdjustBrightness = (Boolean)object;
            this.repaint(7);
        } else if (OPTION_NAME_EDGEFILTERING.equals(string)) {
            this.optionEdgeFiltering = (Boolean)object;
            this.repaint(7);
        } else if (OPTION_NAME_SHADERANTIALIASING.equals(string)) {
            this.optionShaderAntialiasing = (Boolean)object;
            this.glState.invalidateCache();
            this.repaint(7);
        } else if (OPTION_NAME_ALTDRAWING.equals(string)) {
            this.optionAltDrawing = (Boolean)object;
            this.glState.invalidateCache();
            this.repaint(7);
        } else if (OPTION_NAME_PHYSICALLIGHTING.equals(string)) {
            this.optionPhysicalLighting = (Boolean)object;
            this.repaint(7);
        } else if (OPTION_NAME_DIFFUSESKYLIGHT.equals(string)) {
            this.optionShowDiffuseSkyLight = (Boolean)object;
            this.repaint(7);
        } else if (OPTION_NAME_MAXDEPTH.equals(string)) {
            this.optionMaxDepth = (Integer)object;
            this.repaint(7);
        } else if (OPTION_NAME_DEBUGRENDERPASS.equals(string)) {
            this.optionDebugRenderPass = (Integer)object;
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_COLOR_R.equals(string)) {
            this.optionBackgroundColorR = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_COLOR_G.equals(string)) {
            this.optionBackgroundColorG = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_COLOR_B.equals(string)) {
            this.optionBackgroundColorB = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_ALPHA.equals(string)) {
            this.optionBackgroundAlpha = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_BACKGROUND_IMAGE.equals(string)) {
            this.optionShowBGImage = (Boolean)object;
            this.repaint(7);
        } else {
            super.optionValueChanged(string, object);
        }
    }

    public boolean isOptionShowGrid() {
        return this.optionShowGrid;
    }

    public boolean isOptionShowBGImage() {
        return this.optionShowBGImage;
    }

    public float getBackgroundColorR() {
        return this.optionBackgroundColorR;
    }

    public float getBackgroundColorG() {
        return this.optionBackgroundColorG;
    }

    public float getBackgroundColorB() {
        return this.optionBackgroundColorB;
    }

    public float getBackgroundAlpha() {
        return this.optionBackgroundAlpha;
    }

    public boolean isOptionLighting() {
        return this.lightingOn;
    }

    public boolean isOptionShowSky() {
        return this.optionShowSky;
    }

    public boolean isOptionShowShadows() {
        return this.optionShowShadows;
    }

    public boolean isOptionEdgeFiltering() {
        return this.optionEdgeFiltering;
    }

    public boolean isOptionAltDrawing() {
        return this.optionAltDrawing;
    }

    public boolean isOptionPhysicalLighting() {
        return this.optionPhysicalLighting;
    }

    public boolean isOptionShowDiffuseSkyLight() {
        return this.optionShowDiffuseSkyLight;
    }

    public boolean isOptionShaderAntialiasing() {
        return this.optionShaderAntialiasing;
    }

    public boolean isOptionAutoAdjustBrightness() {
        return this.optionAutoAdjustBrightness;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public int getTonemapping() {
        return this.tonemapping;
    }

    public int getDebugRenderPass() {
        return this.optionDebugRenderPass;
    }

    public int getMaxDepth() {
        return this.optionMaxDepth;
    }

    public GLDisplay.GLVisitor getVisitor() {
        return this.visitor;
    }

    public void setVisitor(GLDisplay.GLVisitor gLVisitor) {
        this.visitor = gLVisitor;
    }

    public TextureManager getTextureManager() {
        return this.textureManager;
    }

    public boolean isVisible(int n) {
        return n < 0 || n >= this.visible.length || this.visible[n];
    }

    public OpenGLState getCurrentGLState() {
        return this.glState;
    }

    public static int getDepthStencilSetup() {
        return DEPTH_STENCIL_SETUP;
    }

    public void init() {
        GLSLDisplay.printDebugInfoN("Initializing FBO:");
        this.glState.initSize(this.getView().getSize().width, this.getView().getSize().height);
        this.glState.getFboManager().setupFBO(this.glState);
        this.glState.initLineCache(this);
        LightCollection.initMap();
        ShadowLightCollection.initMap();
        MaterialCollection.initMap();
        GLSLChannelMap.initMap();
        FloatToFloatCollection.initMap();
        Transform3DCollection.initMap();
    }

    public void setGL(GL gL) {
        this.glState.setGL(gL);
    }

    public void resize() {
        this.glState.getFboManager().resize(this, this.glState);
        this.repaint(7);
    }

    public void setUpContext(GLContext gLContext) {
        if (this.oldContext != gLContext) {
            if (gLContext != null) {
                this.glState.cleanUp(true);
                GLSLDisplay.printDebugInfoN("Context changed - deleting Java-References:");
                this.glState.resetCache = true;
                this.oldContext = gLContext;
            }
            this.init();
        }
    }

    public void renderScene() {
        GLSLDisplay.printDebugInfoN("------ START ------");
        this.glState.updateStamp(this.getView().getGraph().getStamp());
        this.glState.updateTransformations(this);
        if (DEBUG) {
            this.glState.startClock();
        }
        fqrp.process(this, this.glState, null);
        if (DEBUG) {
            long l = this.glState.printClock("Full Pass took: ");
            System.out.printf("Thats >%d FPS\n", 1000000L / l);
            this.glState.popClock();
        }
        GLSLDisplay.printDebugInfoN("------ END ------");
    }

    public void findAndActivateShader(Shader shader) {
        this.glState.csc.findAndActivateShader(this.glState, this, this.glState.getCurrentShaderConfiguration(), shader);
    }

    public GLSLManagedShader findShader(Shader shader) {
        return this.glState.csc.findShader(this.glState, this, this.glState.getCurrentShaderConfiguration(), shader);
    }

    public boolean setupBGShader(Sky sky) {
        this.glState.setupBGShader(sky.getShader());
        if (!this.glState.BGFound) {
            return false;
        }
        if (sky.getShader() instanceof Light) {
            this.glState.setupBGPowerDensity(sky.getPowerDensity());
        } else {
            this.glState.setupBGPowerDensity(sky.getPowerDensity() / 3.0f);
        }
        return true;
    }

    static {
        GLCapabilities gLCapabilities = new GLCapabilities();
        GLPbuffer gLPbuffer = GLDrawableFactory.getFactory().createGLPbuffer(gLCapabilities, null, 1, 1, null);
        class MyEventListener
        implements GLEventListener {
            private JOGL_Test test;
            final Logger logger = Main.getLogger();

            public MyEventListener(JOGL_Test jOGL_Test) {
                this.test = jOGL_Test;
            }

            public int getDepthStencilSetup() {
                return this.test.getDepthStencilSetup();
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                this.test.GLTest(gL, this.logger);
            }

            public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }
        }
        MyEventListener myEventListener = new MyEventListener(new JOGL_Test());
        gLPbuffer.addGLEventListener((GLEventListener)myEventListener);
        gLPbuffer.display();
        gLPbuffer.destroy();
        DEPTH_STENCIL_SETUP = myEventListener.getDepthStencilSetup();
        switch (DEPTH_STENCIL_SETUP) {
            case 3: {
                fqrp = new de.grogra.imp3d.glsl.renderpass.FullQualityRenderPass();
                break;
            }
            default: {
                fqrp = new FullQualityRenderPass();
            }
        }
        if (DEPTH_STENCIL_SETUP != 3) {
            Main.getLogger().warning("GPU not supported by OpenGL (Proteus)");
            throw new RuntimeException("GPU not supported by OpenGL (Proteus)");
        }
    }

    static class PixelStorageModes {
        int packAlignment;
        int packRowLength;
        int packSkipRows;
        int packSkipPixels;
        int packSwapBytes;
        int[] tmp = new int[1];

        PixelStorageModes() {
        }

        void save(GL gL) {
            this.packAlignment = GLSLDisplay.glGetInteger(gL, 3333, this.tmp);
            this.packRowLength = GLSLDisplay.glGetInteger(gL, 3330, this.tmp);
            this.packSkipRows = GLSLDisplay.glGetInteger(gL, 3331, this.tmp);
            this.packSkipPixels = GLSLDisplay.glGetInteger(gL, 3332, this.tmp);
            this.packSwapBytes = GLSLDisplay.glGetInteger(gL, 3328, this.tmp);
            gL.glPixelStorei(3333, 1);
            gL.glPixelStorei(3330, 0);
            gL.glPixelStorei(3331, 0);
            gL.glPixelStorei(3332, 0);
            gL.glPixelStorei(3328, 0);
        }

        void restore(GL gL) {
            gL.glPixelStorei(3333, this.packAlignment);
            gL.glPixelStorei(3330, this.packRowLength);
            gL.glPixelStorei(3331, this.packSkipRows);
            gL.glPixelStorei(3332, this.packSkipPixels);
            gL.glPixelStorei(3328, this.packSwapBytes);
        }
    }
}

