/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.ParallelProjection;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public abstract class Projection
extends ShareableBase {
    protected float aspect = 1.0f;
    public static final Type $TYPE = new Type(Projection.class);
    public static final SCOType.Field aspect$FIELD = Type._addManagedField($TYPE, "aspect", 0x200004, de.grogra.reflect.Type.FLOAT, null, 0);
    protected transient float sx;
    protected transient float sy;

    void setAspect(float f) {
        this.aspect = f;
        this.update();
    }

    public float getAspect() {
        return this.aspect;
    }

    protected abstract void update();

    public float getScaleX() {
        return this.sx;
    }

    public float getScaleY() {
        return this.sy;
    }

    protected abstract void getTransformation(float var1, float var2, Matrix4d var3, Matrix4d var4);

    protected abstract void getRayInViewCoordinates(float var1, float var2, Point3d var3, Vector3d var4, Matrix4d var5, Tuple2d var6);

    public abstract float getScaleAt(float var1);

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random, Matrix4d matrix4d) {
        Point3d point3d = environment.tmpPoint0;
        Point2d point2d = environment.tmpPoint2d0;
        this.getRayInViewCoordinates(environment.uv.x, environment.uv.y, point3d, environment.tmpVector0, matrix4d, (Tuple2d)point2d);
        for (int i = 0; i < rayList.size(); ++i) {
            rayList.rays[i].origin.set((Tuple3d)point3d);
            environment.localToGlobal.transform(rayList.rays[i].origin);
            rayList.rays[i].spectrum.setIdentity();
            if (this instanceof ParallelProjection) {
                rayList.rays[i].spectrum.scale(1.0 / point2d.x);
            }
            rayList.rays[i].originDensity = (float)point2d.x;
        }
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, Random random, Matrix4d matrix4d) {
        Point3d point3d = environment.tmpPoint0;
        Vector3d vector3d = environment.tmpVector0;
        Point2d point2d = environment.tmpPoint2d0;
        this.getRayInViewCoordinates(environment.uv.x, environment.uv.y, point3d, vector3d, matrix4d, (Tuple2d)point2d);
        vector3d.normalize();
        for (int i = 0; i < rayList.size(); ++i) {
            rayList.rays[i].direction.set((Tuple3d)vector3d);
            environment.localToGlobal.transform(rayList.rays[i].direction);
            rayList.rays[i].spectrum.set(spectrum);
            rayList.rays[i].directionDensity = (float)point2d.y;
        }
    }

    public float computeBSDF(Environment environment, Spectrum spectrum, Vector3f vector3f, Spectrum spectrum2) {
        throw new UnsupportedOperationException();
    }

    protected double completeRay(Environment environment, Point3d point3d, Ray ray, Matrix4d matrix4d, Matrix4d matrix4d2) {
        float f;
        double d;
        float f2;
        Vector3f vector3f = environment.userVector;
        vector3f.set((Tuple3d)point3d);
        Math2.transformPoint((Matrix4f)environment.globalToLocal, (Tuple3f)vector3f);
        if (vector3f.z < 0.0f && -1.0f <= (f2 = (float)((d = 1.0 / (matrix4d.m30 * (double)vector3f.x + matrix4d.m31 * (double)vector3f.y + matrix4d.m32 * (double)vector3f.z + matrix4d.m33)) * (matrix4d.m00 * (double)vector3f.x + matrix4d.m01 * (double)vector3f.y + matrix4d.m02 * (double)vector3f.z + matrix4d.m03))) && f2 <= 1.0f && -1.0f <= (f = (float)(d * (matrix4d.m10 * (double)vector3f.x + matrix4d.m11 * (double)vector3f.y + matrix4d.m12 * (double)vector3f.z + matrix4d.m13))) && f <= 1.0f) {
            Point2d point2d = environment.tmpPoint2d0;
            environment.uv.set(f2, f);
            this.getRayInViewCoordinates(f2, f, environment.tmpPoint0, environment.tmpVector0, matrix4d2, (Tuple2d)point2d);
            ray.origin.set((Tuple3d)environment.tmpPoint0);
            ray.spectrum.setIdentity();
            if (this instanceof ParallelProjection) {
                ray.originDensity = 1.0E10f;
            } else {
                ray.originDensity = (float)point2d.x;
                ray.spectrum.scale((double)(ray.directionDensity / vector3f.lengthSquared()));
            }
            ray.directionDensity = (float)point2d.y;
            return point2d.x;
        }
        ray.originDensity = 0.0f;
        ray.directionDensity = 0.0f;
        ray.spectrum.setZero();
        return 0.0;
    }

    float[] getUVForVertex(Environment environment, Point3d point3d, Matrix4d matrix4d, Matrix4d matrix4d2) {
        float f;
        double d;
        float f2;
        float[] fArray = new float[]{-10.0f, -10.0f};
        Vector3f vector3f = environment.userVector;
        vector3f.set((Tuple3d)point3d);
        Math2.transformPoint((Matrix4f)environment.globalToLocal, (Tuple3f)vector3f);
        if (vector3f.z < 0.0f && -1.0f <= (f2 = (float)((d = 1.0 / (matrix4d.m30 * (double)vector3f.x + matrix4d.m31 * (double)vector3f.y + matrix4d.m32 * (double)vector3f.z + matrix4d.m33)) * (matrix4d.m00 * (double)vector3f.x + matrix4d.m01 * (double)vector3f.y + matrix4d.m02 * (double)vector3f.z + matrix4d.m03))) && f2 <= 1.0f && -1.0f <= (f = (float)(d * (matrix4d.m10 * (double)vector3f.x + matrix4d.m11 * (double)vector3f.y + matrix4d.m12 * (double)vector3f.z + matrix4d.m13))) && f <= 1.0f) {
            fArray[0] = f2;
            fArray[1] = f;
        }
        return fArray;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 1;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(Projection projection, SCOType sCOType) {
            super((Object)projection, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 0: {
                    ((Projection)((Object)object)).setAspect(f);
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((Projection)((Object)object)).aspect;
                }
            }
            return super.getFloat(object, n);
        }
    }
}

