/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.CameraBase;
import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.Projection;
import de.grogra.math.TMatrix4d;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.Transaction;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Sensor;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import de.grogra.xl.util.ObjectList;
import java.util.List;
import java.util.Random;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Camera
extends CameraBase
implements Shareable,
Manageable,
Sensor {
    protected float minZ = 0.1f;
    protected float maxZ = 2000.0f;
    protected Projection projection;
    protected final Matrix4d transformation = new TMatrix4d();
    private transient int stamp = 0;
    public static final Type $TYPE = new Type(Camera.class);
    public static final SCOType.Field minZ$FIELD = Type._addManagedField($TYPE, "minZ", 0x200004, de.grogra.reflect.Type.FLOAT, null, 0);
    public static final SCOType.Field maxZ$FIELD = Type._addManagedField($TYPE, "maxZ", 0x200004, de.grogra.reflect.Type.FLOAT, null, 1);
    public static final SCOType.Field projection$FIELD = Type._addManagedField($TYPE, "projection", 0x200004, (de.grogra.reflect.Type)Projection.$TYPE, null, 2);
    public static final SCOType.Field transformation$FIELD = Type._addManagedField($TYPE, "transformation", 2097172, (de.grogra.reflect.Type)TMatrix4d.$TYPE, null, 3);
    protected transient SharedObjectProvider sop;
    private transient ObjectList refs = null;
    private transient Matrix4d worldToClip = new Matrix4d();
    private transient Matrix4d viewToClip = new Matrix4d();
    private transient Matrix4d deviceToView = new Matrix4d();
    private transient Matrix4d viewToWorld = new Matrix4d();

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        projection$FIELD.setObject((Object)this, (Object)projection);
    }

    public Matrix4d getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Matrix4d matrix4d) {
        transformation$FIELD.setObject((Object)this, (Object)matrix4d);
    }

    public Camera() {
        this(new PerspectiveProjection());
    }

    public Camera(Projection projection) {
        this.projection = projection;
        this.transformation.rotX(-0.7853981633974483);
        this.transformation.setColumn(3, 0.0, 0.0, -8.0, 1.0);
        this.update();
    }

    public static Camera createPerspective() {
        return new Camera(new PerspectiveProjection());
    }

    public static Camera createParallel() {
        return new Camera(new ParallelProjection());
    }

    public static Camera createTopView() {
        Camera camera = new Camera(new ParallelProjection());
        Matrix4d matrix4d = camera.transformation;
        matrix4d.setIdentity();
        matrix4d.m23 = -10.0;
        camera.update();
        return camera;
    }

    public static Camera createBottomView() {
        Camera camera = new Camera(new ParallelProjection());
        Matrix4d matrix4d = camera.transformation;
        matrix4d.setIdentity();
        matrix4d.m11 = -1.0;
        matrix4d.m22 = -1.0;
        matrix4d.m23 = -10.0;
        camera.update();
        return camera;
    }

    public static Camera createLeftView() {
        Camera camera = new Camera(new ParallelProjection());
        Matrix4d matrix4d = camera.transformation;
        matrix4d.setIdentity();
        matrix4d.m00 = 0.0;
        matrix4d.m01 = -1.0;
        matrix4d.m11 = 0.0;
        matrix4d.m12 = 1.0;
        matrix4d.m20 = -1.0;
        matrix4d.m22 = 0.0;
        matrix4d.m23 = -10.0;
        camera.update();
        return camera;
    }

    public static Camera createRightView() {
        Camera camera = new Camera(new ParallelProjection());
        Matrix4d matrix4d = camera.transformation;
        matrix4d.setIdentity();
        matrix4d.m00 = 0.0;
        matrix4d.m01 = 1.0;
        matrix4d.m11 = 0.0;
        matrix4d.m12 = 1.0;
        matrix4d.m20 = 1.0;
        matrix4d.m22 = 0.0;
        matrix4d.m23 = -10.0;
        camera.update();
        return camera;
    }

    public static Camera createFrontView() {
        Camera camera = new Camera(new ParallelProjection());
        Matrix4d matrix4d = camera.transformation;
        matrix4d.setIdentity();
        matrix4d.m11 = 0.0;
        matrix4d.m22 = 0.0;
        matrix4d.m12 = 1.0;
        matrix4d.m21 = -1.0;
        matrix4d.m23 = -10.0;
        camera.update();
        return camera;
    }

    public static Camera createBackView() {
        Camera camera = new Camera(new ParallelProjection());
        Matrix4d matrix4d = camera.transformation;
        matrix4d.setIdentity();
        matrix4d.m00 = -1.0;
        matrix4d.m11 = 0.0;
        matrix4d.m12 = 1.0;
        matrix4d.m21 = 1.0;
        matrix4d.m22 = 0.0;
        matrix4d.m23 = -10.0;
        camera.update();
        return camera;
    }

    public void initProvider(SharedObjectProvider sharedObjectProvider) {
        if (this.sop != null) {
            throw new IllegalStateException();
        }
        this.sop = sharedObjectProvider;
    }

    public SharedObjectProvider getProvider() {
        return this.sop;
    }

    public synchronized void addReference(SharedObjectReference sharedObjectReference) {
        if (this.refs == null) {
            this.refs = new ObjectList(4, false);
        }
        this.refs.add((Object)sharedObjectReference);
    }

    public synchronized void removeReference(SharedObjectReference sharedObjectReference) {
        if (this.refs != null) {
            this.refs.remove((Object)sharedObjectReference);
        }
    }

    public synchronized void appendReferencesTo(List list) {
        if (this.refs != null) {
            list.addAll(this.refs);
        }
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        ++this.stamp;
        this.update();
        if (transaction != null && this.sop != null) {
            transaction.fireSharedObjectModified((Shareable)this);
        }
    }

    public int getStamp() {
        return this.stamp;
    }

    private void update() {
        this.projection.getTransformation(this.minZ, this.maxZ, this.viewToClip, this.deviceToView);
        this.worldToClip.mul(this.viewToClip, this.transformation);
        Math2.invertAffine((Matrix4d)this.transformation, (Matrix4d)this.viewToWorld);
    }

    public Manageable manageableReadResolve() {
        this.update();
        return this;
    }

    public Object manageableWriteReplace() {
        return this;
    }

    public float getZNear() {
        return this.minZ;
    }

    public float getZFar() {
        return this.maxZ;
    }

    public void setZNear(float f) {
        this.minZ = f;
    }

    public void setZFar(float f) {
        this.maxZ = f;
    }

    public Matrix4d getWorldToViewTransformation() {
        return this.transformation;
    }

    public void getViewToClipTransformation(Matrix4d matrix4d) {
        this.projection.getTransformation(this.minZ, this.maxZ, matrix4d, null);
    }

    public boolean projectWorld(double d, double d2, double d3, Tuple2f tuple2f) {
        Matrix4d matrix4d = this.worldToClip;
        float f = 1.0f / (float)(matrix4d.m30 * d + matrix4d.m31 * d2 + matrix4d.m32 * d3 + matrix4d.m33);
        float f2 = f * (float)(matrix4d.m20 * d + matrix4d.m21 * d2 + matrix4d.m22 * d3 + matrix4d.m23);
        if (f2 > 1.0f || f2 < -1.0f) {
            return false;
        }
        float f3 = f * (float)(matrix4d.m00 * d + matrix4d.m01 * d2 + matrix4d.m02 * d3 + matrix4d.m03);
        float f4 = f * (float)(matrix4d.m10 * d + matrix4d.m11 * d2 + matrix4d.m12 * d3 + matrix4d.m13);
        tuple2f.x = f3;
        tuple2f.y = f4;
        return true;
    }

    public boolean projectView(float f, float f2, float f3, Tuple2f tuple2f, boolean bl) {
        float f4;
        Matrix4d matrix4d = this.viewToClip;
        float f5 = 1.0f / (float)(matrix4d.m30 * (double)f + matrix4d.m31 * (double)f2 + matrix4d.m32 * (double)f3 + matrix4d.m33);
        if (bl && ((f4 = f5 * (float)(matrix4d.m20 * (double)f + matrix4d.m21 * (double)f2 + matrix4d.m22 * (double)f3 + matrix4d.m23)) > 1.0f || f4 < -1.0f)) {
            return false;
        }
        f4 = f5 * (float)(matrix4d.m00 * (double)f + matrix4d.m01 * (double)f2 + matrix4d.m02 * (double)f3 + matrix4d.m03);
        float f6 = f5 * (float)(matrix4d.m10 * (double)f + matrix4d.m11 * (double)f2 + matrix4d.m12 * (double)f3 + matrix4d.m13);
        tuple2f.x = f4;
        tuple2f.y = f6;
        return true;
    }

    public float getScaleAt(double d, double d2, double d3) {
        Matrix4d matrix4d = this.transformation;
        return (float)matrix4d.getScale() * this.projection.getScaleAt((float)(matrix4d.m20 * d + matrix4d.m21 * d2 + matrix4d.m22 * d3 + matrix4d.m23));
    }

    public float getScaleAt(float f) {
        return this.projection.getScaleAt(f);
    }

    public void getRay(float f, float f2, Point3d point3d, Vector3d vector3d) {
        this.projection.getRayInViewCoordinates(f, f2, point3d, vector3d, this.deviceToView, null);
        this.viewToWorld.transform(point3d);
        this.viewToWorld.transform(vector3d);
        vector3d.normalize();
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        return 0.0;
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        this.projection.generateRandomOrigins(environment, rayList, random, this.deviceToView);
    }

    public int getFlags() {
        return 19;
    }

    public int getAverageColor() {
        return 0;
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        this.projection.generateRandomRays(environment, vector3f, spectrum, rayList, random, this.deviceToView);
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        return this.projection.computeBSDF(environment, spectrum, vector3f2, spectrum2);
    }

    public double completeRay(Environment environment, Point3d point3d, Ray ray) {
        return this.projection.completeRay(environment, point3d, ray, this.viewToClip, this.deviceToView);
    }

    public float[] getUVForVertex(Environment environment, Point3d point3d) {
        return this.projection.getUVForVertex(environment, point3d, this.viewToClip, this.deviceToView);
    }

    static {
        minZ$FIELD.setQuantity(Quantity.LENGTH);
        maxZ$FIELD.setQuantity(Quantity.LENGTH);
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(Camera camera, SCOType sCOType) {
            super((Object)camera, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 0: {
                    ((Camera)object).minZ = f;
                    return;
                }
                case 1: {
                    ((Camera)object).maxZ = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((Camera)object).minZ;
                }
                case 1: {
                    return ((Camera)object).maxZ;
                }
            }
            return super.getFloat(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 2: {
                    ((Camera)object).projection = (Projection)((Object)Projection.$TYPE.setObject((Object)((Camera)object).projection, object2));
                    return;
                }
                case 3: {
                    ((Camera)object).transformation.set((Matrix4d)object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((Camera)object).getProjection();
                }
                case 3: {
                    return ((Camera)object).getTransformation();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new Camera();
        }
    }
}

