/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.util.Quantity;

public class RegularPolygon
extends ContextDependentBase
implements BSplineCurve {
    float circumradius = 1.0f;
    int sideCount = 6;
    boolean topHorizontal;
    float starness = 0.0f;
    int plane;
    boolean reverse;
    public static final Type $TYPE = new Type(RegularPolygon.class);
    public static final SCOType.Field circumradius$FIELD = Type._addManagedField($TYPE, "circumradius", 0x200000, de.grogra.reflect.Type.FLOAT, null, 0);
    public static final SCOType.Field sideCount$FIELD = Type._addManagedField($TYPE, "sideCount", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field topHorizontal$FIELD = Type._addManagedField($TYPE, "topHorizontal", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 2);
    public static final SCOType.Field starness$FIELD = Type._addManagedField($TYPE, "starness", 0x200000, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field plane$FIELD = Type._addManagedField($TYPE, "plane", 0x200000, (de.grogra.reflect.Type)BSpline.SPLINE_PLANE_TYPE, null, 4);
    public static final SCOType.Field reverse$FIELD = Type._addManagedField($TYPE, "reverse", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 5);

    public RegularPolygon(int n) {
        this.sideCount = n;
    }

    public RegularPolygon() {
        this.sideCount = 6;
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isTopHorizontal() {
        return this.topHorizontal;
    }

    public void setTopHorizontal(boolean bl) {
        this.topHorizontal = bl;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public int getSideCount() {
        return this.sideCount;
    }

    public void setSideCount(int n) {
        this.sideCount = n;
    }

    public int getPlane() {
        return this.plane;
    }

    public void setPlane(int n) {
        this.plane = n;
    }

    public float getCircumradius() {
        return this.circumradius;
    }

    public void setCircumradius(float f) {
        this.circumradius = f;
    }

    public float getStarness() {
        return this.starness;
    }

    public void setStarness(float f) {
        this.starness = f;
    }

    public boolean dependsOnContext() {
        return false;
    }

    public boolean isRational(GraphState graphState) {
        return false;
    }

    public int getDimension(GraphState graphState) {
        return this.plane == 0 ? 2 : 3;
    }

    public int getDegree(GraphState graphState) {
        return 1;
    }

    public int getSize(GraphState graphState) {
        return this.sideCount + 1;
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        return (float)(n2 - 1) / (float)this.sideCount;
    }

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        float f = (float)Math.PI / (float)this.sideCount * (float)(this.topHorizontal ? (n << 1) + 1 : (n -= this.sideCount + 2 >> 2) << 1);
        float f2 = (n & 1) == 0 ? this.circumradius : this.circumradius * (1.0f + this.starness);
        float f3 = f2 * (float)Math.cos(f);
        f = -f2 * (float)Math.sin(f);
        if (this.reverse) {
            f = -f;
        }
        switch (this.plane) {
            case 1: {
                return BSpline.set(fArray, f, 0.0f, f3);
            }
            case 2: {
                return BSpline.set(fArray, 0.0f, f, f3);
            }
        }
        return BSpline.set(fArray, f, f3);
    }

    static {
        circumradius$FIELD.setQuantity(Quantity.LENGTH);
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 6;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(RegularPolygon regularPolygon, SCOType sCOType) {
            super((Object)regularPolygon, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 2: {
                    ((RegularPolygon)object).topHorizontal = bl;
                    return;
                }
                case 5: {
                    ((RegularPolygon)object).reverse = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((RegularPolygon)object).isTopHorizontal();
                }
                case 5: {
                    return ((RegularPolygon)object).isReverse();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((RegularPolygon)object).sideCount = n2;
                    return;
                }
                case 4: {
                    ((RegularPolygon)object).plane = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((RegularPolygon)object).getSideCount();
                }
                case 4: {
                    return ((RegularPolygon)object).getPlane();
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 0: {
                    ((RegularPolygon)object).circumradius = f;
                    return;
                }
                case 3: {
                    ((RegularPolygon)object).starness = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((RegularPolygon)object).getCircumradius();
                }
                case 3: {
                    return ((RegularPolygon)object).getStarness();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new RegularPolygon();
        }
    }
}

