/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.util.Int2ObjectMap;
import de.grogra.util.StringMap;

public final class Channel {
    public static final int PX = 0;
    public static final int PY = 1;
    public static final int PZ = 2;
    public static final int NX = 4;
    public static final int NY = 5;
    public static final int NZ = 6;
    public static final int DPXDU = 8;
    public static final int DPYDU = 9;
    public static final int DPZDU = 10;
    public static final int DPXDV = 12;
    public static final int DPYDV = 13;
    public static final int DPZDV = 14;
    public static final int U = 16;
    public static final int V = 17;
    public static final int W = 18;
    public static final int X = 20;
    public static final int Y = 21;
    public static final int Z = 22;
    public static final int R = 24;
    public static final int G = 25;
    public static final int B = 26;
    public static final int A = 27;
    public static final int IOR = 28;
    public static final int MIN_DERIVATIVE = 8;
    public static final int MAX_DERIVATIVE = 14;
    private static final StringMap channels = new StringMap(64, true);
    private static final Int2ObjectMap channelsById = new Int2ObjectMap(64);
    private static int nextId;
    private final String name;
    private final transient int id;

    private static Channel add(String string, int n) {
        Channel channel = new Channel(string, n);
        channels.put(string, (Object)channel);
        channelsById.put(n, (Object)channel);
        nextId = Math.max(nextId, n + 1);
        return channel;
    }

    public static int getCurrentChannelCount() {
        return nextId;
    }

    public static synchronized Channel get(String string) {
        Channel channel = (Channel)channels.get(string);
        return channel != null ? channel : Channel.add(string, nextId);
    }

    public static Channel get(int n) {
        return (Channel)channelsById.get(n);
    }

    private Channel(String string, int n) {
        this.name = string;
        this.id = n;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    private Object readResolve() {
        return Channel.get(this.name);
    }

    public String toString() {
        return "Channel " + this.name + " (id=" + this.id + ')';
    }

    static {
        Channel.add("px", 0);
        Channel.add("py", 1);
        Channel.add("pz", 2);
        Channel.add("nx", 4);
        Channel.add("ny", 5);
        Channel.add("nz", 6);
        Channel.add("dpxdu", 8);
        Channel.add("dpydu", 9);
        Channel.add("dpzdu", 10);
        Channel.add("dpxdv", 12);
        Channel.add("dpydv", 13);
        Channel.add("dpzdv", 14);
        Channel.add("u", 16);
        Channel.add("v", 17);
        Channel.add("w", 18);
        Channel.add("x", 20);
        Channel.add("y", 21);
        Channel.add("z", 22);
        Channel.add("r", 24);
        Channel.add("g", 25);
        Channel.add("b", 26);
        Channel.add("ior", 28);
    }
}

