/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.util;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class ElevationGridComputation {
    private final int xDimension;
    private final int zDimension;
    private final float xSpacing;
    private final float zSpacing;
    private final float[] height;
    private final float creaseAngle;
    private final Vector3f dir0;
    private final Vector3f dir1;
    private final Vector3f vertex0;
    private final Vector3f vertex1;
    private final Vector3f vertex2;
    private final Vector3f vertex3;
    private final Vector3f vertex4;
    private final Vector3f vertex5;
    private final Vector3f normalUL;
    private final Vector3f normalLR;
    private final Vector3f normalPreX;
    private final Vector3f normalPreZ;
    private final Vector3f normalSucX;
    private final Vector3f normalSucZ;

    public ElevationGridComputation(int n, int n2, float f, float f2, float[] fArray, float f3) {
        this.xDimension = n;
        this.zDimension = n2;
        this.xSpacing = f;
        this.zSpacing = f2;
        this.height = fArray;
        this.creaseAngle = f3;
        this.dir0 = new Vector3f();
        this.dir1 = new Vector3f();
        this.vertex0 = new Vector3f();
        this.vertex1 = new Vector3f();
        this.vertex2 = new Vector3f();
        this.vertex3 = new Vector3f();
        this.vertex4 = new Vector3f();
        this.vertex5 = new Vector3f();
        this.normalUL = new Vector3f();
        this.normalLR = new Vector3f();
        this.normalPreX = new Vector3f();
        this.normalPreZ = new Vector3f();
        this.normalSucX = new Vector3f();
        this.normalSucZ = new Vector3f();
    }

    public void getVertex(Tuple3f tuple3f, int n, int n2) {
        tuple3f.x = this.xSpacing * (float)(n + 0);
        tuple3f.y = -this.zSpacing * (float)(n2 + 0);
        tuple3f.z = this.height[n + 0 + (n2 + 0) * this.xDimension];
    }

    public void getNormal(Vector3f vector3f, Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3) {
        this.dir0.x = tuple3f2.x - tuple3f.x;
        this.dir0.y = tuple3f2.y - tuple3f.y;
        this.dir0.z = tuple3f2.z - tuple3f.z;
        this.dir1.x = tuple3f3.x - tuple3f.x;
        this.dir1.y = tuple3f3.y - tuple3f.y;
        this.dir1.z = tuple3f3.z - tuple3f.z;
        vector3f.cross(this.dir1, this.dir0);
        vector3f.normalize();
    }

    public void getNormals(Vector3f vector3f, Vector3f vector3f2, int n, int n2) {
        this.getULNormal(vector3f, n + 0, n2 + 0);
        this.getLRNormal(vector3f2, n + 0, n2 + 0);
    }

    public void getLRNormal(Vector3f vector3f, int n, int n2) {
        this.getVertex((Tuple3f)this.vertex3, n + 1, n2 + 1);
        this.getVertex((Tuple3f)this.vertex4, n + 0, n2 + 1);
        this.getVertex((Tuple3f)this.vertex5, n + 1, n2 + 0);
        this.getNormal(vector3f, (Tuple3f)this.vertex3, (Tuple3f)this.vertex4, (Tuple3f)this.vertex5);
    }

    public void getULNormal(Vector3f vector3f, int n, int n2) {
        this.getVertex((Tuple3f)this.vertex0, n + 0, n2 + 0);
        this.getVertex((Tuple3f)this.vertex1, n + 1, n2 + 0);
        this.getVertex((Tuple3f)this.vertex2, n + 0, n2 + 1);
        this.getNormal(vector3f, (Tuple3f)this.vertex0, (Tuple3f)this.vertex1, (Tuple3f)this.vertex2);
    }

    public void getCreaseNormal(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, Vector3f vector3f6, int n, int n2) {
        this.getNormals(this.normalUL, this.normalLR, n, n2);
        if (n > 0 && n2 > 0) {
            this.getLRNormal(this.normalPreX, n - 1, n2 - 1);
        } else {
            this.normalPreX.set((Tuple3f)this.normalUL);
        }
        if (n < this.xDimension - 2 && n2 < this.zDimension - 2) {
            this.getULNormal(this.normalSucX, n + 1, n2 + 1);
        } else {
            this.normalSucX.set((Tuple3f)this.normalLR);
        }
        vector3f.set((Tuple3f)this.normalUL);
        if (this.normalPreX.angle(this.normalUL) < this.creaseAngle) {
            vector3f.set(this.normalPreX.x + vector3f.x, this.normalPreX.y + vector3f.y, this.normalPreX.z + vector3f.z);
            vector3f.normalize();
        }
        vector3f4.set((Tuple3f)this.normalLR);
        if (this.normalSucX.angle(this.normalLR) < this.creaseAngle) {
            vector3f4.set(this.normalSucX.x + vector3f4.x, this.normalSucX.y + vector3f4.y, this.normalSucX.z + vector3f4.z);
            vector3f4.normalize();
        }
        if (this.normalUL.angle(this.normalLR) < this.creaseAngle) {
            vector3f2.set((this.normalUL.x + this.normalLR.x) / 2.0f, (this.normalUL.y + this.normalLR.y) / 2.0f, (this.normalUL.z + this.normalLR.z) / 2.0f);
            vector3f2.normalize();
            vector3f3.set((Tuple3f)vector3f2);
            vector3f5.set((Tuple3f)vector3f2);
            vector3f6.set((Tuple3f)vector3f2);
        } else {
            vector3f2.set((Tuple3f)this.normalUL);
            vector3f3.set((Tuple3f)this.normalUL);
            vector3f5.set((Tuple3f)this.normalLR);
            vector3f6.set((Tuple3f)this.normalLR);
        }
    }
}

