/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.importation;

import de.grogra.ext.x3d.ProtoInstanceImport;
import de.grogra.ext.x3d.X3DImport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.BackgroundDocument;
import de.grogra.ext.x3d.xmlbeans.X3DNode;
import de.grogra.graph.impl.Node;
import de.grogra.imp.objects.ImageAdapter;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.ChannelMap;
import de.grogra.math.Tuple3fType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundImport {
    public static Sky createInstance(BackgroundDocument.Background background) {
        Sky sky = null;
        HashMap<String, Object> hashMap = X3DImport.getTheImport().getCurrentParser().getReferenceMap();
        if (background.isSetUSE()) {
            try {
                sky = (Sky)((Node)hashMap.get(background.getUSE())).clone(true);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            sky = new Sky();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (background.isSetIS()) {
                ProtoInstanceImport.calcFinalValueMap(hashMap2, (X3DNode)background);
            }
            BackgroundImport.setValues(sky, background, hashMap2);
            if (background.isSetDEF()) {
                hashMap.put(background.getDEF(), sky);
            }
        }
        sky.setName("X3DBackground");
        return sky;
    }

    private static void setValues(Sky sky, BackgroundDocument.Background background, HashMap<String, String> hashMap) {
        Object object;
        String string;
        String string2;
        ImageAdapter imageAdapter;
        int n;
        Object object2;
        String string3;
        String string4;
        X3DImport x3DImport = X3DImport.getTheImport();
        int n2 = 2048;
        int n3 = 1024;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        String string5 = string4 = hashMap.containsKey("skyColor") ? hashMap.get("skyColor") : background.getSkyColor();
        if (string4 != null) {
            fArray = Util.splitStringToArrayOfFloat(string4);
        }
        float[] fArray2 = new float[]{};
        String string6 = string3 = hashMap.containsKey("skyAngle") ? hashMap.get("skyAngle") : background.getSkyAngle();
        if (string3 != null) {
            fArray2 = Util.splitStringToArrayOfFloat(string3);
        }
        x3DImport.increaseProgress();
        if (fArray2.length == 0) {
            object2 = new Color3f(fArray[0], fArray[1], fArray[2]);
            n = Tuple3fType.colorToInt((Tuple3f)object2);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    bufferedImage.setRGB(i, j, n);
                }
            }
        } else {
            int n4 = 0;
            for (n = 0; n < n3; ++n) {
                double[] dArray;
                double d;
                double d2;
                double d3 = (double)n / (double)n3;
                double[] dArray2 = new double[]{fArray[3 * n4 + 0], fArray[3 * n4 + 1], fArray[3 * n4 + 2]};
                if (n4 == 0) {
                    d2 = fArray2[n4];
                    d = 0.0;
                    dArray = new double[]{fArray[3 * (n4 + 1) + 0], fArray[3 * (n4 + 1) + 1], fArray[3 * (n4 + 1) + 2]};
                } else if (n4 < fArray2.length) {
                    d2 = fArray2[n4];
                    d = fArray2[n4 - 1];
                    dArray = new double[]{fArray[3 * (n4 + 1) + 0], fArray[3 * (n4 + 1) + 1], fArray[3 * (n4 + 1) + 2]};
                } else {
                    d2 = Math.PI;
                    d = fArray2[n4 - 1];
                    dArray = new double[]{fArray[3 * n4 + 0], fArray[3 * n4 + 1], fArray[3 * n4 + 2]};
                }
                double d4 = (d3 - d / Math.PI) / ((d2 - d) / Math.PI);
                imageAdapter = new Color3f();
                imageAdapter.x = (float)((1.0 - d4) * dArray2[0] + d4 * dArray[0]);
                imageAdapter.y = (float)((1.0 - d4) * dArray2[1] + d4 * dArray[1]);
                imageAdapter.z = (float)((1.0 - d4) * dArray2[2] + d4 * dArray[2]);
                for (int i = 0; i < n2; ++i) {
                    bufferedImage.setRGB(i, n, Tuple3fType.colorToInt((Tuple3f)imageAdapter));
                }
                if (!(d3 >= d2 / Math.PI)) continue;
                ++n4;
            }
        }
        object2 = new float[]{0.0f, 0.0f, 0.0f};
        String string7 = string2 = hashMap.containsKey("groundColor") ? hashMap.get("groundColor") : background.getGroundColor();
        if (string2 != null) {
            object2 = Util.splitStringToArrayOfFloat(string2);
        }
        float[] fArray3 = new float[]{};
        String string8 = string = hashMap.containsKey("groundAngle") ? hashMap.get("groundAngle") : background.getGroundAngle();
        if (string != null) {
            fArray3 = Util.splitStringToArrayOfFloat(string);
        }
        x3DImport.increaseProgress();
        if (fArray3.length != 0) {
            int n5 = 0;
            int n6 = (int)((double)fArray3[fArray3.length - 1] / Math.PI * (double)n3);
            for (int i = 0; i < n6; ++i) {
                double[] dArray;
                double d;
                double d5;
                double d6 = (double)i / (double)n3;
                object = new double[]{(double)object2[3 * n5 + 0], (double)object2[3 * n5 + 1], (double)object2[3 * n5 + 2]};
                if (n5 == 0) {
                    d5 = fArray3[n5];
                    d = 0.0;
                    dArray = new double[]{(double)object2[3 * (n5 + 1) + 0], (double)object2[3 * (n5 + 1) + 1], (double)object2[3 * (n5 + 1) + 2]};
                } else if (n5 < fArray3.length) {
                    d5 = fArray3[n5];
                    d = fArray3[n5 - 1];
                    dArray = new double[]{(double)object2[3 * (n5 + 1) + 0], (double)object2[3 * (n5 + 1) + 1], (double)object2[3 * (n5 + 1) + 2]};
                } else {
                    d5 = Math.PI;
                    d = fArray3[n5 - 1];
                    dArray = new double[]{(double)object2[3 * n5 + 0], (double)object2[3 * n5 + 1], (double)object2[3 * n5 + 2]};
                }
                double d7 = (d6 - d / Math.PI) / ((d5 - d) / Math.PI);
                Color3f color3f = new Color3f();
                color3f.x = (float)((1.0 - d7) * object[0] + d7 * dArray[0]);
                color3f.y = (float)((1.0 - d7) * object[1] + d7 * dArray[1]);
                color3f.z = (float)((1.0 - d7) * object[2] + d7 * dArray[2]);
                for (int j = 0; j < n2; ++j) {
                    bufferedImage.setRGB(j, n3 - i - 1, Tuple3fType.colorToInt((Tuple3f)color3f));
                }
                if (!(d6 >= d5 / Math.PI)) continue;
                ++n5;
            }
        }
        X3DImport.getTheImport().increaseProgress();
        if (background.isSetTopUrl() || background.isSetLeftUrl() || background.isSetFrontUrl() || background.isSetRightUrl() || background.isSetBackUrl() || background.isSetBottomUrl()) {
            BufferedImage bufferedImage2 = null;
            BufferedImage bufferedImage3 = null;
            BufferedImage bufferedImage4 = null;
            BufferedImage bufferedImage5 = null;
            BufferedImage bufferedImage6 = null;
            object = null;
            ImageAdapter imageAdapter2 = null;
            if (background.isSetTopUrl()) {
                imageAdapter2 = Util.getImageForURL(background.getTopUrl(), hashMap, false);
                bufferedImage2 = imageAdapter2.getBufferedImage();
                x3DImport.increaseProgress();
            }
            ImageAdapter imageAdapter3 = null;
            if (background.isSetLeftUrl()) {
                imageAdapter3 = Util.getImageForURL(background.getLeftUrl(), hashMap, false);
                bufferedImage3 = imageAdapter3.getBufferedImage();
                x3DImport.increaseProgress();
            }
            imageAdapter = null;
            if (background.isSetFrontUrl()) {
                imageAdapter = Util.getImageForURL(background.getFrontUrl(), hashMap, false);
                bufferedImage4 = imageAdapter.getBufferedImage();
                x3DImport.increaseProgress();
            }
            ImageAdapter imageAdapter4 = null;
            if (background.isSetRightUrl()) {
                imageAdapter4 = Util.getImageForURL(background.getRightUrl(), hashMap, false);
                bufferedImage5 = imageAdapter4.getBufferedImage();
            }
            ImageAdapter imageAdapter5 = null;
            if (background.isSetBackUrl()) {
                imageAdapter5 = Util.getImageForURL(background.getBackUrl(), hashMap, false);
                bufferedImage6 = imageAdapter5.getBufferedImage();
                x3DImport.increaseProgress();
            }
            ImageAdapter imageAdapter6 = null;
            if (background.isSetBottomUrl()) {
                imageAdapter6 = Util.getImageForURL(background.getBottomUrl(), hashMap, false);
                object = imageAdapter6.getBufferedImage();
                x3DImport.increaseProgress();
            }
            for (int i = 0; i < n2; ++i) {
                x3DImport.increaseProgress();
                for (int j = 0; j < n3; ++j) {
                    int n7;
                    double d;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12 = (double)i / (double)(n2 - 1);
                    double d13 = (double)j / (double)(n3 - 1);
                    double d14 = d12 * 2.0 * Math.PI;
                    double d15 = d13 * Math.PI - 1.5707963267948966;
                    if (d14 <= 2.356194490192345 || d14 > 5.497787143782138) {
                        if (bufferedImage6 != null) {
                            d11 = 1.5707963267948966;
                            d10 = 0.0;
                            d9 = Math.sin(d10) * Math.sin(d15) + Math.cos(d10) * Math.cos(d15) * Math.cos(d14 - d11);
                            d8 = Math.cos(d15) * Math.sin(d14 - d11) / d9;
                            d = (Math.cos(d10) * Math.sin(d15) - Math.sin(d10) * Math.cos(d15) * Math.cos(d14 - d11)) / d9;
                            if (d8 >= -1.0 && d8 < 1.0 && d > -1.0 && d < 1.0) {
                                d8 = (d8 + 1.0) / 2.0 * (double)(bufferedImage6.getWidth() - 1);
                                d = (d + 1.0) / 2.0 * (double)(bufferedImage6.getHeight() - 1);
                                n7 = bufferedImage6.getRGB((int)Math.round(d8), (int)Math.round(d));
                                n7 = Util.overlapPixel(bufferedImage.getRGB(i, j), n7);
                                bufferedImage.setRGB(i, j, n7);
                                continue;
                            }
                        }
                        if (bufferedImage5 != null) {
                            d11 = 0.0;
                            d10 = 0.0;
                            d9 = Math.sin(d10) * Math.sin(d15) + Math.cos(d10) * Math.cos(d15) * Math.cos(d14 - d11);
                            d8 = Math.cos(d15) * Math.sin(d14 - d11) / d9;
                            d = (Math.cos(d10) * Math.sin(d15) - Math.sin(d10) * Math.cos(d15) * Math.cos(d14 - d11)) / d9;
                            if (d8 >= -1.0 && d8 < 1.0 && d > -1.0 && d < 1.0) {
                                d8 = (d8 + 1.0) / 2.0 * (double)(bufferedImage5.getWidth() - 1);
                                d = (d + 1.0) / 2.0 * (double)(bufferedImage5.getHeight() - 1);
                                n7 = bufferedImage5.getRGB((int)Math.round(d8), (int)Math.round(d));
                                n7 = Util.overlapPixel(bufferedImage.getRGB(i, j), n7);
                                bufferedImage.setRGB(i, j, n7);
                                continue;
                            }
                        }
                    } else {
                        if (bufferedImage4 != null) {
                            d11 = 4.71238898038469;
                            d10 = 0.0;
                            d9 = Math.sin(d10) * Math.sin(d15) + Math.cos(d10) * Math.cos(d15) * Math.cos(d14 - d11);
                            d8 = Math.cos(d15) * Math.sin(d14 - d11) / d9;
                            d = (Math.cos(d10) * Math.sin(d15) - Math.sin(d10) * Math.cos(d15) * Math.cos(d14 - d11)) / d9;
                            if (d8 >= -1.0 && d8 < 1.0 && d > -1.0 && d < 1.0) {
                                d8 = (d8 + 1.0) / 2.0 * (double)(bufferedImage4.getWidth() - 1);
                                d = (d + 1.0) / 2.0 * (double)(bufferedImage4.getHeight() - 1);
                                n7 = bufferedImage4.getRGB((int)Math.round(d8), (int)Math.round(d));
                                n7 = Util.overlapPixel(bufferedImage.getRGB(i, j), n7);
                                bufferedImage.setRGB(i, j, n7);
                                continue;
                            }
                        }
                        if (bufferedImage3 != null) {
                            d11 = Math.PI;
                            d10 = 0.0;
                            d9 = Math.sin(d10) * Math.sin(d15) + Math.cos(d10) * Math.cos(d15) * Math.cos(d14 - d11);
                            d8 = Math.cos(d15) * Math.sin(d14 - d11) / d9;
                            d = (Math.cos(d10) * Math.sin(d15) - Math.sin(d10) * Math.cos(d15) * Math.cos(d14 - d11)) / d9;
                            if (d8 >= -1.0 && d8 < 1.0 && d > -1.0 && d < 1.0) {
                                d8 = (d8 + 1.0) / 2.0 * (double)(bufferedImage3.getWidth() - 1);
                                d = (d + 1.0) / 2.0 * (double)(bufferedImage3.getHeight() - 1);
                                n7 = bufferedImage3.getRGB((int)Math.round(d8), (int)Math.round(d));
                                n7 = Util.overlapPixel(bufferedImage.getRGB(i, j), n7);
                                bufferedImage.setRGB(i, j, n7);
                                continue;
                            }
                        }
                    }
                    if (d15 <= 0.7853981633974483 && bufferedImage2 != null) {
                        d11 = 4.71238898038469;
                        d10 = -1.5707963267948966;
                        d9 = Math.sin(d10) * Math.sin(d15) + Math.cos(d10) * Math.cos(d15) * Math.cos(d14 - d11);
                        d8 = Math.cos(d15) * Math.sin(d14 - d11) / d9;
                        d = (Math.cos(d10) * Math.sin(d15) - Math.sin(d10) * Math.cos(d15) * Math.cos(d14 - d11)) / d9;
                        if (d8 >= -1.0 && d8 < 1.0 && d > -1.0 && d < 1.0) {
                            d8 = (d8 + 1.0) / 2.0 * (double)(bufferedImage2.getWidth() - 1);
                            d = (d + 1.0) / 2.0 * (double)(bufferedImage2.getHeight() - 1);
                            n7 = bufferedImage2.getRGB((int)Math.round(d8), (int)Math.round(d));
                            n7 = Util.overlapPixel(bufferedImage.getRGB(i, j), n7);
                            bufferedImage.setRGB(i, j, n7);
                            continue;
                        }
                    }
                    if (!(d15 >= 0.7853981633974483) || object == null) continue;
                    d11 = 4.71238898038469;
                    d10 = 1.5707963267948966;
                    d9 = Math.sin(d10) * Math.sin(d15) + Math.cos(d10) * Math.cos(d15) * Math.cos(d14 - d11);
                    d8 = Math.cos(d15) * Math.sin(d14 - d11) / d9;
                    d = (Math.cos(d10) * Math.sin(d15) - Math.sin(d10) * Math.cos(d15) * Math.cos(d14 - d11)) / d9;
                    if (!(d8 >= -1.0) || !(d8 < 1.0) || !(d > -1.0) || !(d < 1.0)) continue;
                    d8 = (d8 + 1.0) / 2.0 * (double)(((BufferedImage)object).getWidth() - 1);
                    d = (d + 1.0) / 2.0 * (double)(((BufferedImage)object).getHeight() - 1);
                    n7 = ((BufferedImage)object).getRGB((int)Math.round(d8), (int)Math.round(d));
                    n7 = Util.overlapPixel(bufferedImage.getRGB(i, j), n7);
                    bufferedImage.setRGB(i, j, n7);
                }
            }
        }
        x3DImport.increaseProgress();
        File file = null;
        try {
            file = File.createTempFile("x3dbackground", ".png");
            x3DImport.increaseProgress();
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        x3DImport.increaseProgress();
        ImageAdapter imageAdapter7 = Util.getImageForURL(file.getPath(), true);
        ImageMap imageMap = new ImageMap();
        imageMap.setImageAdapter(imageAdapter7);
        imageMap.setBilinearFiltering(false);
        Phong phong = new Phong();
        phong.setDiffuse((ChannelMap)imageMap);
        sky.setShader((Shader)phong);
    }
}

