/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.ChannelMapNodeVisitor;
import de.grogra.imp3d.shading.VolumeFunction;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;

public class VolumeTurbulence
extends VolumeFunction {
    float size = 1.0f;
    int octaves = 5;
    float noiseRatio = 1.0f;
    float frequencyRatio = 2.0f;
    public static final Node.NType $TYPE = new Node.NType((Node)new VolumeTurbulence());
    public static final Node.NType.Field size$FIELD = new _Field("size", 0x200000, Type.FLOAT, null, 0);
    public static final Node.NType.Field octaves$FIELD;
    public static final Node.NType.Field noiseRatio$FIELD;
    public static final Node.NType.Field frequencyRatio$FIELD;

    public static VolumeTurbulence createWrinkles() {
        VolumeTurbulence volumeTurbulence = new VolumeTurbulence();
        volumeTurbulence.frequency = 1.0f;
        volumeTurbulence.size = 1.0f;
        volumeTurbulence.octaves = 11;
        volumeTurbulence.frequencyRatio = 2.0f;
        volumeTurbulence.noiseRatio = 0.5f;
        return volumeTurbulence;
    }

    protected float getFloatValue(float f, float f2, float f3) {
        int n = Math.max(1, Math.min(this.octaves, 11));
        float f4 = 1.0f;
        if (Math.abs(this.noiseRatio) > 1.0f) {
            f4 = (float)((double)f4 / Math.pow(Math.abs(this.noiseRatio), n - 1));
        }
        return f4 * Math2.turbulence((float)(f * this.size), (float)(f2 * this.size), (float)(f3 * this.size), (int)n, (float)this.frequencyRatio, (float)this.noiseRatio);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new VolumeTurbulence();
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOctaves(int n) {
        this.octaves = n;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float f) {
        this.size = f;
    }

    public float getNoiseRatio() {
        return this.noiseRatio;
    }

    public void setNoiseRatio(float f) {
        this.noiseRatio = f;
    }

    public float getFrequencyRatio() {
        return this.frequencyRatio;
    }

    public void setFrequencyRatio(float f) {
        this.frequencyRatio = f;
    }

    public void accept(ChannelMapNodeVisitor channelMapNodeVisitor) {
        channelMapNodeVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)size$FIELD);
        octaves$FIELD = new _Field("octaves", 0x200000, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)octaves$FIELD);
        noiseRatio$FIELD = new _Field("noiseRatio", 0x200000, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)noiseRatio$FIELD);
        frequencyRatio$FIELD = new _Field("frequencyRatio", 0x200000, Type.FLOAT, null, 3);
        $TYPE.addManagedField((ManageableType.Field)frequencyRatio$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 1: {
                    ((VolumeTurbulence)((Object)object)).octaves = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 1: {
                    return ((VolumeTurbulence)((Object)object)).getOctaves();
                }
            }
            return super.getInt(object);
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((VolumeTurbulence)((Object)object)).size = f;
                    return;
                }
                case 2: {
                    ((VolumeTurbulence)((Object)object)).noiseRatio = f;
                    return;
                }
                case 3: {
                    ((VolumeTurbulence)((Object)object)).frequencyRatio = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((VolumeTurbulence)((Object)object)).getSize();
                }
                case 2: {
                    return ((VolumeTurbulence)((Object)object)).getNoiseRatio();
                }
                case 3: {
                    return ((VolumeTurbulence)((Object)object)).getFrequencyRatio();
                }
            }
            return super.getFloat(object);
        }
    }
}

