/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.ChannelMapNodeVisitor;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.imp3d.shading.Material;
import de.grogra.imp3d.shading.ShaderVisitor;
import de.grogra.math.Tuple3dType;
import de.grogra.persistence.ManageableType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.sunflow.image.ChromaticitySpectrum;
import org.sunflow.image.ConstantSpectralCurve;
import org.sunflow.image.IrregularSpectralCurve;
import org.sunflow.image.RGBSpace;
import org.sunflow.image.RegularSpectralCurve;
import org.sunflow.image.SpectralCurve;
import org.sunflow.math.MathUtils;

public class SunSkyLight
extends Material
implements Light {
    final Vector3d sun = new Vector3d(0.0, 1.0, 0.4);
    float turbidity = 6.0f;
    float radianceFactor = 1.0f;
    boolean disableLight = false;
    boolean disableSun = false;
    private int numSkySamples = 64;
    private int derivedStamp = -1;
    private Vector3d sunDir = new Vector3d();
    private Matrix3d sunBasis = new Matrix3d();
    private SpectralCurve sunSpectralRadiance;
    private Spectrum3f sunColor;
    private double sunTheta;
    private double cosSunTheta;
    private double zenithY;
    private double zenithx;
    private double zenithy;
    private final double[] perezY = new double[5];
    private final double[] perezx = new double[5];
    private final double[] perezy = new double[5];
    private double jacobian;
    private Spectrum3f irradiance = new Spectrum3f();
    private Spectrum3f invIrradiance = new Spectrum3f();
    private float sunFraction;
    private double[] lumColHistogram;
    private double[][] lumImageHistogram;
    private double[] colHistogram;
    private double[][] imageHistogram;
    private static final float[] solAmplitudes = new float[]{165.5f, 162.3f, 211.2f, 258.8f, 258.2f, 242.3f, 267.6f, 296.6f, 305.4f, 300.6f, 306.6f, 288.3f, 287.1f, 278.2f, 271.0f, 272.3f, 263.6f, 255.0f, 250.6f, 253.1f, 253.5f, 251.3f, 246.3f, 241.7f, 236.8f, 232.1f, 228.2f, 223.4f, 219.7f, 215.3f, 211.0f, 207.3f, 202.4f, 198.7f, 194.3f, 190.7f, 186.3f, 182.6f};
    private static final RegularSpectralCurve solCurve = new RegularSpectralCurve(solAmplitudes, 380.0f, 750.0f);
    private static final float[] k_oWavelengths = new float[]{300.0f, 305.0f, 310.0f, 315.0f, 320.0f, 325.0f, 330.0f, 335.0f, 340.0f, 345.0f, 350.0f, 355.0f, 445.0f, 450.0f, 455.0f, 460.0f, 465.0f, 470.0f, 475.0f, 480.0f, 485.0f, 490.0f, 495.0f, 500.0f, 505.0f, 510.0f, 515.0f, 520.0f, 525.0f, 530.0f, 535.0f, 540.0f, 545.0f, 550.0f, 555.0f, 560.0f, 565.0f, 570.0f, 575.0f, 580.0f, 585.0f, 590.0f, 595.0f, 600.0f, 605.0f, 610.0f, 620.0f, 630.0f, 640.0f, 650.0f, 660.0f, 670.0f, 680.0f, 690.0f, 700.0f, 710.0f, 720.0f, 730.0f, 740.0f, 750.0f, 760.0f, 770.0f, 780.0f, 790.0f};
    private static final float[] k_oAmplitudes = new float[]{10.0f, 4.8f, 2.7f, 1.35f, 0.8f, 0.38f, 0.16f, 0.075f, 0.04f, 0.019f, 0.007f, 0.0f, 0.003f, 0.003f, 0.004f, 0.006f, 0.008f, 0.009f, 0.012f, 0.014f, 0.017f, 0.021f, 0.025f, 0.03f, 0.035f, 0.04f, 0.045f, 0.048f, 0.057f, 0.063f, 0.07f, 0.075f, 0.08f, 0.085f, 0.095f, 0.103f, 0.11f, 0.12f, 0.122f, 0.12f, 0.118f, 0.115f, 0.12f, 0.125f, 0.13f, 0.12f, 0.105f, 0.09f, 0.079f, 0.067f, 0.057f, 0.048f, 0.036f, 0.028f, 0.023f, 0.018f, 0.014f, 0.011f, 0.01f, 0.009f, 0.007f, 0.004f, 0.0f, 0.0f};
    private static final float[] k_gWavelengths = new float[]{759.0f, 760.0f, 770.0f, 771.0f};
    private static final float[] k_gAmplitudes = new float[]{0.0f, 3.0f, 0.21f, 0.0f};
    private static final float[] k_waWavelengths = new float[]{689.0f, 690.0f, 700.0f, 710.0f, 720.0f, 730.0f, 740.0f, 750.0f, 760.0f, 770.0f, 780.0f, 790.0f, 800.0f};
    private static final float[] k_waAmplitudes = new float[]{0.0f, 0.016f, 0.024f, 0.0125f, 1.0f, 0.87f, 0.061f, 0.001f, 1.0E-5f, 1.0E-5f, 6.0E-4f, 0.0175f, 0.036f};
    private static final IrregularSpectralCurve k_oCurve = new IrregularSpectralCurve(k_oWavelengths, k_oAmplitudes);
    private static final IrregularSpectralCurve k_gCurve = new IrregularSpectralCurve(k_gWavelengths, k_gAmplitudes);
    private static final IrregularSpectralCurve k_waCurve = new IrregularSpectralCurve(k_waWavelengths, k_waAmplitudes);
    private static final double sunAngle = 0.00930842267730309;
    private static final double cosHalfSunAngle = 0.9999891691584076;
    private static final double sunSolidAngle = 6.80521847575598E-5;
    public static final Node.NType $TYPE = new Node.NType((Node)new SunSkyLight());
    public static final Node.NType.Field sun$FIELD = new _Field("sun", 0x200010, (Type)Tuple3dType.VECTOR, null, 0);
    public static final Node.NType.Field turbidity$FIELD;
    public static final Node.NType.Field radianceFactor$FIELD;
    public static final Node.NType.Field disableLight$FIELD;
    public static final Node.NType.Field disableSun$FIELD;

    private void update() {
        if (this.derivedStamp == this.getStamp()) {
            return;
        }
        this.initSunSky();
        this.derivedStamp = this.getStamp();
    }

    private static SpectralCurve computeAttenuatedSunlight(double d, double d2) {
        float[] fArray = new float[91];
        double d3 = 0.0460836582205 * d2 - 0.04586025928522;
        double d4 = 1.0 / (Math.cos(d) + 9.4E-4 * Math.pow(1.6386 - d, -1.253));
        int n = 0;
        for (int i = 350; i <= 800; i += 5) {
            double d5 = Math.exp(-d4 * 0.008735 * Math.pow((double)i / 1000.0, -4.08));
            double d6 = Math.exp(-d4 * d3 * Math.pow((double)i / 1000.0, -1.3));
            double d7 = Math.exp(-d4 * (double)k_oCurve.sample((float)i) * 0.35);
            double d8 = Math.exp(-1.41 * (double)k_gCurve.sample((float)i) * d4 / Math.pow(1.0 + 118.93 * (double)k_gCurve.sample((float)i) * d4, 0.45));
            double d9 = Math.exp(-0.2385 * (double)k_waCurve.sample((float)i) * 2.0 * d4 / Math.pow(1.0 + 20.07 * (double)k_waCurve.sample((float)i) * 2.0 * d4, 0.45));
            double d10 = 100.0 * (double)solCurve.sample((float)i) * d5 * d6 * d7 * d8 * d9;
            fArray[n] = (float)d10;
            ++n;
        }
        return new RegularSpectralCurve(fArray, 350.0f, 800.0f);
    }

    private double perezFunction(double[] dArray, double d, double d2, double d3, double d4) {
        double d5 = (1.0 + dArray[0] * Math.exp(dArray[1])) * (1.0 + dArray[2] * Math.exp(dArray[3] * this.sunTheta) + dArray[4] * this.cosSunTheta * this.cosSunTheta);
        double d6 = (1.0 + dArray[0] * Math.exp(dArray[1] / d)) * (1.0 + dArray[2] * Math.exp(dArray[3] * d2) + dArray[4] * d3 * d3);
        return d4 * d6 / d5;
    }

    static float getLuminance(float f, float f2, float f3) {
        return 0.2989f * f + 0.5866f * f2 + 0.1145f * f3;
    }

    private void initSunSky() {
        this.sunDir.set((Tuple3d)this.sun);
        this.sunDir.normalize();
        Math2.getOrthogonalBasis((Tuple3d)this.sunDir, (Matrix3d)this.sunBasis, (boolean)true);
        this.cosSunTheta = MathUtils.clamp((double)this.sunDir.z, (double)-1.0, (double)1.0);
        this.sunTheta = Math.acos(this.cosSunTheta);
        this.sunColor = new Spectrum3f();
        if (this.sunDir.z > 0.0) {
            this.sunSpectralRadiance = SunSkyLight.computeAttenuatedSunlight(this.sunTheta, this.turbidity);
            RGBSpace.SRGB.convertXYZtoRGB(this.sunSpectralRadiance.toXYZ(), (Tuple3f)this.sunColor);
            SunSkyLight.constrainRGB((Tuple3f)this.sunColor);
        } else {
            this.sunSpectralRadiance = new ConstantSpectralCurve(0.0f);
            this.sunColor.setZero();
        }
        double d = this.sunTheta * this.sunTheta;
        double d2 = this.sunTheta * d;
        double d3 = this.turbidity;
        double d4 = this.turbidity * this.turbidity;
        double d5 = (0.4444444444444444 - d3 / 120.0) * (Math.PI - 2.0 * this.sunTheta);
        this.zenithY = (4.0453 * d3 - 4.971) * Math.tan(d5) - 0.2155 * d3 + 2.4192;
        this.zenithY *= 1000.0;
        this.zenithx = (0.00165 * d2 - 0.00374 * d + 0.00208 * this.sunTheta + 0.0) * d4 + (-0.02902 * d2 + 0.06377 * d - 0.03202 * this.sunTheta + 0.00394) * d3 + (0.11693 * d2 - 0.21196 * d + 0.06052 * this.sunTheta + 0.25885);
        this.zenithy = (0.00275 * d2 - 0.0061 * d + 0.00316 * this.sunTheta + 0.0) * d4 + (-0.04212 * d2 + 0.0897 * d - 0.04153 * this.sunTheta + 0.00515) * d3 + (0.15346 * d2 - 0.26756 * d + 0.06669 * this.sunTheta + 0.26688);
        this.perezY[0] = 0.17872 * d3 - 1.46303;
        this.perezY[1] = -0.3554 * d3 + 0.42749;
        this.perezY[2] = -0.02266 * d3 + 5.32505;
        this.perezY[3] = 0.12064 * d3 - 2.57705;
        this.perezY[4] = -0.06696 * d3 + 0.37027;
        this.perezx[0] = -0.01925 * d3 - 0.25922;
        this.perezx[1] = -0.06651 * d3 + 8.1E-4;
        this.perezx[2] = -4.1E-4 * d3 + 0.21247;
        this.perezx[3] = -0.06409 * d3 - 0.89887;
        this.perezx[4] = -0.00325 * d3 + 0.04517;
        this.perezy[0] = -0.01669 * d3 - 0.26078;
        this.perezy[1] = -0.09495 * d3 + 0.00921;
        this.perezy[2] = -0.00792 * d3 + 0.21023;
        this.perezy[3] = -0.04405 * d3 - 1.65369;
        this.perezy[4] = -0.01092 * d3 + 0.05291;
        this.lumImageHistogram = new double[32][32];
        this.lumColHistogram = new double[32];
        this.imageHistogram = new double[32][32];
        this.colHistogram = new double[32];
        double d6 = 0.03125;
        double d7 = 0.03125;
        Color3f color3f = new Color3f();
        Vector3d vector3d = new Vector3d();
        Color3f color3f2 = new Color3f();
        for (int i = 0; i < 32; ++i) {
            int n;
            for (n = 0; n < 32; ++n) {
                double d8 = (double)((float)i + 0.5f) * d6;
                double d9 = (double)((float)n + 0.5f) * d7;
                this.getDirection(d8, d9, vector3d);
                this.getSkyRGB(vector3d, (Tuple3f)color3f);
                double d10 = Math.sin(Math.PI * d9);
                this.imageHistogram[i][n] = (double)(color3f.x + color3f.y + color3f.z) * d10;
                color3f2.scaleAdd((float)d10, (Tuple3f)color3f, (Tuple3f)color3f2);
                this.lumImageHistogram[i][n] = (double)SunSkyLight.getLuminance(color3f.x, color3f.y, color3f.z) * d10;
                if (n <= 0) continue;
                double[] dArray = this.imageHistogram[i];
                int n2 = n;
                dArray[n2] = dArray[n2] + this.imageHistogram[i][n - 1];
                double[] dArray2 = this.lumImageHistogram[i];
                int n3 = n;
                dArray2[n3] = dArray2[n3] + this.lumImageHistogram[i][n - 1];
            }
            this.colHistogram[i] = this.imageHistogram[i][31];
            this.lumColHistogram[i] = this.lumImageHistogram[i][31];
            if (i > 0) {
                int n4 = i;
                this.colHistogram[n4] = this.colHistogram[n4] + this.colHistogram[i - 1];
                int n5 = i;
                this.lumColHistogram[n5] = this.lumColHistogram[n5] + this.lumColHistogram[i - 1];
            }
            n = 0;
            while (n < 32) {
                double[] dArray = this.imageHistogram[i];
                int n6 = n;
                dArray[n6] = dArray[n6] / this.imageHistogram[i][31];
                double[] dArray3 = this.lumImageHistogram[i];
                int n7 = n++;
                dArray3[n7] = dArray3[n7] / this.lumImageHistogram[i][31];
            }
        }
        this.jacobian = 0.019276571095877652;
        this.irradiance.scale(6.8052184E-5f, (Tuple3f)this.sunColor);
        double d11 = this.irradiance.integrate();
        this.irradiance.scaleAdd((float)this.jacobian, (Tuple3f)color3f2, (Tuple3f)this.irradiance);
        this.invIrradiance.x = 1.0f / this.irradiance.x;
        this.invIrradiance.y = 1.0f / this.irradiance.y;
        this.invIrradiance.z = 1.0f / this.irradiance.z;
        this.sunFraction = (float)(d11 / this.irradiance.integrate());
        int n = 0;
        while (n < 32) {
            int n8 = n;
            this.colHistogram[n8] = this.colHistogram[n8] / this.colHistogram[31];
            int n9 = n++;
            this.lumColHistogram[n9] = this.lumColHistogram[n9] / this.lumColHistogram[31];
        }
    }

    private boolean getSkyRGB(Vector3d vector3d, Tuple3f tuple3f) {
        if (vector3d.z < 0.0) {
            tuple3f.set(0.0f, 0.0f, 0.0f);
            return false;
        }
        if (vector3d.z < (double)0.001f) {
            vector3d.z = 0.001f;
        }
        vector3d.normalize();
        double d = MathUtils.clamp((double)vector3d.z, (double)-1.0, (double)1.0);
        double d2 = MathUtils.clamp((double)vector3d.dot(this.sunDir), (double)-1.0, (double)1.0);
        double d3 = Math.acos(d2);
        double d4 = this.perezFunction(this.perezx, d, d3, d2, this.zenithx);
        double d5 = this.perezFunction(this.perezy, d, d3, d2, this.zenithy);
        double d6 = this.perezFunction(this.perezY, d, d3, d2, this.zenithY);
        ChromaticitySpectrum.get((float)((float)d4), (float)((float)d5), (Tuple3f)tuple3f);
        tuple3f.scale((float)d6 / (tuple3f.y * 683.002f));
        RGBSpace.SRGB.convertXYZtoRGB(tuple3f, tuple3f);
        return d2 >= 0.9999891691584076;
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        double[][] dArray;
        double[] dArray2;
        this.update();
        if (environment.type == 2) {
            dArray2 = this.colHistogram;
            dArray = this.imageHistogram;
        } else {
            dArray2 = this.lumColHistogram;
            dArray = this.lumImageHistogram;
        }
        Vector3d vector3d = environment.tmpVector0;
        Vector3f vector3f2 = environment.userVector;
        Matrix3d matrix3d = environment.tmpMatrix30;
        float f = (float)rayList.size() * this.sunFraction;
        int n = (int)f;
        if (random.nextFloat() < f - (float)n) {
            ++n;
        }
        int n2 = 0;
        for (int i = 0; i < rayList.size(); ++i) {
            char c;
            int n3;
            Ray ray = rayList.rays[i];
            if ((n2 += n) >= rayList.size()) {
                n2 -= rayList.size();
                n3 = random.nextInt();
                float f2 = 8.263276E-11f * (float)(2 * (n3 >>> 16) + 1) + 0.99998915f;
                float f3 = (float)Math.sqrt(1.0f - f2 * f2);
                c = (char)n3;
                vector3d.set((double)(Math2.ccos((char)c) * f3), (double)(Math2.csin((char)c) * f3), (double)(-f2));
                this.sunBasis.transform((Tuple3d)vector3d);
                ray.direction.set((Tuple3d)vector3d);
                ray.spectrum.set(spectrum);
                ray.spectrum.mul((Tuple3f)this.sunColor);
                ray.spectrum.mul((Tuple3f)this.invIrradiance);
                ray.spectrum.scale(6.80521847575598E-5 / (double)this.sunFraction);
                ray.directionDensity = (float)((double)this.sunFraction / 6.80521847575598E-5);
            } else {
                int n4;
                int n5;
                double d = random.nextDouble();
                double d2 = random.nextDouble();
                for (n5 = 0; d >= dArray2[n5] && n5 < dArray2.length - 1; ++n5) {
                }
                double[] dArray3 = dArray[n5];
                for (n4 = 0; d2 >= dArray3[n4] && n4 < dArray3.length - 1; ++n4) {
                }
                double d3 = n5 == 0 ? d / dArray2[0] : (d - dArray2[n5 - 1]) / (dArray2[n5] - dArray2[n5 - 1]);
                double d4 = n4 == 0 ? d2 / dArray3[0] : (d2 - dArray3[n4 - 1]) / (dArray3[n4] - dArray3[n4 - 1]);
                double d5 = n5 == 0 ? dArray2[0] : dArray2[n5] - dArray2[n5 - 1];
                double d6 = n4 == 0 ? dArray3[0] : dArray3[n4] - dArray3[n4 - 1];
                double d7 = ((double)n5 + d3) / (double)dArray2.length;
                double d8 = ((double)n4 + d4) / (double)dArray3.length;
                double d9 = this.getDirection(d7, d8, vector3d);
                this.getSkyRGB(vector3d, (Tuple3f)vector3f2);
                ray.directionDensity = (1.0f - this.sunFraction) * (float)(d5 * d6 / (d9 * this.jacobian));
                Math2.mul((Tuple3f)vector3f2, (Tuple3f)vector3f2, (Tuple3f)this.invIrradiance);
                vector3f2.scale(1.0f / ray.directionDensity);
                ray.spectrum.set(spectrum);
                ray.spectrum.mul((Tuple3f)vector3f2);
                ray.direction.set((Tuple3d)vector3d);
                ray.direction.negate();
            }
            vector3d.set((Tuple3f)ray.direction);
            Math2.getOrthogonalBasis((Tuple3d)vector3d, (Matrix3d)matrix3d, (boolean)true);
            n3 = random.nextInt();
            double d = Math.sqrt((double)(n3 >>> 16) * 1.52587890625E-5) * environment.boundsRadius;
            c = (char)n3;
            vector3d.x = (double)Math2.ccos((char)c) * d;
            vector3d.y = (double)Math2.csin((char)c) * d;
            vector3d.z = -environment.boundsRadius;
            matrix3d.transform((Tuple3d)vector3d);
            vector3d.add((Tuple3d)environment.boundsCenter);
            ray.origin.set((Tuple3d)vector3d);
        }
    }

    private static void constrainRGB(Tuple3f tuple3f) {
        float f = -MathUtils.min((float)tuple3f.x, (float)tuple3f.y, (float)tuple3f.z);
        if (f > 0.0f) {
            tuple3f.x += f;
            tuple3f.y += f;
            tuple3f.z += f;
        }
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        this.update();
        Vector3d vector3d = environment.tmpVector0;
        vector3d.set((Tuple3f)environment.localPoint);
        Vector3f vector3f3 = environment.userVector;
        if (this.getSkyRGB(vector3d, (Tuple3f)vector3f3) && !this.disableSun) {
            vector3f3.add((Tuple3f)this.sunColor);
        }
        Math2.mul((Tuple3f)vector3f3, (Tuple3f)vector3f3, (Tuple3f)this.invIrradiance);
        SunSkyLight.constrainRGB((Tuple3f)vector3f3);
        spectrum2.set(spectrum);
        spectrum2.mul((Tuple3f)vector3f3);
        return 0.0f;
    }

    public double completeRay(Environment environment, Point3d point3d, Ray ray) {
        throw new UnsupportedOperationException();
    }

    private double getDirection(double d, double d2, Vector3d vector3d) {
        double d3 = 0.0;
        double d4 = 0.0;
        d4 = d * 2.0 * Math.PI;
        d3 = d2 * Math.PI;
        double d5 = Math.sin(d3);
        vector3d.x = -d5 * Math.cos(d4);
        vector3d.y = Math.cos(d3);
        vector3d.z = d5 * Math.sin(d4);
        return d5;
    }

    public int getAverageColor() {
        return -8355585;
    }

    public int getFlags() {
        return 66;
    }

    public void computeMaxRays(Environment environment, Vector3f vector3f, Spectrum spectrum, Ray ray, Tuple3f tuple3f, Ray ray2, Tuple3f tuple3f2) {
        throw new UnsupportedOperationException();
    }

    public boolean isTransparent() {
        return false;
    }

    public void shade(Environment environment, RayList rayList, Vector3f vector3f, Spectrum spectrum, Tuple3d tuple3d) {
        this.update();
        Vector3d vector3d = environment.tmpVector0;
        vector3d.set((Tuple3f)environment.localPoint);
        Vector3f vector3f2 = environment.userVector;
        this.getSkyRGB(vector3d, (Tuple3f)vector3f2);
        vector3f2.scale(10.0f / (float)this.irradiance.integrate());
        float f = -MathUtils.min((float)vector3f2.x, (float)vector3f2.y, (float)vector3f2.z);
        if (f > 0.0f) {
            vector3f2.x += f;
            vector3f2.y += f;
            vector3f2.z += f;
        }
        environment.tmpSpectrum0.set((Tuple3f)vector3f2);
        environment.tmpSpectrum0.dot(spectrum, tuple3d);
    }

    public int getLightType() {
        return 4;
    }

    public double getTotalPower(Environment environment) {
        if (this.disableLight) {
            return 0.0;
        }
        this.update();
        return environment.boundsRadius * environment.boundsRadius * Math.PI * this.irradiance.integrate() * (double)this.radianceFactor;
    }

    public boolean isShadowless() {
        return false;
    }

    public boolean isIgnoredWhenHit() {
        return false;
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        this.update();
        spectrum.set((Tuple3f)this.irradiance);
        spectrum.scale((double)this.radianceFactor);
        return 1.0 / (environment.boundsRadius * environment.boundsRadius * Math.PI);
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        this.update();
        double d = environment.boundsRadius * environment.boundsRadius * Math.PI;
        double d2 = 1.0 / d;
        for (int i = 0; i < rayList.getSize(); ++i) {
            Ray ray = rayList.rays[i];
            if (i == 0) {
                ray.spectrum.set((Tuple3f)this.irradiance);
                ray.spectrum.scale((double)this.radianceFactor * d);
            } else {
                ray.spectrum.set(rayList.rays[0].spectrum);
            }
            ray.originDensity = (float)d2;
        }
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new SunSkyLight();
    }

    public boolean isDisableLight() {
        return this.disableLight;
    }

    public void setDisableLight(boolean bl) {
        this.disableLight = bl;
    }

    public boolean isDisableSun() {
        return this.disableSun;
    }

    public void setDisableSun(boolean bl) {
        this.disableSun = bl;
    }

    public float getTurbidity() {
        return this.turbidity;
    }

    public void setTurbidity(float f) {
        this.turbidity = f;
    }

    public float getRadianceFactor() {
        return this.radianceFactor;
    }

    public void setRadianceFactor(float f) {
        this.radianceFactor = f;
    }

    public Vector3d getSun() {
        return this.sun;
    }

    public void setSun(Vector3d vector3d) {
        sun$FIELD.setObject((Object)this, (Object)vector3d);
    }

    public void accept(ShaderVisitor shaderVisitor) {
        shaderVisitor.visit(this);
    }

    public void accept(ChannelMapNodeVisitor channelMapNodeVisitor) {
        channelMapNodeVisitor.visit(this);
    }

    public void accept(LightVisitor lightVisitor) {
        lightVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)sun$FIELD);
        turbidity$FIELD = new _Field("turbidity", 0x200000, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)turbidity$FIELD);
        radianceFactor$FIELD = new _Field("radianceFactor", 0x200000, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)radianceFactor$FIELD);
        disableLight$FIELD = new _Field("disableLight", 0x200000, Type.BOOLEAN, null, 3);
        $TYPE.addManagedField((ManageableType.Field)disableLight$FIELD);
        disableSun$FIELD = new _Field("disableSun", 0x200000, Type.BOOLEAN, null, 4);
        $TYPE.addManagedField((ManageableType.Field)disableSun$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 3: {
                    ((SunSkyLight)object).disableLight = bl;
                    return;
                }
                case 4: {
                    ((SunSkyLight)object).disableSun = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 3: {
                    return ((SunSkyLight)object).isDisableLight();
                }
                case 4: {
                    return ((SunSkyLight)object).isDisableSun();
                }
            }
            return super.getBoolean(object);
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 1: {
                    ((SunSkyLight)object).turbidity = f;
                    return;
                }
                case 2: {
                    ((SunSkyLight)object).radianceFactor = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 1: {
                    return ((SunSkyLight)object).getTurbidity();
                }
                case 2: {
                    return ((SunSkyLight)object).getRadianceFactor();
                }
            }
            return super.getFloat(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((SunSkyLight)object).sun.set((Tuple3d)((Vector3d)object2));
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((SunSkyLight)object).getSun();
                }
            }
            return super.getObject(object);
        }
    }
}

