/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.ray.GroIMPRaytracer;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.ray.Tree;
import de.grogra.util.Map;
import java.awt.image.ImageObserver;
import java.util.Stack;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;

public class Renderer
extends de.grogra.imp.Renderer {
    private Tree tree;
    private Thread thread;
    private Map params;
    private SetTransformVisitor m_setTransformVisitor = new SetTransformVisitor();

    public Renderer(Map map) {
        this.params = map;
    }

    public String getName() {
        return "Raytracer";
    }

    protected void initializeImpl() {
        this.tree = new Tree((View3D)this.view);
    }

    public void render() {
        Camera camera = ((View3D)this.view).getCamera();
        SceneTree.Node node = this.tree.createTree(true);
        node.accept(this.m_setTransformVisitor);
        this.thread = new Thread((Runnable)new GroIMPRaytracer(this.view.getWorkbench(), this.params, this.tree, this.width, this.height, (ImageObserver)((Object)this), camera), this.getName());
        this.thread.setPriority(1);
        this.thread.start();
    }

    public synchronized void dispose() {
        if (this.thread != null) {
            Thread thread = this.thread;
            this.thread = null;
            thread.interrupt();
        }
    }

    private class SetTransformVisitor
    implements SceneTree.Visitor {
        private Stack m_transformationStack = new Stack();

        private SetTransformVisitor() {
        }

        public void visitEnter(SceneTree.InnerNode innerNode) {
            if (!this.m_transformationStack.isEmpty()) {
                Matrix4d matrix4d = (Matrix4d)this.m_transformationStack.peek();
                Matrix4d matrix4d2 = new Matrix4d();
                innerNode.transform(matrix4d, matrix4d2);
                matrix4d2.m30 = 0.0;
                matrix4d2.m31 = 0.0;
                matrix4d2.m32 = 0.0;
                matrix4d2.m33 = 1.0;
                this.m_transformationStack.push(matrix4d2);
            } else {
                Matrix4d matrix4d = new Matrix4d();
                innerNode.get(matrix4d);
                this.m_transformationStack.push(matrix4d);
            }
        }

        public void visitLeave(SceneTree.InnerNode innerNode) {
            this.m_transformationStack.pop();
        }

        public void visit(SceneTree.Leaf leaf) {
            if (!(leaf instanceof RaytracerLeaf)) {
                return;
            }
            RaytracerLeaf raytracerLeaf = (RaytracerLeaf)leaf;
            Matrix4d matrix4d = (Matrix4d)this.m_transformationStack.peek();
            raytracerLeaf.setTransformation(new Matrix4f(matrix4d));
        }
    }
}

