/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.shading.Shader;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray.shader.RTShader;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.goui.util.MTRandom;

class GroIMPShader
implements RTShader {
    static final Spectrum3f ID = new Spectrum3f(1.0f, 1.0f, 1.0f);
    private Shader m_shader;
    private final ShadingEnvironment m_shaderIn = new ShadingEnvironment();
    private final RayList m_rayList = new RayList();
    private final Vector3f m_out = new Vector3f();
    private final Color3f m_color_3 = new Color3f();
    private final RayList m_randomRayList = new RayList(1);
    private static int m_seed = 2001;
    private final Spectrum3f spectrum = new Spectrum3f();
    private final Tuple3d tmpColor = new Point3d();
    private final MTRandom rnd = new MTRandom();

    public GroIMPShader() {
    }

    public GroIMPShader(Shader shader) {
        this.setShader(shader);
    }

    public void setShader(Shader shader) {
        this.m_shader = shader;
    }

    public void getShadingColor(ShadingEnvironment shadingEnvironment, Color3f color3f) {
        this.m_shader.shade((Environment)shadingEnvironment, shadingEnvironment.rays, shadingEnvironment.view, (Spectrum)ID, this.tmpColor);
        color3f.set(this.tmpColor);
        if (color3f.x != color3f.x || color3f.y != color3f.y || color3f.z != color3f.z) {
            System.err.println("GroIMPShader: Shader.shade() return invalid color - NaN ERROR");
        }
    }

    public void computeMaxRays(ShadingEnvironment shadingEnvironment, Ray ray, Vector3f vector3f, Ray ray2, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f(shadingEnvironment.view);
        vector3f3.normalize();
        this.m_shader.computeMaxRays((Environment)shadingEnvironment, vector3f3, (Spectrum)ID, ray, (Tuple3f)vector3f, ray2, (Tuple3f)vector3f2);
        ray.getOrigin().set((Tuple3f)shadingEnvironment.point);
        ray2.getOrigin().set((Tuple3f)shadingEnvironment.point);
    }

    public boolean isTransparent(RTShader.TransparencyInput transparencyInput) {
        this.m_shaderIn.localPoint.set((Tuple3f)transparencyInput.localPoint);
        this.m_shaderIn.point.set((Tuple3f)transparencyInput.point);
        this.m_shaderIn.normal.set(1.0f, 0.0f, 0.0f);
        this.m_shaderIn.solid = true;
        this.m_shaderIn.uv.set((Tuple2f)transparencyInput.uv);
        this.m_shaderIn.dpdu.set(0.0f, 1.0f, 0.0f);
        this.m_shaderIn.dpdv.set(0.0f, 0.0f, 1.0f);
        this.m_shaderIn.iorRatio = 1.0f;
        this.m_rayList.setSize(1);
        this.m_rayList.rays[0].color.set(1.0f, 1.0f, 1.0f);
        this.m_rayList.rays[0].direction.set(1.0f, 0.0f, 0.0f);
        this.m_out.set(-1.0f, 0.0f, 0.0f);
        this.m_shader.shade((Environment)this.m_shaderIn, this.m_rayList, this.m_out, (Spectrum)ID, this.tmpColor);
        this.m_color_3.set(this.tmpColor);
        return this.m_color_3.x == 1.0f && this.m_color_3.y == 1.0f && this.m_color_3.z == 1.0f;
    }

    public boolean isTransparent() {
        return this.m_shader.isTransparent();
    }

    public float computeBSDF(ShadingEnvironment shadingEnvironment, Vector3f vector3f, Vector3f vector3f2, boolean bl, Color3f color3f) {
        float f = this.m_shader.computeBSDF((Environment)shadingEnvironment, vector3f, (Spectrum)ID, vector3f2, bl, (Spectrum)this.spectrum);
        this.spectrum.get((Tuple3f)color3f);
        return f;
    }

    public void generateRandomRay(ShadingEnvironment shadingEnvironment, Ray ray) {
        this.m_randomRayList.rays[0] = ray;
        this.m_shader.generateRandomRays((Environment)shadingEnvironment, shadingEnvironment.view, (Spectrum)ID, this.m_randomRayList, !shadingEnvironment.photonDirection, (Random)this.rnd);
        m_seed = m_seed * 34747 + 27373;
        ray.getOrigin().set((Tuple3f)shadingEnvironment.point);
    }

    public void generateRandomRays(ShadingEnvironment shadingEnvironment, RayList rayList) {
        this.m_shader.generateRandomRays((Environment)shadingEnvironment, shadingEnvironment.view, (Spectrum)ID, rayList, !shadingEnvironment.photonDirection, (Random)this.rnd);
        for (int i = 0; i < rayList.size(); ++i) {
            rayList.rays[i].getOrigin().set((Tuple3f)shadingEnvironment.point);
        }
    }

    public void generateRandomRays(ShadingEnvironment shadingEnvironment, Vector3f vector3f, RayList rayList, boolean bl, int n) {
        this.m_shader.generateRandomRays((Environment)shadingEnvironment, vector3f, (Spectrum)ID, rayList, bl, (Random)this.rnd);
        for (int i = 0; i < rayList.getSize(); ++i) {
            rayList.rays[i].getOrigin().set((Tuple3f)shadingEnvironment.point);
        }
    }

    public int getShaderFlags() {
        return this.m_shader.getFlags();
    }

    public float getshadingColorByComputeBSDF(ShadingEnvironment shadingEnvironment, Vector3f vector3f, boolean bl, Color3f color3f) {
        float f = 1.0f;
        color3f.set(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < shadingEnvironment.rays.getSize(); ++i) {
            Color3f color3f2 = new Color3f();
            Vector3f vector3f2 = shadingEnvironment.rays.rays[i].direction;
            f *= this.computeBSDF(shadingEnvironment, vector3f2, vector3f, bl, color3f2);
            color3f.add((Tuple3f)color3f2);
        }
        return f;
    }
}

