/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.IMP3D;
import de.grogra.imp3d.ray.GroIMPCamera;
import de.grogra.imp3d.ray.GroIMPRTProgressListener;
import de.grogra.imp3d.ray.GroIMPSceneGraph;
import de.grogra.imp3d.ray.Tree;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.PhotonMapRaytracer;
import de.grogra.ray.RTCamera;
import de.grogra.ray.RTScene;
import de.grogra.ray.Raytracer;
import de.grogra.ray.event.RTProgressListener;
import de.grogra.reflect.Type;
import de.grogra.util.EnumerationType;
import de.grogra.util.Map;
import de.grogra.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class GroIMPRaytracer
implements Runnable {
    public static final Type ANTIALIASING_MODE = new EnumerationType("ray.antialiasing", IMP3D.I18N, 3);
    public static final Type INTERSECTION_MODE = new EnumerationType("ray.intersection", IMP3D.I18N, 2);
    public static final Type RAYTRACING_MODE = new EnumerationType("ray.raytracing", IMP3D.I18N, 5);
    public static final Type PRIORITY_MODE = new EnumerationType("ray.priority", IMP3D.I18N, 3);
    private GroIMPSceneGraph m_sceneGraph;
    private RTCamera m_camera;
    private GroIMPRTProgressListener m_progressNotifier;
    private Raytracer default_raytracer;
    private PhotonMapRaytracer photon_raytracer;
    private Raytracer m_raytracer;
    private BufferedImage m_image;
    private Map m_params;

    public GroIMPRaytracer(Workbench workbench, Map map, Tree tree, int n, int n2, ImageObserver imageObserver, Camera camera) {
        this.m_raytracer = this.default_raytracer;
        this.m_sceneGraph = new GroIMPSceneGraph(tree);
        this.m_params = map;
        this.m_camera = new GroIMPCamera(camera, (double)n * 1.0 / (double)n2);
        this.m_image = new BufferedImage(n, n2, 2);
        this.m_progressNotifier = new GroIMPRTProgressListener(workbench);
        this.m_progressNotifier.setImage(this.m_image, imageObserver);
    }

    public void run() {
        this.configurateRaytracer();
        this.m_progressNotifier.beginProgress();
        this.m_raytracer.renderScene((RTScene)this.m_sceneGraph, this.m_camera, this.m_image);
        this.m_progressNotifier.endProgress();
        this.m_raytracer.printStatistics();
    }

    private void configurateRaytracer() {
        switch (Utils.getInt((Map)this.m_params, (Object)"raytracing")) {
            case 0: {
                this.m_raytracer = new Raytracer();
                this.m_raytracer.setRaytracingPolicy(20);
                break;
            }
            case 1: {
                this.m_raytracer = new Raytracer();
                this.m_raytracer.setRaytracingPolicy(21);
                this.m_raytracer.setPathtracingPathCount(Utils.getInt((Map)this.m_params, (Object)"pathtracing/count"));
                break;
            }
            case 2: {
                this.m_raytracer = new Raytracer();
                this.m_raytracer.setRaytracingPolicy(23);
                break;
            }
            case 3: {
                this.m_raytracer = new Raytracer();
                this.m_raytracer.setRaytracingPolicy(22);
                break;
            }
            case 4: {
                this.photon_raytracer = new PhotonMapRaytracer();
                this.photon_raytracer.setPhotonCount(Utils.getInt((Map)this.m_params, (Object)"photon/count"));
                this.photon_raytracer.setRange(Utils.getInt((Map)this.m_params, (Object)"photon/range"));
                this.m_raytracer = this.photon_raytracer;
                this.m_raytracer.setRaytracingPolicy(24);
                break;
            }
            default: {
                this.m_raytracer = new Raytracer();
                this.m_raytracer.setRaytracingPolicy(20);
            }
        }
        this.m_raytracer.addProgressListener((RTProgressListener)this.m_progressNotifier);
        if (Utils.getBoolean((Map)this.m_params, (Object)"debug/debugRaytracer")) {
            this.m_raytracer.enableDebugPixel(Utils.getInt((Map)this.m_params, (Object)"debug/x"), Utils.getInt((Map)this.m_params, (Object)"debug/y"), Utils.getBoolean((Map)this.m_params, (Object)"debug/markPixel"));
        } else {
            this.m_raytracer.disableDebugPixel();
        }
        this.m_raytracer.setBrightnessScaleFactor(Utils.getFloat((Map)this.m_params, (Object)"brightness/scaleFactor"));
        switch (Utils.getInt((Map)this.m_params, (Object)"antialiasing")) {
            case 0: {
                this.m_raytracer.setAntialisingPolicy(0);
                break;
            }
            case 1: {
                this.m_raytracer.setAntialisingPolicy(2);
                break;
            }
            case 2: {
                this.m_raytracer.setAntialisingPolicy(1);
                break;
            }
            default: {
                this.m_raytracer.setAntialisingPolicy(0);
            }
        }
        switch (Utils.getInt((Map)this.m_params, (Object)"intersection")) {
            case 0: {
                this.m_raytracer.setIntersectionPolicy(40);
                break;
            }
            case 1: {
                this.m_raytracer.setIntersectionPolicy(41);
                break;
            }
            default: {
                this.m_raytracer.setIntersectionPolicy(41);
            }
        }
        this.m_raytracer.setRaytracingDepth(Utils.getInt((Map)this.m_params, (Object)"raytracing_depth"));
        switch (Utils.getInt((Map)this.m_params, (Object)"priority")) {
            case 0: {
                this.m_raytracer.setPriority(0);
                break;
            }
            case 1: {
                this.m_raytracer.setPriority(1);
                break;
            }
            case 2: {
                this.m_raytracer.setPriority(2);
                break;
            }
            default: {
                this.m_raytracer.setPriority(2);
            }
        }
    }
}

