/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.GraphState;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.ray.RTSpotLight;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.math.Pool;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class SpotLight
extends PointLight
implements Raytraceable {
    float innerAngle = 0.3926991f;
    float outerAngle = 0.5235988f;
    public static final Type $TYPE = new Type(SpotLight.class);
    public static final SCOType.Field innerAngle$FIELD = Type._addManagedField($TYPE, "innerAngle", 0x200000, de.grogra.reflect.Type.FLOAT, null, 5);
    public static final SCOType.Field outerAngle$FIELD = Type._addManagedField($TYPE, "outerAngle", 0x200000, de.grogra.reflect.Type.FLOAT, null, 6);
    private static final int N = 32;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public float getInnerAngle() {
        return this.innerAngle;
    }

    public void setInnerAngle(float f) {
        this.innerAngle = f;
    }

    public float getOuterAngle() {
        return this.outerAngle;
    }

    public void setOuterAngle(float f) {
        this.outerAngle = f;
    }

    protected void draw(Tuple3f tuple3f, RenderState renderState) {
        Pool pool = renderState.getPool();
        Point3f point3f = pool.q3f0;
        Point3f point3f2 = pool.q3f1;
        Point3f point3f3 = pool.q3f3;
        Vector3f vector3f = pool.w3f0;
        Vector3f vector3f2 = pool.w3f1;
        point3f3.set(0.0f, 0.0f, 0.0f);
        float f = this.getAttenuationDistance();
        float f2 = f * (float)Math.cos(this.innerAngle);
        float f3 = f * (float)Math.cos(this.outerAngle);
        float f4 = (float)Math.sin(this.innerAngle) * f;
        float f5 = (float)Math.sin(this.outerAngle) * f;
        for (int i = 0; i <= 32; ++i) {
            float f6 = (float)i * 0.19634955f;
            float f7 = (float)Math.sin(f6);
            float f8 = (float)Math.cos(f6);
            point3f.set(f4 * f8, f4 * f7, f2);
            point3f2.set(f5 * f8, f5 * f7, f3);
            if (i > 0) {
                renderState.drawLine((Tuple3f)point3f, (Tuple3f)vector3f, tuple3f, -1, null);
                renderState.drawLine((Tuple3f)point3f2, (Tuple3f)vector3f2, tuple3f, -1, null);
            }
            if (i < 32 && (i & 7) == 0) {
                renderState.drawLine((Tuple3f)point3f2, (Tuple3f)point3f3, tuple3f, -1, null);
                renderState.drawLine((Tuple3f)point3f2, (Tuple3f)point3f, tuple3f, -1, null);
            }
            Point3f point3f4 = point3f;
            point3f = vector3f;
            vector3f = point3f4;
            point3f4 = point3f2;
            point3f2 = vector3f2;
            vector3f2 = point3f4;
        }
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        float f = (float)Math.cos(this.outerAngle);
        float f2 = (float)Math.cos(this.innerAngle);
        double d = 1.0 - 0.5 * (double)(f2 + f);
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            float f3;
            Ray ray = rayList.rays[i];
            int n = random.nextInt();
            double d2 = d / 65536.0 * (double)((n >>> 16) + 1);
            if (2.0 * d2 > (double)(f2 - f)) {
                f3 = (float)(d2 + 0.5 * (double)(f2 + f));
                ray.directionDensity = 1.0f / (float)((double)Math2.M_2PI * d);
            } else {
                double d3 = Math.pow((d2 *= (double)(2.0f / (f2 - f))) > 0.3 ? d2 : 0.5 * d2, 0.3333333333333333);
                while (true) {
                    double d4;
                    double d5;
                    if (-1.0E-8 < (d5 = d2 - (d4 = d3 * d3) * (2.0 * d3 - d4)) && d5 < 1.0E-8) {
                        f3 = (float)((double)(f2 - f) * d3 + (double)f);
                        ray.directionDensity = (float)((3.0 - 2.0 * d3) * d4 / (Math.PI * 2 * d));
                        break;
                    }
                    d3 += d5 / (6.0 * d4 - 4.0 * d3 * d4);
                }
            }
            float f4 = (float)Math.sqrt(1.0f - f3 * f3);
            char c = (char)n;
            ray.direction.set(Math2.ccos((char)c) * f4, Math2.csin((char)c) * f4, f3);
            environment.localToGlobal.transform(ray.direction);
            ray.direction.normalize();
            ray.spectrum.set(spectrum);
        }
    }

    protected float getDensityAt(Vector3f vector3f) {
        float f = vector3f.z;
        float f2 = (float)Math.cos(this.outerAngle);
        if (f <= f2) {
            return 0.0f;
        }
        float f3 = (float)Math.cos(this.innerAngle);
        float f4 = Math2.M_2PI * (1.0f - 0.5f * (f3 + f2));
        if (f >= f3) {
            return 1.0f / f4;
        }
        f = (f - f2) / (f3 - f2);
        return (3.0f - 2.0f * f) * f * f / f4;
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        Light light = (Light)graphState.getObjectDefault(object, bl, Attributes.LIGHT, null);
        if (light == null) {
            System.err.println("PointLight::createRaytracerLeaf - light is null");
        }
        if (light.getLightType() != 1) {
            System.err.println("PointLight::createRaytracerLeaf - unexpected light type");
        }
        return new RTSpotLight(object, bl, l, light);
    }

    public void accept(LightVisitor lightVisitor) {
        lightVisitor.visit(this);
    }

    static {
        innerAngle$FIELD.setQuantity(Quantity.ANGLE);
        outerAngle$FIELD.setQuantity(Quantity.ANGLE);
        $TYPE.validate();
    }

    public static class Type
    extends PointLight.Type {
        private static final int SUPER_FIELD_COUNT = 5;
        protected static final int FIELD_COUNT = 7;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SpotLight spotLight, SCOType sCOType) {
            super(spotLight, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)PointLight.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 5: {
                    ((SpotLight)object).innerAngle = f;
                    return;
                }
                case 6: {
                    ((SpotLight)object).outerAngle = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 5: {
                    return ((SpotLight)object).getInnerAngle();
                }
                case 6: {
                    return ((SpotLight)object).getOuterAngle();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new SpotLight();
        }
    }
}

