/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.imp3d.objects.HeightFieldMapping;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.util.Quantity;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;

public class SphericalHeightFieldMapping
extends HeightFieldMapping {
    float longitude;
    float latitude = -1.5707964f;
    float longWidth = (float)Math.PI * 2;
    float latWidth = (float)Math.PI;
    double radius = 1.0;
    boolean horizontal;
    public static final Type $TYPE = new Type(SphericalHeightFieldMapping.class);
    public static final SCOType.Field longitude$FIELD = Type._addManagedField($TYPE, "longitude", 0x200000, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field latitude$FIELD = Type._addManagedField($TYPE, "latitude", 0x200000, de.grogra.reflect.Type.FLOAT, null, 4);
    public static final SCOType.Field longWidth$FIELD = Type._addManagedField($TYPE, "longWidth", 0x200000, de.grogra.reflect.Type.FLOAT, null, 5);
    public static final SCOType.Field latWidth$FIELD = Type._addManagedField($TYPE, "latWidth", 0x200000, de.grogra.reflect.Type.FLOAT, null, 6);
    public static final SCOType.Field radius$FIELD = Type._addManagedField($TYPE, "radius", 0x200000, de.grogra.reflect.Type.DOUBLE, null, 7);
    public static final SCOType.Field horizontal$FIELD = Type._addManagedField($TYPE, "horizontal", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 8);
    private transient boolean valid = false;
    private transient int csx;
    private transient int csy;
    private final transient Matrix4d transform = new Matrix4d();
    private transient double[] cost;
    private transient double[] sint;
    private transient double[] cosp;
    private transient double[] sinp;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongWidth() {
        return this.longWidth;
    }

    public float getLatWidth() {
        return this.latWidth;
    }

    public double getRadius() {
        return this.radius;
    }

    public synchronized void map(int n, int n2, int n3, int n4, float f, Tuple3f tuple3f) {
        double d;
        double d2;
        double d3;
        double d4;
        float f2 = this.longWidth / (float)(n3 - 1);
        float f3 = this.latWidth / (float)(n4 - 1);
        Matrix4d matrix4d = this.transform;
        if (!this.valid || this.csx != n3 || this.csy != n4) {
            int n5;
            this.valid = true;
            this.csx = n3;
            this.csy = n4;
            d4 = 1.5707963267948966 - (double)(this.latitude + (float)(n4 - 1) * f3 / 2.0f);
            d3 = Math.cos(d4);
            d2 = Math.sin(d4);
            d4 = this.longitude + (float)(n3 - 1) * f2 / 2.0f;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            d = this.radius;
            matrix4d.setIdentity();
            if (this.horizontal) {
                matrix4d.m00 = d5 * d3;
                matrix4d.m10 = -d6;
                matrix4d.m20 = d5 * d2;
                matrix4d.m01 = d6 * d3;
                matrix4d.m11 = d5;
                matrix4d.m21 = d6 * d2;
                matrix4d.m02 = -d2;
                matrix4d.m22 = d3;
                matrix4d.m23 = -d;
            } else {
                matrix4d.m03 = -d * d2 * d5;
                matrix4d.m13 = -d * d2 * d6;
                matrix4d.m23 = -d * d3;
            }
            this.cost = new double[n4];
            this.sint = new double[n4];
            for (n5 = 0; n5 < n4; ++n5) {
                d4 = 1.5707963267948966 - (double)(this.latitude + (float)n5 * f3);
                this.cost[n5] = Math.cos(d4);
                this.sint[n5] = Math.sin(d4);
            }
            this.cosp = new double[n3];
            this.sinp = new double[n3];
            for (n5 = 0; n5 < n3; ++n5) {
                d4 = this.longitude + (float)n5 * f2;
                this.cosp[n5] = Math.cos(d4);
                this.sinp[n5] = Math.sin(d4);
            }
        }
        d = this.water && f <= this.zeroLevel ? this.radius : this.radius + (double)f - (double)this.zeroLevel;
        d4 = d * this.sint[n2] * this.cosp[n];
        d3 = d * this.sint[n2] * this.sinp[n];
        d2 = d * this.cost[n2];
        tuple3f.x = this.scale * (float)(matrix4d.m00 * d4 + matrix4d.m01 * d3 + matrix4d.m02 * d2 + matrix4d.m03);
        tuple3f.y = this.scale * (float)(matrix4d.m10 * d4 + matrix4d.m11 * d3 + matrix4d.m12 * d2 + matrix4d.m13);
        tuple3f.z = this.scale * (float)(matrix4d.m20 * d4 + matrix4d.m21 * d3 + matrix4d.m22 * d2 + matrix4d.m23);
    }

    public synchronized void setLongitude(float f) {
        this.valid = false;
        this.longitude = f;
    }

    public synchronized void setLatitude(float f) {
        this.valid = false;
        this.latitude = f;
    }

    public synchronized void setLongWidth(float f) {
        this.valid = false;
        this.longWidth = f;
    }

    public synchronized void setLatWidth(float f) {
        this.valid = false;
        this.latWidth = f;
    }

    public synchronized void setRadius(double d) {
        this.valid = false;
        this.radius = d;
    }

    public synchronized void setHorizontal(boolean bl) {
        this.valid = false;
        this.horizontal = bl;
    }

    static {
        longitude$FIELD.setQuantity(Quantity.ANGLE);
        latitude$FIELD.setQuantity(Quantity.ANGLE);
        longWidth$FIELD.setQuantity(Quantity.ANGLE);
        latWidth$FIELD.setQuantity(Quantity.ANGLE);
        $TYPE.validate();
    }

    public static class Type
    extends HeightFieldMapping.Type {
        private static final int SUPER_FIELD_COUNT = 3;
        protected static final int FIELD_COUNT = 9;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SphericalHeightFieldMapping sphericalHeightFieldMapping, SCOType sCOType) {
            super(sphericalHeightFieldMapping, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)HeightFieldMapping.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 8: {
                    ((SphericalHeightFieldMapping)((Object)object)).setHorizontal(bl);
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 8: {
                    return ((SphericalHeightFieldMapping)((Object)object)).isHorizontal();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 3: {
                    ((SphericalHeightFieldMapping)((Object)object)).setLongitude(f);
                    return;
                }
                case 4: {
                    ((SphericalHeightFieldMapping)((Object)object)).setLatitude(f);
                    return;
                }
                case 5: {
                    ((SphericalHeightFieldMapping)((Object)object)).setLongWidth(f);
                    return;
                }
                case 6: {
                    ((SphericalHeightFieldMapping)((Object)object)).setLatWidth(f);
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((SphericalHeightFieldMapping)((Object)object)).getLongitude();
                }
                case 4: {
                    return ((SphericalHeightFieldMapping)((Object)object)).getLatitude();
                }
                case 5: {
                    return ((SphericalHeightFieldMapping)((Object)object)).getLongWidth();
                }
                case 6: {
                    return ((SphericalHeightFieldMapping)((Object)object)).getLatWidth();
                }
            }
            return super.getFloat(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 7: {
                    ((SphericalHeightFieldMapping)((Object)object)).setRadius(d);
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 7: {
                    return ((SphericalHeightFieldMapping)((Object)object)).getRadius();
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new SphericalHeightFieldMapping();
        }
    }
}

