/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.EdgePattern;
import de.grogra.graph.GraphState;
import de.grogra.graph.Path;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.shading.AlgorithmSwitchShader;
import de.grogra.imp3d.shading.Interior;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.ShaderRef;
import de.grogra.xl.util.ObjectList;

public abstract class SceneTreeWithShader
extends SceneTree {
    private ObjectList shaderStack = new ObjectList().push((Object)RGBAShader.GRAY);
    private ObjectList interiorStack = new ObjectList().push(null);

    public SceneTreeWithShader(GraphState graphState, EdgePattern edgePattern) {
        super(graphState, edgePattern);
    }

    public SceneTreeWithShader(View3D view3D) {
        super(view3D);
    }

    protected void init(SceneTree.Leaf leaf) {
        super.init(leaf);
        ((Leaf)leaf).shader = this.getCurrentShader();
        ((Leaf)leaf).interior = this.getCurrentInterior();
    }

    protected Shader getCurrentShader() {
        return (Shader)this.shaderStack.peek(1);
    }

    protected Interior getCurrentInterior() {
        return (Interior)this.interiorStack.peek(1);
    }

    protected Shader resolveShader(Shader shader) {
        return shader instanceof AlgorithmSwitchShader ? ((AlgorithmSwitchShader)shader).getRaytracerShader() : (shader instanceof ShaderRef ? ((ShaderRef)shader).resolve() : shader);
    }

    Object visitEnter(Object object, boolean bl, long l, Path path) {
        Shader shader;
        Shader shader2;
        Shader shader3 = (Shader)this.shaderStack.peek(1);
        Shader shader4 = shader2 = object == null ? null : (Shader)this.state.getObjectDefault(object, bl, Attributes.SHADER, (Object)shader3);
        while ((shader = this.resolveShader(shader2)) != shader2) {
            shader2 = shader;
        }
        this.shaderStack.push((Object)(shader2 != null ? shader2 : shader3));
        Interior interior = (Interior)this.interiorStack.peek(1);
        Interior interior2 = object == null ? null : (Interior)this.state.getObjectDefault(object, bl, Attributes.INTERIOR, (Object)interior);
        this.interiorStack.push((Object)(interior2 != null ? interior2 : interior));
        return super.visitEnter(object, bl, l, path);
    }

    public boolean visitLeave(Object object, Path path, boolean bl) {
        boolean bl2 = super.visitLeave(object, path, bl);
        if (bl) {
            this.shaderStack.pop();
            this.interiorStack.pop();
        }
        return bl2;
    }

    public static class Leaf
    extends SceneTree.Leaf {
        public Shader shader;
        public Interior interior;

        public Leaf(Object object, boolean bl, long l) {
            super(object, bl, l);
        }

        public void setShader(Shader shader) {
            this.shader = shader;
        }

        public void setInterior(Interior interior) {
            this.interior = interior;
        }
    }
}

