/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.AreaLight;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Axis;
import de.grogra.imp3d.ray.RTAreaLight;
import de.grogra.imp3d.ray.RTParallelogram;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.math.Tuple3fType;
import de.grogra.persistence.ManageableType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Parallelogram
extends Axis
implements Pickable,
Renderable,
Light,
Raytraceable {
    final Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    protected AreaLight light;
    public static final Node.NType $TYPE = new Node.NType((Node)new Parallelogram());
    public static final Node.NType.Field axis$FIELD = new _Field("axis", 0x200010, (Type)Tuple3fType.VECTOR, null, 0);
    public static final Node.NType.Field light$FIELD;

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.LIGHT));
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Parallelogram();
    }

    public Vector3f getAxis() {
        return this.axis;
    }

    public void setAxis(Vector3f vector3f) {
        axis$FIELD.setObject((Object)this, (Object)vector3f);
    }

    public AreaLight getLight() {
        return this.light;
    }

    public void setLight(AreaLight areaLight) {
        light$FIELD.setObject((Object)this, (Object)areaLight);
    }

    public Parallelogram() {
    }

    public Parallelogram(float f, float f2) {
        this.setLength(f);
        this.setAxis(f2 * 0.5f, 0.0f, 0.0f);
    }

    public void setAxis(float f, float f2, float f3) {
        this.axis.set(f, f2, f3);
    }

    public static void pick(float f, Vector3f vector3f, Point3d point3d, Vector3d vector3d, PickList pickList) {
        Matrix3f matrix3f = pickList.n3f0;
        matrix3f.setColumn(0, vector3f);
        matrix3f.setColumn(1, 0.0f, 0.0f, f);
        Vector3f vector3f2 = pickList.w3f0;
        vector3f2.set((Tuple3d)vector3d);
        matrix3f.setColumn(2, vector3f2);
        vector3f2.set((Tuple3d)point3d);
        try {
            matrix3f.invert();
            matrix3f.transform((Tuple3f)vector3f2);
            if (-1.0f <= vector3f2.x && vector3f2.x <= 1.0f && 0.0f <= vector3f2.y && vector3f2.y <= 1.0f && vector3f2.z < 0.0f) {
                pickList.add((double)(-vector3f2.z));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        GraphState graphState = pickList.getGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                Parallelogram.pick(this.length, this.axis, point3d, vector3d, pickList);
            } else {
                Parallelogram.pick((float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length), (Vector3f)graphState.checkObject((Object)this, true, Attributes.AXIS, (Object)this.axis), point3d, vector3d, pickList);
            }
        } else {
            Parallelogram.pick((float)graphState.getDouble(object, bl, Attributes.LENGTH), (Vector3f)graphState.getObject(object, bl, (Object)pickList.v3f1, Attributes.AXIS), point3d, vector3d, pickList);
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        GraphState graphState = renderState.getRenderGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                renderState.drawParallelogram(this.length, this.axis, 1.0f, this.isScaleV() ? this.length : 1.0f, null, -1, null);
            } else {
                float f = (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length);
                renderState.drawParallelogram((float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length), (Vector3f)graphState.checkObject((Object)this, true, Attributes.AXIS, (Object)this.axis), 1.0f, graphState.checkBoolean((Object)this, true, Attributes.SCALE_V, this.isScaleV()) ? f : 1.0f, null, -1, null);
            }
        } else {
            float f = (float)graphState.getDouble(object, bl, Attributes.LENGTH);
            renderState.drawParallelogram((float)graphState.getDouble(object, bl, Attributes.LENGTH), (Vector3f)graphState.getObject(object, bl, (Object)renderState.getPool().v3f1, Attributes.AXIS), 1.0f, graphState.getBoolean(object, bl, Attributes.SCALE_V) ? f : 1.0f, null, -1, null);
        }
    }

    protected Object getObject(ObjectAttribute objectAttribute, Object object, GraphState graphState) {
        if (objectAttribute == Attributes.LIGHT) {
            return this.light != null ? this : null;
        }
        return super.getObject(objectAttribute, object, graphState);
    }

    public int getLightType() {
        return 2;
    }

    public boolean isShadowless() {
        return this.light.isShadowless();
    }

    public boolean isIgnoredWhenHit() {
        return this.light.isIgnoredWhenHit();
    }

    public int getAverageColor() {
        return 0;
    }

    public int getFlags() {
        return 1;
    }

    public float getArea() {
        return 2.0f * this.axis.length() * this.length;
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        Vector3f vector3f = environment.userVector;
        Vector3f vector3f2 = environment.userVector2;
        Vector3f vector3f3 = environment.userVector3;
        vector3f.set(0.0f, 0.0f, this.length);
        environment.localToGlobal.transform(vector3f, vector3f);
        environment.localToGlobal.transform(this.axis, vector3f2);
        vector3f3.cross(vector3f, vector3f2);
        float f = 2.0f * vector3f3.length();
        Spectrum spectrum = rayList.rays[0].spectrum;
        this.light.computeExitance(this.getShader(), f, spectrum);
        spectrum.scale((double)f);
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            Point3f point3f = rayList.rays[i].origin;
            int n = random.nextInt();
            point3f.scale((float)(n >>> 16) * 1.5258789E-5f, (Tuple3f)vector3f);
            point3f.scaleAdd((float)((char)n) * 3.0517578E-5f - 1.0f, (Tuple3f)vector3f2, (Tuple3f)point3f);
            point3f.x += environment.localToGlobal.m03;
            point3f.y += environment.localToGlobal.m13;
            point3f.z += environment.localToGlobal.m23;
            rayList.rays[i].spectrum.set(spectrum);
            rayList.rays[i].originDensity = 1.0f / f;
        }
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        Vector3f vector3f = environment.userVector;
        Vector3f vector3f2 = environment.userVector2;
        Vector3f vector3f3 = environment.userVector3;
        vector3f.set(0.0f, 0.0f, this.length);
        environment.localToGlobal.transform(vector3f, vector3f);
        environment.localToGlobal.transform(this.axis, vector3f2);
        vector3f3.cross(vector3f, vector3f2);
        float f = 2.0f * vector3f3.length();
        this.light.computeExitance(this.getShader(), f, spectrum);
        return 1.0f / f;
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        Vector3f vector3f2 = environment.userVector;
        Vector3f vector3f3 = environment.userVector2;
        Vector3f vector3f4 = environment.userVector3;
        vector3f2.set(0.0f, 0.0f, this.length);
        environment.localToGlobal.transform(vector3f2, vector3f2);
        environment.localToGlobal.transform(this.axis, vector3f3);
        vector3f4.cross(vector3f2, vector3f3);
        Matrix3f matrix3f = environment.userMatrix;
        Math2.getOrthogonalBasis((Tuple3f)vector3f4, (Matrix3f)matrix3f, (boolean)true);
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            int n = random.nextInt();
            double d = 1.52587890625E-5 * (double)((n >>> 16) + 1);
            rayList.rays[i].directionDensity = (this.light.exponent + 2.0f) * (float)Math.pow(d, (this.light.exponent + 1.0f) / (this.light.exponent + 2.0f)) * 0.15915494f;
            float f = (float)Math.pow(d, 1.0f / (this.light.exponent + 2.0f));
            float f2 = (float)Math.sqrt(1.0f - f * f);
            char c = (char)n;
            vector3f4.set(Math2.ccos((char)c) * f2, Math2.csin((char)c) * f2, f);
            matrix3f.transform((Tuple3f)vector3f4, (Tuple3f)rayList.rays[i].direction);
            rayList.rays[i].spectrum.set(spectrum);
        }
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        Vector3f vector3f3 = environment.userVector;
        Vector3f vector3f4 = environment.userVector2;
        Vector3f vector3f5 = environment.userVector3;
        vector3f3.set(0.0f, 0.0f, this.length);
        environment.localToGlobal.transform(vector3f3, vector3f3);
        environment.localToGlobal.transform(this.axis, vector3f4);
        vector3f5.cross(vector3f3, vector3f4);
        float f = vector3f5.dot(vector3f2);
        if (f <= 0.0f) {
            spectrum2.setZero();
            return 0.0f;
        }
        f = (this.light.exponent + 2.0f) * (float)Math.pow(f / vector3f5.length(), this.light.exponent + 1.0f) * 0.15915494f;
        spectrum2.set(spectrum);
        spectrum2.scale((double)f);
        return f;
    }

    public double getTotalPower(Environment environment) {
        return this.light.power;
    }

    public double completeRay(Environment environment, Point3d point3d, Ray ray) {
        throw new UnsupportedOperationException();
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = null;
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                vector3f.z = this.length;
                vector3f2 = this.axis;
            } else {
                vector3f.z = (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length);
                vector3f2 = (Vector3f)graphState.checkObject((Object)this, true, Attributes.AXIS, (Object)this.axis);
            }
        } else {
            vector3f.z = (float)graphState.getDouble(object, bl, Attributes.LENGTH);
            vector3f2 = (Vector3f)graphState.getObject(object, bl, Attributes.AXIS);
        }
        if (this.light != null) {
            return new RTAreaLight(object, bl, l, this, vector3f, vector3f2);
        }
        return new RTParallelogram(object, bl, l, vector3f, vector3f2);
    }

    public void accept(LightVisitor lightVisitor) {
        lightVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)axis$FIELD);
        light$FIELD = new _Field("light", 0x200004, (Type)ClassAdapter.wrap(AreaLight.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)light$FIELD);
        $TYPE.declareFieldAttribute(axis$FIELD, (Attribute)Attributes.AXIS);
        $TYPE.declareFieldAttribute(light$FIELD, (Attribute)Attributes.AREA_LIGHT);
        Parallelogram.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((Parallelogram)object).axis.set((Tuple3f)((Vector3f)object2));
                    return;
                }
                case 1: {
                    ((Parallelogram)object).light = (AreaLight)((Object)object2);
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Parallelogram)object).getAxis();
                }
                case 1: {
                    return ((Parallelogram)object).getLight();
                }
            }
            return super.getObject(object);
        }
    }
}

