/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Point;
import de.grogra.math.RGBColor;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.util.ObjectList;
import javax.vecmath.Tuple3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GRSVertex
extends Point {
    protected ObjectList<GRSVertex> neighbors = new ObjectList(5);
    protected float u;
    protected float v;
    transient int meshIndex;
    public static final Node.NType $TYPE = new Node.NType((Node)new GRSVertex());
    public static final Node.NType.Field neighbors$FIELD = new _Field("neighbors", 0x400004, (Type)ClassAdapter.wrap(ObjectList.class), (Type)$TYPE, 0);
    public static final Node.NType.Field u$FIELD;
    public static final Node.NType.Field v$FIELD;

    public GRSVertex() {
        this(0.0, 0.0, 0.0);
    }

    public GRSVertex(Tuple3d tuple3d) {
        this(tuple3d.x, tuple3d.y, tuple3d.z);
    }

    public GRSVertex(double d, double d2, double d3) {
        this.setTransform(d, d2, d3);
        this.color = RGBColor.BLUE;
    }

    public int getNeighborIndex(GRSVertex gRSVertex) {
        return this.neighbors.indexOf((Object)gRSVertex);
    }

    public int valence() {
        return this.neighbors.size();
    }

    public GRSVertex neighbors(ObjectConsumer<? super GRSVertex> objectConsumer) {
        this.neighbors.evaluateObject(objectConsumer);
        return null;
    }

    public GRSVertex getNeighbor(int n) {
        return (GRSVertex)this.neighbors.get(n);
    }

    public GRSVertex nextTo(GRSVertex gRSVertex) {
        int n = this.neighbors.indexOf((Object)gRSVertex);
        if (n < 0) {
            return null;
        }
        return (GRSVertex)this.neighbors.get(n + 1 == this.neighbors.size ? 0 : n + 1);
    }

    public GRSVertex prevTo(GRSVertex gRSVertex) {
        int n = this.neighbors.indexOf((Object)gRSVertex);
        if (n < 0) {
            return null;
        }
        return (GRSVertex)this.neighbors.get(n == 0 ? this.neighbors.size - 1 : n - 1);
    }

    public GRSVertex nextTo(int n, GRSVertex gRSVertex) {
        int n2 = this.neighbors.indexOf((Object)gRSVertex);
        if (n2 < 0) {
            return null;
        }
        return (GRSVertex)this.neighbors.get((n2 + this.neighbors.size + n) % this.neighbors.size);
    }

    public GRSVertex prevTo(int n, GRSVertex gRSVertex) {
        int n2 = this.neighbors.indexOf((Object)gRSVertex);
        if (n2 < 0) {
            return null;
        }
        return (GRSVertex)this.neighbors.get((n2 + this.neighbors.size - n) % this.neighbors.size);
    }

    public GRSVertex first() {
        return this.neighbors.isEmpty() ? null : (GRSVertex)this.neighbors.get(0);
    }

    public GRSVertex next(GRSVertex gRSVertex) {
        return gRSVertex.nextTo(this);
    }

    public GRSVertex prev(GRSVertex gRSVertex) {
        return gRSVertex.prevTo(this);
    }

    public GRSVertex next(int n, GRSVertex gRSVertex) {
        return gRSVertex.nextTo(n, this);
    }

    public GRSVertex prev(int n, GRSVertex gRSVertex) {
        return gRSVertex.prevTo(n, this);
    }

    @Override
    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    @Override
    protected Node newInstance() {
        return new GRSVertex();
    }

    public float getU() {
        return this.u;
    }

    public void setU(float f) {
        this.u = f;
    }

    public float getV() {
        return this.v;
    }

    public void setV(float f) {
        this.v = f;
    }

    public ObjectList<GRSVertex> getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(ObjectList<GRSVertex> objectList) {
        neighbors$FIELD.setObject((Object)this, objectList);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)neighbors$FIELD);
        u$FIELD = new _Field("u", 0x200004, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)u$FIELD);
        v$FIELD = new _Field("v", 0x200004, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)v$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 1: {
                    ((GRSVertex)object).u = f;
                    return;
                }
                case 2: {
                    ((GRSVertex)object).v = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 1: {
                    return ((GRSVertex)object).getU();
                }
                case 2: {
                    return ((GRSVertex)object).getV();
                }
            }
            return super.getFloat(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((GRSVertex)object).neighbors = (ObjectList)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((GRSVertex)object).getNeighbors();
                }
            }
            return super.getObject(object);
        }
    }
}

