/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.Polygonization;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Axis;
import de.grogra.imp3d.objects.FrustumBase;
import de.grogra.imp3d.ray.RTFrustum;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Field;
import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.FieldListPattern;
import de.grogra.xl.query.UserDefinedPattern;
import de.grogra.xl.util.ByteList;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Frustum
extends FrustumBase
implements Raytraceable,
Polygonizable {
    protected float baseRadius;
    protected float topRadius;
    public static final Node.NType $TYPE = new Node.NType((Node)new Frustum());
    public static final Node.NType.Field baseRadius$FIELD = new _Field("baseRadius", 0x200004, Type.FLOAT, null, 0);
    public static final Node.NType.Field topRadius$FIELD;
    public static final Node.NType.Field baseOpen$FIELD;
    public static final Node.NType.Field topOpen$FIELD;

    public Frustum() {
        this(1.0f, 1.0f, 0.5f);
    }

    public Frustum(float f, float f2, float f3) {
        this.setLength(f);
        this.baseRadius = f2;
        this.topRadius = f3;
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        GraphState graphState = pickList.getGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                Frustum.pick(this.length, this.baseRadius, this.topRadius, (this.bits & 0x4000) == 0, (this.bits & 0x8000) == 0, point3d, vector3d, pickList);
            } else {
                Frustum.pick((float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length), graphState.checkFloat((Object)this, true, Attributes.BASE_RADIUS, this.baseRadius), graphState.checkFloat((Object)this, true, Attributes.TOP_RADIUS, this.topRadius), !graphState.checkBoolean((Object)this, true, Attributes.BASE_OPEN, (this.bits & 0x4000) != 0), !graphState.checkBoolean((Object)this, true, Attributes.TOP_OPEN, (this.bits & 0x8000) != 0), point3d, vector3d, pickList);
            }
        } else {
            Frustum.pick((float)graphState.getDouble(object, bl, Attributes.LENGTH), graphState.getFloat(object, bl, Attributes.BASE_RADIUS), graphState.getFloat(object, bl, Attributes.TOP_RADIUS), !graphState.getBoolean(object, bl, Attributes.BASE_OPEN), !graphState.getBoolean(object, bl, Attributes.TOP_OPEN), point3d, vector3d, pickList);
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        GraphState graphState = renderState.getRenderGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                renderState.drawFrustum(this.length, this.baseRadius, this.topRadius, (this.bits & 0x4000) == 0, (this.bits & 0x8000) == 0, this.isScaleV() ? this.length : 1.0f, null, -1, null);
            } else {
                float f = (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length);
                renderState.drawFrustum(f, graphState.checkFloat((Object)this, true, Attributes.BASE_RADIUS, this.baseRadius), graphState.checkFloat((Object)this, true, Attributes.TOP_RADIUS, this.topRadius), !graphState.checkBoolean((Object)this, true, Attributes.BASE_OPEN, (this.bits & 0x4000) != 0), !graphState.checkBoolean((Object)this, true, Attributes.TOP_OPEN, (this.bits & 0x8000) != 0), graphState.checkBoolean((Object)this, true, Attributes.SCALE_V, this.isScaleV()) ? f : 1.0f, null, -1, null);
            }
        } else {
            float f = (float)graphState.getDouble(object, bl, Attributes.LENGTH);
            renderState.drawFrustum(f, graphState.getFloat(object, bl, Attributes.BASE_RADIUS), graphState.getFloat(object, bl, Attributes.TOP_RADIUS), !graphState.getBoolean(object, bl, Attributes.BASE_OPEN), !graphState.getBoolean(object, bl, Attributes.TOP_OPEN), graphState.getBoolean(object, bl, Attributes.SCALE_V) ? f : 1.0f, null, -1, null);
        }
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        float f = 1.0f;
        float f2 = 1.0f;
        Vector3f vector3f = new Vector3f();
        boolean bl2 = false;
        boolean bl3 = false;
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                f2 = this.topRadius;
                f = this.baseRadius;
                vector3f.z = this.length;
                bl2 = this.isTopOpen();
                bl3 = this.isBaseOpen();
            } else {
                f2 = graphState.checkFloat((Object)this, true, Attributes.TOP_RADIUS, this.topRadius);
                f = graphState.checkFloat((Object)this, true, Attributes.BASE_RADIUS, this.baseRadius);
                vector3f.z = (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length);
                bl2 = graphState.checkBoolean((Object)this, true, Attributes.TOP_OPEN, this.isTopOpen());
                bl3 = graphState.checkBoolean((Object)this, true, Attributes.BASE_OPEN, this.isBaseOpen());
            }
        } else {
            f2 = graphState.getFloat(object, bl, Attributes.TOP_RADIUS);
            f = graphState.getFloat(object, bl, Attributes.BASE_RADIUS);
            vector3f.z = (float)graphState.getDouble(object, bl, Attributes.LENGTH);
            bl2 = graphState.getBoolean(object, bl, Attributes.TOP_OPEN);
            bl3 = graphState.getBoolean(object, bl, Attributes.BASE_OPEN);
        }
        return new RTFrustum(object, bl, l, f2, f, vector3f, bl2, bl3);
    }

    public ContextDependent getPolygonizableSource(GraphState graphState) {
        return null;
    }

    public Polygonization getPolygonization() {
        final class Poly
        implements Polygonization {
            final float baseRadius;
            final float topRadius;
            final int bits;

            Poly() {
                this.baseRadius = Frustum.this.baseRadius;
                this.topRadius = Frustum.this.topRadius;
                this.bits = Frustum.this.bits;
            }

            public void polygonize(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
                Frustum.this.polygonizeImpl(contextDependent, graphState, polygonArray, n, f);
            }

            public boolean equals(Object object) {
                if (!(object instanceof Poly)) {
                    return false;
                }
                Poly poly = (Poly)object;
                return poly.baseRadius == this.baseRadius && poly.topRadius == this.topRadius && poly.bits == this.bits;
            }

            public int hashCode() {
                return Float.floatToIntBits(this.baseRadius) ^ Float.floatToIntBits(this.topRadius) ^ this.bits;
            }
        }
        return new Poly();
    }

    void polygonizeImpl(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
        float f2;
        float f3;
        float f4;
        int n2;
        boolean bl;
        boolean bl2;
        float f5;
        float f6;
        float f7;
        if (graphState.getObjectContext().getObject() == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                f7 = this.baseRadius;
                f6 = this.topRadius;
                f5 = this.length;
                bl2 = (this.bits & 0x4000) == 0;
                bl = (this.bits & 0x8000) == 0;
            } else {
                f7 = graphState.checkFloat((Object)this, true, Attributes.BASE_RADIUS, this.baseRadius);
                f6 = graphState.checkFloat((Object)this, true, Attributes.TOP_RADIUS, this.topRadius);
                f5 = (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length);
                bl2 = !graphState.checkBoolean((Object)this, true, Attributes.BASE_OPEN, (this.bits & 0x4000) != 0);
                bl = !graphState.checkBoolean((Object)this, true, Attributes.TOP_OPEN, (this.bits & 0x8000) != 0);
            }
        } else {
            f7 = graphState.getFloatDefault(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.BASE_RADIUS, this.baseRadius);
            f6 = graphState.getFloatDefault(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.TOP_RADIUS, this.topRadius);
            f5 = (float)graphState.getDoubleDefault(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.LENGTH, (double)this.length);
            bl2 = !graphState.getBooleanDefault(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.BASE_OPEN, (this.bits & 0x4000) != 0);
            bl = !graphState.getBooleanDefault(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.TOP_OPEN, (this.bits & 0x8000) != 0);
        }
        polygonArray.closed = false;
        polygonArray.dimension = 3;
        polygonArray.edgeCount = 3;
        polygonArray.planar = true;
        int n3 = 30;
        IntList intList = new IntList();
        FloatList floatList = new FloatList();
        ByteList byteList = new ByteList();
        FloatList floatList2 = new FloatList();
        Vector3f vector3f = new Vector3f();
        for (n2 = 0; n2 <= n3; ++n2) {
            f4 = (float)(Math.PI * 2 * (double)n2 / (double)n3);
            f3 = (float)Math.cos(f4);
            f2 = (float)Math.sin(f4);
            floatList.add(f6 * f3);
            floatList.add(f6 * f2);
            floatList.add(f5);
            if (f5 > 0.0f) {
                vector3f.x = f3;
                vector3f.y = f2;
                vector3f.z = (f7 - f6) / f5;
                vector3f.normalize();
            } else {
                vector3f.x = 0.0f;
                vector3f.y = 0.0f;
                vector3f.z = f7 - f6 > 0.0f ? 1.0f : -1.0f;
            }
            byteList.add((byte)(vector3f.x * 127.0f));
            byteList.add((byte)(vector3f.y * 127.0f));
            byteList.add((byte)(vector3f.z * 127.0f));
            floatList2.add(f4 / ((float)Math.PI * 2));
            floatList2.add(1.0f);
            floatList.add(f7 * f3);
            floatList.add(f7 * f2);
            floatList.add(0.0f);
            byteList.add((byte)(vector3f.x * 127.0f));
            byteList.add((byte)(vector3f.y * 127.0f));
            byteList.add((byte)(vector3f.z * 127.0f));
            floatList2.add(f4 / ((float)Math.PI * 2));
            floatList2.add(0.0f);
            if (n2 >= n3) continue;
            intList.add(2 * n2);
            intList.add(2 * n2 + 1);
            intList.add(2 * n2 + 2);
            intList.add(2 * n2 + 1);
            intList.add(2 * n2 + 3);
            intList.add(2 * n2 + 2);
        }
        if (bl) {
            floatList.add(0.0f);
            floatList.add(0.0f);
            floatList.add(f5);
            byteList.add((byte)0);
            byteList.add((byte)0);
            byteList.add((byte)127);
            floatList2.add(0.5f);
            floatList2.add(0.5f);
            for (n2 = 0; n2 <= n3; ++n2) {
                f4 = (float)(Math.PI * 2 * (double)n2 / (double)n3);
                f3 = (float)Math.cos(f4);
                f2 = (float)Math.sin(f4);
                floatList.add(f6 * f3);
                floatList.add(f6 * f2);
                floatList.add(f5);
                byteList.add((byte)0);
                byteList.add((byte)0);
                byteList.add((byte)127);
                floatList2.add(f3 / 2.0f + 0.5f);
                floatList2.add(f2 / 2.0f + 0.5f);
                if (n2 >= n3) continue;
                intList.add(2 * (n3 + 1));
                intList.add(2 * (n3 + 1) + n2 + 1);
                intList.add(2 * (n3 + 1) + n2 + 2);
            }
        }
        if (bl2) {
            floatList.add(0.0f);
            floatList.add(0.0f);
            floatList.add(0.0f);
            byteList.add((byte)0);
            byteList.add((byte)0);
            byteList.add((byte)-127);
            floatList2.add(0.5f);
            floatList2.add(0.5f);
            for (n2 = 0; n2 <= n3; ++n2) {
                f4 = (float)(Math.PI * 2 * (double)n2 / (double)n3);
                f3 = (float)Math.cos(f4);
                f2 = (float)Math.sin(f4);
                floatList.add(f7 * f3);
                floatList.add(f7 * f2);
                floatList.add(0.0f);
                byteList.add((byte)0);
                byteList.add((byte)0);
                byteList.add((byte)-127);
                floatList2.add(f3 / 2.0f + 0.5f);
                floatList2.add(f2 / 2.0f + 0.5f);
                if (n2 >= n3) continue;
                intList.add(3 * (n3 + 1) + 1);
                intList.add(3 * (n3 + 1) + 1 + n2 + 2);
                intList.add(3 * (n3 + 1) + 1 + n2 + 1);
            }
        }
        polygonArray.polygons = intList;
        polygonArray.vertices = floatList;
        polygonArray.normals = byteList;
        polygonArray.uv = floatList2;
        polygonArray.visibleSides = 0;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Frustum();
    }

    public float getBaseRadius() {
        return this.baseRadius;
    }

    public void setBaseRadius(float f) {
        this.baseRadius = f;
    }

    public float getTopRadius() {
        return this.topRadius;
    }

    public void setTopRadius(float f) {
        this.topRadius = f;
    }

    public boolean isBaseOpen() {
        return (this.bits & 0x4000) != 0;
    }

    public void setBaseOpen(boolean bl) {
        this.bits = bl ? (this.bits |= 0x4000) : (this.bits &= 0xFFFFBFFF);
    }

    public boolean isTopOpen() {
        return (this.bits & 0x8000) != 0;
    }

    public void setTopOpen(boolean bl) {
        this.bits = bl ? (this.bits |= 0x8000) : (this.bits &= 0xFFFF7FFF);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)baseRadius$FIELD);
        topRadius$FIELD = new _Field("topRadius", 0x200004, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)topRadius$FIELD);
        baseOpen$FIELD = new Node.NType.BitField($TYPE, "baseOpen", 0x200000, Type.BOOLEAN, 16384);
        $TYPE.addManagedField((ManageableType.Field)baseOpen$FIELD);
        topOpen$FIELD = new Node.NType.BitField($TYPE, "topOpen", 0x200000, Type.BOOLEAN, 32768);
        $TYPE.addManagedField((ManageableType.Field)topOpen$FIELD);
        $TYPE.declareFieldAttribute(baseRadius$FIELD, (Attribute)Attributes.BASE_RADIUS);
        $TYPE.declareFieldAttribute(topRadius$FIELD, (Attribute)Attributes.TOP_RADIUS);
        $TYPE.declareFieldAttribute(baseOpen$FIELD, (Attribute)Attributes.BASE_OPEN);
        $TYPE.declareFieldAttribute(topOpen$FIELD, (Attribute)Attributes.TOP_OPEN);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((Frustum)object).baseRadius = f;
                    return;
                }
                case 1: {
                    ((Frustum)object).topRadius = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Frustum)object).getBaseRadius();
                }
                case 1: {
                    return ((Frustum)object).getTopRadius();
                }
            }
            return super.getFloat(object);
        }
    }

    public static class Pattern
    extends FieldListPattern {
        public Pattern() {
            super(null, (Type)$TYPE, (Field[])new Node.NType.Field[]{Axis.length$FIELD, baseRadius$FIELD, topRadius$FIELD});
        }

        public static void signature(@UserDefinedPattern.In @UserDefinedPattern.Out Frustum frustum, float f, float f2, float f3) {
        }
    }
}

