/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Axis;
import de.grogra.imp3d.ray.RTBox;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Field;
import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.FieldListPattern;
import de.grogra.xl.query.UserDefinedPattern;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Box
extends Axis
implements Pickable,
Renderable,
Raytraceable {
    public static final int SHIFT_PIVOT_MASK = 16384;
    public static final int USED_BITS = 15;
    protected float width = 1.0f;
    protected float height = 1.0f;
    public static final Node.NType $TYPE = new Node.NType((Node)new Box());
    public static final Node.NType.Field width$FIELD = new _Field("width", 0x200004, Type.FLOAT, null, 0);
    public static final Node.NType.Field height$FIELD;
    public static final Node.NType.Field shiftPivot$FIELD;

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.addDependency(shiftPivot$FIELD.getAttribute(), (Attribute)Attributes.TRANSFORMATION);
    }

    public Box() {
    }

    public Box(float f) {
        this.setLength(f);
    }

    public Box(float f, boolean bl) {
        this.setLength(f);
        this.setShiftPivot(bl);
    }

    public Box(float f, float f2, float f3) {
        this.setLength(f);
        this.setWidth(f2);
        this.setHeight(f3);
    }

    protected float getPivotShift(Object object, boolean bl, GraphState graphState) {
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                return this.isShiftPivot() ? 0.5f * this.width : 0.0f;
            }
            if (!graphState.checkBoolean((Object)this, true, Attributes.SHIFT_PIVOT, this.isShiftPivot())) {
                return 0.0f;
            }
            return 0.5f * (float)graphState.checkDouble((Object)this, true, Attributes.WIDTH, (double)this.width);
        }
        if (!graphState.getBoolean(object, bl, Attributes.SHIFT_PIVOT)) {
            return 0.0f;
        }
        return 0.5f * (float)graphState.getDouble((Object)this, true, Attributes.WIDTH);
    }

    private static double pick(double d, double d2, Tuple3d tuple3d, Vector3d vector3d, int n, float f, float f2, float f3) {
        double d3;
        double d4 = n == 0 ? vector3d.x : (d3 = n == 1 ? vector3d.y : vector3d.z);
        if (Math.abs(d3) > 1.0E-10 && 0.0 < (d3 = d2 / d3) && d3 < d) {
            double d5 = d3 * vector3d.x + tuple3d.x;
            double d6 = d3 * vector3d.y + tuple3d.y;
            double d7 = d3 * vector3d.z + tuple3d.z;
            if ((n == 0 || Math.abs(d5) <= (double)f) && (n == 1 || Math.abs(d6) <= (double)f2) && (n == 2 || d7 >= 0.0 && d7 <= (double)f3)) {
                return d3;
            }
        }
        return d;
    }

    public static void pick(float f, float f2, float f3, Point3d point3d, Vector3d vector3d, PickList pickList) {
        double d = Double.MAX_VALUE;
        d = Box.pick(d, (double)(-f) - point3d.x, (Tuple3d)point3d, vector3d, 0, f, f2, f3);
        d = Box.pick(d, (double)f - point3d.x, (Tuple3d)point3d, vector3d, 0, f, f2, f3);
        d = Box.pick(d, (double)(-f2) - point3d.y, (Tuple3d)point3d, vector3d, 1, f, f2, f3);
        d = Box.pick(d, (double)f2 - point3d.y, (Tuple3d)point3d, vector3d, 1, f, f2, f3);
        d = Box.pick(d, -point3d.z, (Tuple3d)point3d, vector3d, 2, f, f2, f3);
        if ((d = Box.pick(d, (double)f3 - point3d.z, (Tuple3d)point3d, vector3d, 2, f, f2, f3)) < Double.MAX_VALUE) {
            pickList.add(d);
        }
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        GraphState graphState = pickList.getGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                Box.pick(this.width * 0.5f, this.height * 0.5f, this.length, point3d, vector3d, pickList);
            } else {
                Box.pick((float)graphState.checkDouble((Object)this, true, Attributes.WIDTH, (double)this.width) * 0.5f, (float)graphState.checkDouble((Object)this, true, Attributes.HEIGHT, (double)this.height) * 0.5f, (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length), point3d, vector3d, pickList);
            }
        } else {
            Box.pick((float)graphState.getDouble(object, bl, Attributes.WIDTH) * 0.5f, (float)graphState.getDouble(object, bl, Attributes.HEIGHT) * 0.5f, (float)graphState.getDouble(object, bl, Attributes.LENGTH), point3d, vector3d, pickList);
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        GraphState graphState = renderState.getRenderGraphState();
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                renderState.drawBox(this.width * 0.5f, this.height * 0.5f, this.length, null, -1, null);
            } else {
                renderState.drawBox((float)graphState.checkDouble((Object)this, true, Attributes.WIDTH, (double)this.width) * 0.5f, (float)graphState.checkDouble((Object)this, true, Attributes.HEIGHT, (double)this.height) * 0.5f, (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length), null, -1, null);
            }
        } else {
            renderState.drawBox((float)graphState.getDouble(object, bl, Attributes.WIDTH) * 0.5f, (float)graphState.getDouble(object, bl, Attributes.HEIGHT) * 0.5f, (float)graphState.getDouble(object, bl, Attributes.LENGTH), null, -1, null);
        }
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        float f;
        float f2;
        float f3;
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                f3 = this.width;
                f2 = this.length;
                f = this.height;
            } else {
                f3 = (float)graphState.checkDouble((Object)this, true, Attributes.WIDTH, (double)this.width);
                f2 = (float)graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length);
                f = (float)graphState.checkDouble((Object)this, true, Attributes.HEIGHT, (double)this.height);
            }
        } else {
            f3 = (float)graphState.getDouble(object, bl, Attributes.WIDTH);
            f2 = (float)graphState.getDouble(object, bl, Attributes.LENGTH);
            f = (float)graphState.getDouble(object, bl, Attributes.HEIGHT);
        }
        return new RTBox(object, bl, l, f3, f, f2);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Box();
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public boolean isShiftPivot() {
        return (this.bits & 0x4000) != 0;
    }

    public void setShiftPivot(boolean bl) {
        this.bits = bl ? (this.bits |= 0x4000) : (this.bits &= 0xFFFFBFFF);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)width$FIELD);
        height$FIELD = new _Field("height", 0x200004, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)height$FIELD);
        shiftPivot$FIELD = new Node.NType.BitField($TYPE, "shiftPivot", 0x200000, Type.BOOLEAN, 16384);
        $TYPE.addManagedField((ManageableType.Field)shiftPivot$FIELD);
        $TYPE.declareFieldAttribute(width$FIELD, (Attribute)Attributes.WIDTH);
        $TYPE.declareFieldAttribute(height$FIELD, (Attribute)Attributes.HEIGHT);
        $TYPE.declareFieldAttribute(shiftPivot$FIELD, (Attribute)Attributes.SHIFT_PIVOT);
        Box.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((Box)object).width = f;
                    return;
                }
                case 1: {
                    ((Box)object).height = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Box)object).getWidth();
                }
                case 1: {
                    return ((Box)object).getHeight();
                }
            }
            return super.getFloat(object);
        }
    }

    public static class Pattern
    extends FieldListPattern {
        public Pattern() {
            super(null, (Type)$TYPE, (Field[])new Node.NType.Field[]{Axis.length$FIELD, width$FIELD, height$FIELD});
        }

        public static void signature(@UserDefinedPattern.In @UserDefinedPattern.Out Box box, float f, float f2, float f3) {
        }
    }

    public static class LPattern
    extends FieldListPattern {
        public LPattern() {
            super((Type)$TYPE, (Field)Axis.length$FIELD);
        }

        public static void signature(@UserDefinedPattern.In @UserDefinedPattern.Out Box box, float f) {
        }
    }
}

