/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.msml;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.imp3d.msml.Appearance;
import de.grogra.imp3d.msml.CoordTransformer;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.shading.Shader;
import de.grogra.msml.MSMLDatatype;
import de.grogra.msml.MSMLMetadata;
import de.grogra.msml.MSNode;
import de.grogra.pf.io.DOMSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.Registry;
import de.grogra.util.MimeType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.vecmath.Matrix3f;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MSMLWriter
extends FilterBase
implements DOMSource {
    public static final IOFlavor FLAVOR = new IOFlavor(new MimeType("text/msml+extsrc+xml", null), 128, null);
    public static final String namespaceURI = "http://grogra.de/msml";
    public static final String qualifiedName = "msml";
    public static final String schemaSource = "msml-base.xsd";
    public static final String msmlSchemaLocation = "http://grogra.de/msml msml-base.xsd";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final int ROOT = 0;
    static final int MSOBJECT = 1;
    static final int GROUP = 2;
    static final int SHAPE = 3;
    public static final CoordTransformer COORD = new CoordTransformer(new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f), new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f));
    HashMap elemAllocation = new HashMap();
    HashMap edgeTypes = new HashMap();
    HashMap idconvert = new HashMap();
    public HashMap librarymaterials = new HashMap();

    public MSMLWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
        this.initElemAllocation();
        this.initEdgeTypeAllocation();
    }

    public HashMap getLibraryMaterials() {
        return this.librarymaterials;
    }

    private void initEdgeTypeAllocation() {
        this.edgeTypes.put(new Integer(256), "successor");
        this.edgeTypes.put(new Integer(512), "branch");
        this.edgeTypes.put(new Integer(1024), "refinement");
    }

    private void initElemAllocation() {
        for (de.grogra.graph.impl.Node node = this.item.getBranch(); node != null; node = node.getSuccessor()) {
            if (!(node instanceof ObjectItem)) continue;
            ObjectItem objectItem = (ObjectItem)node;
            this.elemAllocation.put(objectItem.getName(), objectItem.getObject());
        }
    }

    public Document getDocument() throws IOException, DOMException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("The parser does not support JAXP 1.2");
        }
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Parser misconfigured:" + parserConfigurationException);
            return null;
        }
        Registry registry = (Registry)((ObjectSource)this.source).getObject();
        GraphManager graphManager = registry.getProjectGraph();
        de.grogra.graph.impl.Node node = (de.grogra.graph.impl.Node)graphManager.getRoot("MainGraph");
        Element element = document.createElementNS(namespaceURI, qualifiedName);
        document.appendChild(element);
        Attr attr = document.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
        attr.setNodeValue(msmlSchemaLocation);
        element.setAttributeNodeNS(attr);
        element.setAttribute("version", "1.0");
        Element element2 = document.createElementNS(namespaceURI, "library");
        Element element3 = document.createElementNS(namespaceURI, "data");
        Item item = registry.getDirectory("/project/objects/3d/materials", null);
        for (de.grogra.graph.impl.Node node2 = item.getBranch(); node2 != null; node2 = node2.getSuccessor()) {
            if (!(node2 instanceof ObjectItem)) continue;
            ObjectItem objectItem = (ObjectItem)node2;
            Appearance.exportShader((Object)this, document, element3, (Shader)objectItem.getObject(), objectItem.getName());
            this.librarymaterials.put(objectItem.getObject(), objectItem.getName());
        }
        if (element3.hasChildNodes()) {
            element2.appendChild(element3);
            element.appendChild(element2);
        }
        this.traverseNode(document, element, null, node, this.checkNodeType(node));
        return document;
    }

    private int checkNodeType(de.grogra.graph.impl.Node node) {
        if (Attributes.isVisible(node, true, (Graph)node.getGraph())) {
            return 3;
        }
        if (node instanceof MSNode) {
            return 1;
        }
        if (node.isRoot() && node.getDirectChildCount() == 1) {
            return 0;
        }
        return 2;
    }

    private void traverseNode(Document document, Element element, Element element2, de.grogra.graph.impl.Node node, int n) {
        switch (n) {
            case 0: {
                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                    if (!edge.isSource(node)) continue;
                    this.traverseNode(document, element, element2, edge.getTarget(), this.checkNodeType(edge.getTarget()));
                }
                break;
            }
            case 3: {
                this.exportSSObject(document, element, node);
                break;
            }
            case 1: {
                this.exportMSObject(document, element, (MSNode)node);
                break;
            }
            case 2: {
                Object object;
                String string;
                Element element3 = document.createElementNS(namespaceURI, "group");
                String string2 = this.transformId(node);
                element3.setAttribute("id", string2);
                String string3 = string = node.getName() == null ? "" : node.getName();
                if (string != "") {
                    element3.setAttribute("name", string);
                }
                element.appendChild(element3);
                if (this.elemAllocation.containsKey(node.getClass().getName())) {
                    object = document.createElementNS(namespaceURI, "data");
                    ((MSMLDatatype)this.elemAllocation.get(node.getClass().getName())).export((Object)this, document, (Element)object, node);
                    element3.appendChild((Node)object);
                }
                for (object = node.getFirstEdge(); object != null; object = object.getNext(node)) {
                    if (!object.isSource(node) || (object.getEdgeBits() & 0x300) <= 0) continue;
                    this.traverseNode(document, element3, element2, object.getTarget(), this.checkNodeType(object.getTarget()));
                }
                break;
            }
        }
    }

    private void exportMSObject(Document document, Element element, MSNode mSNode) {
        de.grogra.graph.impl.Node node;
        String string;
        Element element2 = document.createElementNS(namespaceURI, "msobject");
        element2.setAttribute("id", this.transformId((de.grogra.graph.impl.Node)mSNode));
        String string2 = string = mSNode.getName() == null ? "" : mSNode.getName();
        if (string != "") {
            element2.setAttribute("name", string);
        }
        if ((node = mSNode.getScale()) != null && node.getName() != "") {
            element2.setAttribute("showScale", node.getName());
        }
        for (Edge edge = mSNode.getFirstEdge(); edge != null; edge = edge.getNext((de.grogra.graph.impl.Node)mSNode)) {
            if (!edge.isSource((de.grogra.graph.impl.Node)mSNode)) continue;
            this.exportScale(document, element2, edge.getTarget());
        }
        element.appendChild(element2);
    }

    private void exportScale(Document document, Element element, de.grogra.graph.impl.Node node) {
        String string;
        Element element2 = document.createElementNS(namespaceURI, "scale");
        element.appendChild(element2);
        element2.setAttribute("id", this.transformId(node));
        String string2 = string = node.getName() == null ? "" : node.getName();
        if (string != "") {
            element2.setAttribute("name", string);
        }
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            if (!edge.isSource(node)) continue;
            this.traverseNode(document, element2, edge.getTarget());
        }
    }

    private void exportSSObject(Document document, Element element, de.grogra.graph.impl.Node node) {
        Element element2 = document.createElementNS(namespaceURI, "msobject");
        element2.setAttribute("id", this.transformId(node) + "ms");
        Element element3 = document.createElementNS(namespaceURI, "scale");
        element3.setAttribute("id", this.transformId(node) + "s");
        element2.appendChild(element3);
        this.traverseNode(document, element3, node);
        element.appendChild(element2);
    }

    private void traverseNode(Document document, Element element, de.grogra.graph.impl.Node node) {
        this.exportNode(document, element, node);
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            if (!edge.isSource(node)) continue;
            de.grogra.graph.impl.Node node2 = edge.getTarget();
            this.exportEdge(document, element, edge, 1024);
            Node node3 = element.getParentNode();
            if (node3 != null) {
                this.exportEdge(document, (Element)node3, 1024, edge);
            }
            if ((edge.getEdgeBits() & 0x300) <= 0) continue;
            if (node2 instanceof MSNode) {
                this.traverseMSNode(document, element, (MSNode)node2);
                continue;
            }
            this.traverseNode(document, element, node2);
        }
    }

    private void traverseMSNode(Document document, Element element, MSNode mSNode) {
        de.grogra.graph.impl.Node node;
        String string;
        Element element2 = document.createElementNS(namespaceURI, "msobject");
        element.appendChild(element2);
        element2.setAttribute("id", this.transformId((de.grogra.graph.impl.Node)mSNode));
        String string2 = string = mSNode.getName() == null ? "" : mSNode.getName();
        if (string != "") {
            element2.setAttribute("name", string);
        }
        if ((node = mSNode.getScale()) != null && node.getName() != "") {
            element2.setAttribute("showScale", node.getName());
        }
        for (Edge edge = mSNode.getFirstEdge(); edge != null; edge = edge.getNext((de.grogra.graph.impl.Node)mSNode)) {
            if (!edge.isSource((de.grogra.graph.impl.Node)mSNode)) continue;
            de.grogra.graph.impl.Node node2 = edge.getTarget();
            Element element3 = document.createElementNS(namespaceURI, "scale");
            element2.appendChild(element3);
            element3.setAttribute("id", this.transformId(node2));
            String string3 = string = node2.getName() == null ? "" : node2.getName();
            if (string != "") {
                element3.setAttribute("name", string);
            }
            for (Edge edge2 = node2.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(node2)) {
                if (!edge2.isSource(node2)) continue;
                this.traverseMSNodeScale(document, element3, edge2.getTarget(), element, element2, node.equals(node2));
            }
        }
    }

    private void traverseMSNodeScale(Document document, Element element, de.grogra.graph.impl.Node node, Element element2, Element element3, boolean bl) {
        this.exportNode(document, element, node);
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            if (!edge.isSource(node)) continue;
            de.grogra.graph.impl.Node node2 = edge.getTarget();
            if ((edge.getEdgeBits() & 0x8000) == 0) {
                this.exportEdge(document, element, edge, 1024);
                this.exportEdge(document, element3, 1024, edge);
                if ((edge.getEdgeBits() & 0x300) <= 0) continue;
                this.traverseMSNodeScale(document, element, node2, element2, element3, bl);
                continue;
            }
            this.exportEdge(document, element2, edge, 1024);
            this.exportEdge(document, element3, 1024, edge);
            if ((edge.getEdgeBits() & 0x300) <= 0 || !bl) continue;
            if (node2 instanceof MSNode) {
                this.traverseMSNode(document, element2, (MSNode)node2);
                continue;
            }
            this.traverseNode(document, element2, node2);
        }
    }

    private void exportNode(Document document, Element element, de.grogra.graph.impl.Node node) {
        String string;
        String string2;
        Element element2 = document.createElementNS(namespaceURI, "node");
        element2.setAttribute("id", this.transformId(node));
        String string3 = string2 = node.getName() == null ? "" : node.getName();
        if (string2 != "") {
            element2.setAttribute("name", string2);
        }
        Element element3 = document.createElementNS(namespaceURI, "data");
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        Object object = graphState.getObjectDefault((Object)node, true, Attributes.SHAPE, null);
        if (object != null && this.elemAllocation.containsKey(string = object.getClass().getName())) {
            ((MSMLDatatype)this.elemAllocation.get(string)).export((Object)this, document, element3, node);
        }
        try {
            string = (MSMLMetadata)node.getFirst(32768);
            if (string != null) {
                Set set = string.getAllKeys();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Node node2 = document.importNode(string.getMetadata(iterator.next().toString()), true);
                    element3.appendChild(node2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (element3.hasChildNodes()) {
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    private void exportEdge(Document document, Element element, Edge edge, int n) {
        Set set = this.edgeTypes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (!edge.testEdgeBits(n2) || (n2 & n) != 0) continue;
            this.exportEdge(document, element, n2, edge);
        }
    }

    private void exportEdge(Document document, Element element, Edge edge) {
        this.exportEdge(document, element, edge, 0);
    }

    private void exportEdge(Document document, Element element, int n, Edge edge) {
        if (edge.testEdgeBits(n)) {
            Element element2 = document.createElementNS(namespaceURI, "edge");
            element2.setAttribute("source", this.transformId(edge.getSource()));
            element2.setAttribute("target", this.transformId(edge.getTarget()));
            if ((edge.getEdgeBits() & 0xFF) > 0) {
                element2.setAttribute("order", "" + (edge.getEdgeBits() & 0xFF));
            }
            element2.setAttribute("type", (String)this.edgeTypes.get(new Integer(n)));
            element.appendChild(element2);
        }
    }

    private String transformId(de.grogra.graph.impl.Node node) {
        return "id" + Long.toString(node.getId());
    }
}

