/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.msml;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.imp.io.ImageReader;
import de.grogra.imp.objects.FixedImageAdapter;
import de.grogra.imp.objects.ImageAdapter;
import de.grogra.imp3d.msml.MSMLWriter;
import de.grogra.imp3d.msml.X3DMSMLDatatype;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Material;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SideSwitchShader;
import de.grogra.math.ChannelMap;
import de.grogra.math.Graytone;
import de.grogra.math.RGBColor;
import de.grogra.persistence.Shareable;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Workbench;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Appearance
extends X3DMSMLDatatype {
    HashMap textures = new HashMap();
    HashMap appearances = new HashMap();

    public void export(Object object, Document document, Element element, de.grogra.graph.impl.Node node) {
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        Object object2 = graphState.getObjectDefault((Object)node, true, Attributes.SHADER, null);
        if (object2 != null) {
            Appearance.exportShader(object, document, element, (Shader)object2, null);
        }
    }

    public static void exportShader(Object object, Document document, Element element, Shader shader, String string) {
        if (shader != null) {
            Element element2 = document.createElementNS("http://grogra.de/msml/datatypes/groimp", "g:Appearance");
            if (((MSMLWriter)((Object)object)).getLibraryMaterials().containsKey(shader)) {
                element2.setAttribute("USE", (String)((MSMLWriter)((Object)object)).getLibraryMaterials().get(shader));
            } else {
                Element element3 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Appearance");
                element2.appendChild(element3);
                if (string != null && !string.equals("")) {
                    element2.setAttribute("DEF", string);
                }
                if (shader instanceof RGBAShader) {
                    Element element4 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Material");
                    RGBAShader rGBAShader = (RGBAShader)shader;
                    element4.setAttribute("diffuseColor", Appearance.getStringFromVector3f(new Vector3f(rGBAShader.x, rGBAShader.y, rGBAShader.z)));
                    element4.setAttribute("transparency", String.valueOf(1.0f - rGBAShader.w));
                    element3.appendChild(element4);
                } else if (shader instanceof SideSwitchShader) {
                    Appearance.exportMaterial(document, element3, (Material)((SideSwitchShader)shader).getFrontShader());
                } else if (shader instanceof Material) {
                    Appearance.exportMaterial(document, element3, (Material)shader);
                }
            }
            element.appendChild(element2);
        }
    }

    private static void exportMaterial(Document document, Element element, Material material) {
        ChannelMap channelMap;
        Phong phong;
        Element element2 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Material");
        if (material instanceof Phong) {
            phong = (Phong)material;
            channelMap = phong.getDiffuse();
            Vector3f vector3f = null;
            if (channelMap instanceof RGBColor || channelMap instanceof Graytone) {
                vector3f = Appearance.getVector3fFromChannelMap(channelMap);
                if (vector3f != null) {
                    element2.setAttribute("diffuseColor", Appearance.getStringFromVector3f(vector3f));
                }
            } else if (channelMap instanceof ImageMap) {
                URL uRL = ((ImageMap)channelMap).getImageAdapter().getImageSource();
                if (uRL != null) {
                    Element element3 = document.createElementNS("http://www.web3d.org/specifications", "x3d:ImageTexture");
                    element3.setAttribute("url", uRL.toString());
                    element.appendChild(element3);
                } else {
                    BufferedImage bufferedImage = ((ImageMap)channelMap).getImageAdapter().getBufferedImage();
                    if (bufferedImage != null) {
                        Element element4 = document.createElementNS("http://www.web3d.org/specifications", "x3d:PixelTexture");
                        element4.setAttribute("image", Appearance.getStringFromBufferedImage(bufferedImage));
                        element.appendChild(element4);
                    }
                }
                Appearance.exportTextureTransform(document, (ImageMap)channelMap, element);
            }
            if ((vector3f = Appearance.getVector3fFromChannelMap(phong.getEmissive())) != null) {
                element2.setAttribute("emissiveColor", Appearance.getStringFromVector3f(vector3f));
            }
            if ((vector3f = Appearance.getVector3fFromChannelMap(phong.getAmbient())) != null) {
                element2.setAttribute("ambientIntensity", String.valueOf(new Graytone((Tuple3f)vector3f).getValue()));
            }
            if ((vector3f = Appearance.getVector3fFromChannelMap(phong.getTransparency())) != null) {
                element2.setAttribute("transparency", String.valueOf(new Graytone((Tuple3f)vector3f).getValue()));
            }
            element.appendChild(element2);
        }
        if (material instanceof Phong) {
            phong = (Phong)material;
            channelMap = Appearance.getVector3fFromChannelMap(phong.getSpecular());
            if (channelMap != null) {
                element2.setAttribute("specularColor", Appearance.getStringFromVector3f((Vector3f)channelMap));
            }
            element2.setAttribute("shininess", String.valueOf(phong.getShininess() instanceof Graytone ? Phong.convertShininess(((Graytone)phong.getShininess()).getValue()) : 50.0f));
        }
    }

    private static void exportTextureTransform(Document document, ImageMap imageMap, Element element) {
        ChannelMap channelMap = imageMap.getInput();
        if (channelMap instanceof AffineUVTransformation) {
            Vector2f vector2f;
            float f;
            AffineUVTransformation affineUVTransformation = (AffineUVTransformation)channelMap;
            Element element2 = document.createElementNS("http://www.web3d.org/specifications", "x3d:TextureTransform");
            boolean bl = false;
            Vector2f vector2f2 = new Vector2f(affineUVTransformation.getOffsetU(), affineUVTransformation.getOffsetV());
            if (vector2f2.length() != 0.0f) {
                element2.setAttribute("translation", Appearance.getStringFromVector2f(vector2f2));
                bl = true;
            }
            if ((double)(f = affineUVTransformation.getAngle()) % (Math.PI * 2) != 0.0) {
                element2.setAttribute("rotation", String.valueOf(f));
                bl = true;
            }
            if ((vector2f = new Vector2f(affineUVTransformation.getScaleU(), affineUVTransformation.getScaleV())).length() != 1.0f) {
                element2.setAttribute("scale", Appearance.getStringFromVector2f(vector2f));
                bl = true;
            }
            if (bl) {
                element.appendChild(element2);
            }
        }
    }

    public de.grogra.graph.impl.Node export(Registry registry, Node node, de.grogra.graph.impl.Node node2, URL uRL) throws IOException {
        if (node.getNamespaceURI().equals("http://grogra.de/msml/datatypes/groimp")) {
            Material material = null;
            String string = Appearance.getAttributeContent(node, "USE");
            if (string.equals("")) {
                material = this.createMaterial(registry, node, uRL);
                String string2 = Appearance.getAttributeContent(node, "DEF");
                if (!string2.equals("")) {
                    registry.addSharedObject("/project/objects/3d/materials", (Shareable)material, string2, true);
                    this.appearances.put(string2, material);
                }
            } else {
                material = (Material)this.appearances.get(string);
            }
            if (node2 instanceof ShadedNull && material != null) {
                ((ShadedNull)node2).setMaterial(material);
            }
        }
        return node2;
    }

    private Material createMaterial(Registry registry, Node node, URL uRL) throws IOException {
        Phong phong = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getNamespaceURI().equals("http://www.web3d.org/specifications") || !node2.getLocalName().equals("Appearance")) continue;
            phong = new Phong();
            phong.setDiffuse((ChannelMap)new RGBColor(0.8f, 0.8f, 0.8f));
            phong.setEmissive((ChannelMap)new RGBColor(0.0f, 0.0f, 0.0f));
            phong.setSpecular((ChannelMap)new RGBColor(0.0f, 0.0f, 0.0f));
            phong.setShininess((ChannelMap)new Graytone(0.2f));
            phong.setTransparency((ChannelMap)new Graytone(0.0f));
            phong.setAmbient((ChannelMap)new Graytone(0.2f));
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                Object object;
                String string;
                String string2;
                if (node3.getNodeType() != 1 || !node3.getNamespaceURI().equals("http://www.web3d.org/specifications")) continue;
                if (node3.getLocalName().equals("Material")) {
                    string2 = Appearance.getAttributeContent(node3, "diffuseColor");
                    if (string2 != "") {
                        phong.setDiffuse((ChannelMap)new RGBColor((Tuple3f)Appearance.getVector3fFromString(string2)));
                    }
                    if ((string2 = Appearance.getAttributeContent(node3, "emissiveColor")) != "") {
                        phong.setEmissive((ChannelMap)new RGBColor((Tuple3f)Appearance.getVector3fFromString(string2)));
                    }
                    if ((string2 = Appearance.getAttributeContent(node3, "specularColor")) != "") {
                        phong.setSpecular((ChannelMap)new RGBColor((Tuple3f)Appearance.getVector3fFromString(string2)));
                    }
                    if ((string2 = Appearance.getAttributeContent(node3, "shininess")) != "") {
                        phong.setShininess((ChannelMap)new Graytone(Float.valueOf(string2).floatValue()));
                    }
                    if ((string2 = Appearance.getAttributeContent(node3, "transparency")) != "") {
                        phong.setTransparency((ChannelMap)new Graytone(Float.valueOf(string2).floatValue()));
                    }
                    if ((string2 = Appearance.getAttributeContent(node3, "ambientIntensity")) == "") continue;
                    phong.setAmbient((ChannelMap)new Graytone(Float.valueOf(string2).floatValue()));
                    continue;
                }
                if (node3.getLocalName().equals("ImageTexture")) {
                    string2 = null;
                    string = Appearance.getAttributeContent(node3, "url");
                    if (string == "") continue;
                    URL uRL2 = Appearance.getURLfromString(uRL, string);
                    string2 = (FixedImageAdapter)this.textures.get(uRL2);
                    if (string2 == null) {
                        object = Workbench.current();
                        string2 = (FixedImageAdapter)ImageReader.getFactory((RegistryContext)registry).addFromURL(registry, uRL2, null, (Workbench)object);
                        this.textures.put(uRL2, string2);
                    }
                    object = new ImageMap();
                    ((ImageMap)((Object)object)).setImageAdapter((ImageAdapter)string2);
                    object = this.setTextureTransform((ImageMap)((Object)object), node3.getParentNode());
                    phong.setDiffuse((ChannelMap)object);
                    continue;
                }
                if (!node3.getLocalName().equals("PixelTexture")) continue;
                string2 = null;
                string = Appearance.getAttributeContent(node3, "image");
                if (string == "") continue;
                int n = string.hashCode();
                object = Appearance.getBufferedImageFromSFImage(string);
                string2 = (FixedImageAdapter)this.textures.get(new Integer(n));
                if (string2 == null) {
                    string2 = new FixedImageAdapter(object);
                    registry.addSharedObject("/project/objects/images", (Shareable)string2, "Pixelimage", true);
                    this.textures.put(new Integer(n), string2);
                }
                ImageMap imageMap = new ImageMap();
                imageMap.setImageAdapter((ImageAdapter)string2);
                imageMap = this.setTextureTransform(imageMap, node3.getParentNode());
                phong.setDiffuse(imageMap);
            }
        }
        return phong;
    }

    private ImageMap setTextureTransform(ImageMap imageMap, Node node) {
        AffineUVTransformation affineUVTransformation = new AffineUVTransformation();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Vector2f vector2f;
            if (node2.getNodeType() != 1 || !node2.getNamespaceURI().equals("http://www.web3d.org/specifications") || !node2.getLocalName().equals("TextureTransform")) continue;
            String string = Appearance.getAttributeContent(node2, "translation");
            if (string != "") {
                vector2f = Appearance.getVector2fFromString(string);
                affineUVTransformation.setOffsetU(vector2f.x);
                affineUVTransformation.setOffsetV(vector2f.y);
            }
            if ((string = Appearance.getAttributeContent(node2, "rotation")) != "") {
                affineUVTransformation.setAngle(Float.valueOf(string).floatValue());
            }
            if ((string = Appearance.getAttributeContent(node2, "scale")) != "") {
                vector2f = Appearance.getVector2fFromString(string);
                affineUVTransformation.setScaleU(vector2f.x);
                affineUVTransformation.setScaleV(vector2f.y);
            }
            imageMap.setInput(affineUVTransformation);
        }
        return imageMap;
    }
}

