/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.io;

import de.grogra.graph.GraphState;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.LookupForClass;
import de.grogra.pf.ui.registry.FileObjectItem;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.util.ObjectList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public abstract class SceneGraphExport
extends FilterBase
implements SceneTree.Visitor {
    protected ObjectList files = new ObjectList();
    private View3D view;
    private FileSystem fileSystem;
    private Object directory;
    private HashSet createdFiles = new HashSet();
    private HashMap fileItemFiles = new HashMap();
    private final LookupForClass exports;
    private SceneTree.InnerNode innerNodeOfLeaf;

    public SceneGraphExport(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.exports = new LookupForClass((Item)filterItem);
    }

    public FileSystem getFileSystem() throws IOException {
        if (this.fileSystem == null) {
            this.fileSystem = this.initFileSystem();
        }
        return this.fileSystem;
    }

    public Object getDirectory() throws IOException {
        if (this.directory == null) {
            this.getFileSystem();
            this.directory = this.initDirectory();
        }
        return this.directory;
    }

    protected FileSystem initFileSystem() throws IOException {
        return null;
    }

    protected Object initDirectory() throws IOException {
        return null;
    }

    public Object getFile(String string) throws IOException {
        int n = string.lastIndexOf(46);
        String string2 = n < 0 ? string : string.substring(0, n);
        String string3 = n < 0 ? "" : string.substring(n);
        n = 0;
        while (!this.createdFiles.add(string)) {
            string = string2 + ++n + string3;
        }
        return this.getFileSystem().create(this.getDirectory(), string, false, false);
    }

    public String getPath(Object object) throws IOException {
        return this.getFileSystem().getPath(object);
    }

    public OutputStream getOutputStream(Object object) throws IOException {
        return this.getFileSystem().getOutputStream(object, false);
    }

    public String getPath(FileObjectItem fileObjectItem) throws IOException {
        FileSystem fileSystem = this.getFileSystem();
        Object object = this.fileItemFiles.get(fileObjectItem);
        if (object == null) {
            FileSource fileSource = fileObjectItem.createFileSource();
            FileSystem fileSystem2 = fileSource.getFileSystem();
            if (fileSystem instanceof LocalFileSystem && fileSystem2 instanceof LocalFileSystem) {
                object = fileSource.getInputFile();
            } else if (fileSystem2 == fileSystem) {
                object = fileSource.getFile();
            } else {
                object = this.getFile(fileSystem2.getName(fileSource.getFile()));
                fileSystem2.copyFileTo(fileSource.getFile(), fileSystem, object);
            }
            if (object instanceof File) {
                object = ((File)object).getAbsoluteFile();
            }
            this.fileItemFiles.put(fileObjectItem, object);
        }
        return object instanceof File ? Utils.relativize((File)((File)fileSystem.getRoot()).getAbsoluteFile(), (File)((File)object)).getPath() : fileSystem.getPath(object);
    }

    protected abstract SceneTree createSceneTree(View3D var1);

    public View3D getView() throws IOException {
        if (this.view == null) {
            this.view = (View3D)((ObjectSource)this.source).getObject();
        }
        return this.view;
    }

    public GraphState getGraphState() {
        return this.view.getWorkbenchGraphState();
    }

    public Collection getFiles() {
        return this.files;
    }

    public void visitEnter(SceneTree.InnerNode innerNode) {
        SceneTree.Node node = innerNode.children;
        if (node != null) {
            if (node.next == null && node instanceof SceneTree.Leaf) {
                this.innerNodeOfLeaf = innerNode;
            } else {
                try {
                    this.beginGroup(innerNode);
                }
                catch (IOException iOException) {
                    throw new WrapException((Throwable)iOException);
                }
            }
        }
    }

    public void visitLeave(SceneTree.InnerNode innerNode) {
        SceneTree.Node node = innerNode.children;
        if (!(node == null || node.next == null && node instanceof SceneTree.Leaf)) {
            try {
                this.endGroup(innerNode);
            }
            catch (IOException iOException) {
                throw new WrapException((Throwable)iOException);
            }
        }
    }

    public void visit(SceneTree.Leaf leaf) {
        try {
            this.export(leaf, this.innerNodeOfLeaf);
            this.innerNodeOfLeaf = null;
        }
        catch (IOException iOException) {
            throw new WrapException((Throwable)iOException);
        }
    }

    protected void write() throws IOException {
        SceneTree sceneTree = this.createSceneTree(this.getView());
        try {
            sceneTree.accept(this);
        }
        catch (WrapException wrapException) {
            if (wrapException.getCause() instanceof IOException) {
                throw (IOException)wrapException.getCause();
            }
            throw wrapException;
        }
    }

    protected abstract void beginGroup(SceneTree.InnerNode var1) throws IOException;

    protected abstract void endGroup(SceneTree.InnerNode var1) throws IOException;

    public NodeExport getExportFor(Object object, boolean bl) {
        return (NodeExport)this.exports.lookup(object.getClass());
    }

    public ObjectExport getExportForObject(Object object) {
        return (ObjectExport)this.exports.lookup(object.getClass());
    }

    protected void export(SceneTree.Leaf leaf, SceneTree.InnerNode innerNode) throws IOException {
        NodeExport nodeExport = this.getExportFor(leaf.object, leaf.asNode);
        if (nodeExport != null) {
            nodeExport.export(leaf, innerNode, this);
        }
    }

    public boolean export(Object object) throws IOException {
        ObjectExport objectExport;
        if (object != null && (objectExport = this.getExportForObject(object)) != null) {
            objectExport.export(object, this);
            return true;
        }
        return false;
    }

    public static interface ObjectExport {
        public void export(Object var1, SceneGraphExport var2) throws IOException;
    }

    public static interface NodeExport {
        public void export(SceneTree.Leaf var1, SceneTree.InnerNode var2, SceneGraphExport var3) throws IOException;
    }
}

