/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.io;

import de.grogra.imp3d.io.HGTImageReaderSpi;
import de.grogra.xl.util.IntList;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public class HGTImageReader
extends ImageReader {
    private static List imageType;
    private int width = -1;
    private int height = -1;
    private IIOByteBuffer buf = new IIOByteBuffer(new byte[16384], 0, 16384);
    private int bufPos = 0;
    private int bufEnd = 0;

    public HGTImageReader(HGTImageReaderSpi hGTImageReaderSpi) {
        super(hGTImageReaderSpi);
        if (imageType == null) {
            ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
            BufferedImage bufferedImage = new BufferedImage(1, 1, 11);
            arrayList.add(new ImageTypeSpecifier(bufferedImage));
            imageType = arrayList;
        }
    }

    public static String getDescription() {
        return "HGTFILTER";
    }

    public int getHeight(int n) throws IOException {
        return this.height;
    }

    public int getWidth(int n) throws IOException {
        return this.width;
    }

    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    public Iterator getImageTypes(int n) {
        return imageType.iterator();
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public IIOMetadata getImageMetadata(int n) {
        return null;
    }

    private int readByte() throws IOException {
        if (this.bufPos == this.bufEnd) {
            this.buf.setOffset(0);
            this.buf.setLength(((ImageInputStream)this.input).read(this.buf.getData(), 0, 16384));
            this.bufPos = this.buf.getOffset();
            this.bufEnd = this.bufPos + this.buf.getLength();
        }
        return this.bufPos >= this.bufEnd ? -1 : this.buf.getData()[this.bufPos++] & 0xFF;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        short[] sArray = new short[1442401];
        int n6 = 0;
        IntList intList = new IntList();
        while ((n5 = this.readByte()) >= 0) {
            n4 = this.readByte();
            if (n4 < 0) {
                // empty if block
            }
            if (n6 == sArray.length) {
                short[] sArray2 = sArray;
                sArray = new short[2 * n6];
                System.arraycopy(sArray2, 0, sArray, 0, n6);
            }
            if ((n4 = (short)(n4 + (n5 << 8))) == Short.MIN_VALUE) {
                intList.add(n6);
            }
            sArray[n6++] = n4;
        }
        this.width = (int)Math.sqrt(n6);
        this.height = n6 / this.width;
        n5 = intList.size();
        block1: while (!intList.isEmpty()) {
            n4 = intList.pop();
            int n7 = n4 / this.width;
            n3 = n4 - n7 * this.width;
            n2 = 1;
            while (true) {
                int n8 = Math.max(n3 - n2, 0);
                int n9 = Math.min(n3 + n2, this.width - 1);
                int n10 = Math.max(n7 - n2, 0);
                int n11 = Math.min(n7 + n2, this.height - 1);
                for (int i = n10; i <= n11; ++i) {
                    for (int j = n8; j <= n9; ++j) {
                        short s = sArray[i * this.width + j];
                        if (s == Short.MIN_VALUE) continue;
                        sArray[n4] = s;
                        continue block1;
                    }
                }
                ++n2;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 11);
        int[] nArray = new int[this.width];
        for (n3 = 0; n3 < this.height; ++n3) {
            for (n2 = this.width - 1; n2 >= 0; --n2) {
                nArray[n2] = sArray[n3 * this.width + n2];
            }
            bufferedImage.getRaster().setPixels(0, n3, this.width, 1, nArray);
        }
        return bufferedImage;
    }
}

