/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import com.sun.opengl.util.BufferUtil;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.GLSLOpenGLObject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;

public abstract class VertexBufferObject
implements GLSLOpenGLObject {
    private int[] index_vertex = new int[]{0};
    private int vertexCount;
    private int dataCount;

    public VertexBufferObject(OpenGLState openGLState) {
        openGLState.staticObjects.add(this);
    }

    public abstract float[] getVertices();

    public int getVertexFormat() {
        return 10795;
    }

    public int entryPerVertex() {
        return 8;
    }

    public int getVertexDrawType() {
        return 7;
    }

    private void fill(OpenGLState openGLState) {
        GL gL = openGLState.getGL();
        gL.glGenBuffersARB(1, this.index_vertex, 0);
        float[] fArray = this.getVertices();
        this.dataCount = fArray.length;
        this.vertexCount = this.dataCount / this.entryPerVertex();
        FloatBuffer floatBuffer = BufferUtil.newFloatBuffer((int)this.dataCount);
        floatBuffer.put(fArray);
        floatBuffer.flip();
        openGLState.getGL().glBindBufferARB(34962, this.index_vertex[0]);
        gL.glBufferDataARB(34962, this.dataCount * 4, (Buffer)floatBuffer, 35044);
    }

    public void draw(OpenGLState openGLState) {
        GL gL = openGLState.getGL();
        if (this.index_vertex[0] == 0) {
            this.fill(openGLState);
        } else {
            gL.glBindBuffer(34962, this.index_vertex[0]);
        }
        gL.glInterleavedArrays(this.getVertexFormat(), this.entryPerVertex() * 4, 0L);
        gL.glDrawArrays(this.getVertexDrawType(), 0, this.vertexCount);
        gL.glDisableClientState(32884);
        gL.glDisableClientState(32885);
        gL.glDisableClientState(32888);
        gL.glBindBuffer(34962, 0);
    }

    public void cleanup(OpenGLState openGLState, boolean bl) {
        this.index_vertex[0] = 0;
        if (!bl) {
            openGLState.getGL().glDeleteBuffers(1, this.index_vertex, 0);
        }
    }
}

