/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.FBOAttachment;
import javax.media.opengl.GL;

public class RenderBuffer
implements FBOAttachment {
    int[] glRBNumber = new int[]{0};
    int width = 0;
    int height = 0;
    int internalFormat = 0;

    public void attachToFbo(OpenGLState openGLState, int n) {
        openGLState.getGL().glFramebufferRenderbufferEXT(36160, n, 36161, this.glRBNumber[0]);
    }

    public void create(OpenGLState openGLState, int n) {
        if (this.glRBNumber[0] != 0 && n == this.internalFormat && openGLState.height == this.height && openGLState.width == this.width) {
            return;
        }
        GL gL = openGLState.getGL();
        if (this.glRBNumber[0] != 0) {
            this.delete(openGLState, false);
        }
        gL.glGenRenderbuffersEXT(1, this.glRBNumber, 0);
        gL.glBindRenderbufferEXT(36161, this.glRBNumber[0]);
        gL.glRenderbufferStorageEXT(36161, n, openGLState.width, openGLState.height);
        this.width = openGLState.width;
        this.height = openGLState.height;
        this.internalFormat = n;
    }

    public void delete(OpenGLState openGLState, boolean bl) {
        if (this.glRBNumber[0] == 0) {
            return;
        }
        if (!bl) {
            openGLState.getGL().glDeleteRenderbuffersEXT(1, this.glRBNumber, 0);
        }
        this.glRBNumber[0] = 0;
    }

    public void resize(OpenGLState openGLState) {
        this.create(openGLState, this.internalFormat);
    }

    public boolean isOkay(OpenGLState openGLState) {
        GLSLDisplay.printDebugInfo("Test for RenderBuffer " + this.glRBNumber[0] + ": ");
        boolean bl = openGLState.testGLError();
        GLSLDisplay.printDebugInfoN("");
        return bl;
    }

    public String toString() {
        return "RB[I:" + this.glRBNumber[0] + ",F:" + this.internalFormat + ",S:" + this.width + "x" + this.height + "]";
    }

    private int estimateBPP() {
        switch (this.internalFormat) {
            case 6408: {
                return 4;
            }
            case 34840: {
                return 4;
            }
            case 34842: {
                return 8;
            }
            case 32856: {
                return 4;
            }
            case 6402: {
                return 3;
            }
            case 34836: {
                return 16;
            }
            case 36214: {
                return 8;
            }
            case 35056: {
                return 4;
            }
        }
        return 0;
    }

    public int estimateSizeInByte() {
        if (this.glRBNumber[0] == 0) {
            return 0;
        }
        return this.width * this.height * this.estimateBPP();
    }
}

