/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.GLSLManagedShader;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.imp3d.shading.Shader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CachedShaderCollection {
    private int graph_stamp = 0;
    private final HashMap<ShaderConfiguration, GLSLManagedShader> shaderCache = new HashMap();
    GLSLManagedShader currentShader = null;
    boolean shaderChanged = true;

    public GLSLManagedShader getCacheEntry(OpenGLState openGLState, GLSLDisplay gLSLDisplay, ShaderConfiguration shaderConfiguration, Object object) {
        shaderConfiguration.set(openGLState, gLSLDisplay, object);
        GLSLManagedShader gLSLManagedShader = this.shaderCache.get(shaderConfiguration);
        if (gLSLManagedShader == null) {
            gLSLManagedShader = shaderConfiguration.getShaderByDefaultCollection(gLSLDisplay, object);
            if (gLSLManagedShader == null) {
                System.err.println("Found none for: " + shaderConfiguration + "/" + object);
                GLSLDisplay.printDebugInfoN("! Error retrieving valid shader for: " + object);
                return null;
            }
            assert (gLSLManagedShader instanceof GLSLManagedShader);
            gLSLManagedShader = (GLSLManagedShader)gLSLManagedShader.getInstance();
            shaderConfiguration = shaderConfiguration.clone();
            gLSLManagedShader.setConfig(shaderConfiguration);
            GLSLDisplay.printDebugInfoN("Added new Shader: " + object + " with Config: " + shaderConfiguration);
            this.shaderCache.put(shaderConfiguration, gLSLManagedShader);
        }
        if (gLSLManagedShader.getMaterial_stamp() != this.graph_stamp) {
            this.shaderChanged = true;
            gLSLManagedShader.setMaterial_stamp(this.graph_stamp);
        }
        return gLSLManagedShader;
    }

    public void findAndActivateShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay, ShaderConfiguration shaderConfiguration, Shader shader) {
        GLSLManagedShader gLSLManagedShader;
        this.currentShader = gLSLManagedShader = this.getCacheEntry(openGLState, gLSLDisplay, shaderConfiguration, shader);
        if (gLSLManagedShader == null) {
            System.err.println("Shader not found:" + shader);
            return;
        }
        gLSLManagedShader.activateShader(openGLState, gLSLDisplay, shader);
        this.shaderChanged = false;
    }

    public GLSLManagedShader findShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay, ShaderConfiguration shaderConfiguration, Shader shader) {
        GLSLManagedShader gLSLManagedShader = this.getCacheEntry(openGLState, gLSLDisplay, shaderConfiguration, shader);
        if (gLSLManagedShader == null) {
            System.err.println("Shader not found:" + shader);
            return null;
        }
        this.shaderChanged = false;
        return gLSLManagedShader;
    }

    public void setCurrentStamp(int n) {
        this.graph_stamp = n;
    }

    public void removeUnusedShaders(OpenGLState openGLState) {
        if (!this.shaderChanged) {
            return;
        }
        Collection<GLSLManagedShader> collection = this.shaderCache.values();
        Iterator<GLSLManagedShader> iterator = collection.iterator();
        while (iterator.hasNext()) {
            GLSLManagedShader gLSLManagedShader = iterator.next();
            if (gLSLManagedShader.getMaterial_stamp() == this.graph_stamp) continue;
            gLSLManagedShader.deleteShader(openGLState.getGL(), false);
            iterator.remove();
        }
        this.currentShader = null;
    }

    public GLSLManagedShader getCurrentShader() {
        return this.currentShader;
    }

    public void deleteAll(OpenGLState openGLState, boolean bl) {
        Collection<GLSLManagedShader> collection = this.shaderCache.values();
        Iterator<GLSLManagedShader> iterator = collection.iterator();
        while (iterator.hasNext()) {
            GLSLManagedShader gLSLManagedShader = iterator.next();
            gLSLManagedShader.deleteShader(openGLState.getGL(), bl);
            iterator.remove();
        }
        this.graph_stamp = 0;
    }
}

