/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.RenderPass;
import de.grogra.imp3d.glsl.utility.Drawable;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import java.awt.Dimension;
import javax.media.opengl.GL;

public class ExtractLayerPass
extends RenderPass {
    protected GLSLShader sdt = null;

    protected int getID() {
        return 1;
    }

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        gL.glPopAttrib();
        ExtractLayerPass.deactivateTextures(gL, 2, 3553);
        gL.glColorMask(true, true, true, true);
    }

    protected void loadTexture(OpenGLState openGLState) {
        GL gL = openGLState.getGL();
        openGLState.getDeferredShadingFBO().bind(openGLState);
        openGLState.getDeferredShadingFBO().attachDepthStencil(openGLState, openGLState.getPeelingRB());
        openGLState.getHDRFBO().attachDepthStencil(openGLState, openGLState.getPeelingRB());
        openGLState.getAlphaFBO().attachDepthStencil(openGLState, openGLState.getPeelingRB());
        openGLState.getDualDepthFBO().bind(openGLState);
        gL.glDrawBuffer(0);
        gL.glReadBuffer(0);
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        gL.glColorMask(false, false, false, false);
        gL.glDepthMask(true);
        this.loadTexture(openGLState);
        gL.glPushAttrib(2048);
        gL.glViewport(0, 0, openGLState.width, openGLState.height);
        gL.glClearStencil(0);
        gL.glClear(1280);
        openGLState.getPeelingFarDepthTRT().bindTo(gL, 33985);
        openGLState.disable('\u0001');
        openGLState.enable('\u0002');
        gL.glDepthFunc(515);
    }

    public void postDrawCallback(Drawable drawable, OpenGLState openGLState, GLSLDisplay gLSLDisplay) {
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        if (this.sdt == null) {
            this.sdt = new ExtractFirstLayerShader(openGLState);
        }
        this.sdt.activateShader(openGLState, gLSLDisplay, null);
        gL.glBeginQuery(35092, openGLState.occlusionQuery[0]);
        this.renderAndUpdateVector(gLSLDisplay, openGLState.getWorldToView(), openGLState.deferredTranspRenderable);
        gL.glEndQuery(35092);
    }

    class ExtractFirstLayerShader
    extends GLSLShader {
        final String[] vStdSrc;
        final String[] simpleDepthF;
        int screenDimLoc;

        public ExtractFirstLayerShader(OpenGLState openGLState) {
            super(openGLState);
            this.vStdSrc = new String[]{"#version 110\n", "varying vec3 normal;\n", "void main() {", "\tgl_Position = ftransform();", "}"};
            this.simpleDepthF = new String[]{"#version 110\n", "uniform sampler2D DepthMaxTex;\n", "uniform vec2 screenDim;\n", "void main(void)\n", "{\n", "\tfloat fragDepth = gl_FragCoord.z;\n", "\tfloat farthestDepth = texture2D(DepthMaxTex, gl_FragCoord.xy * screenDim.xy).r;\n", "\tif (gl_FragCoord.z >= farthestDepth) {\n", "\t\tdiscard;\n", "\t}\n", "\tgl_FragColor = vec4(1.0);\n", "}"};
            this.screenDimLoc = -1;
        }

        protected String[] getVertexShader(Object object) {
            return this.vStdSrc;
        }

        protected String[] getFragmentShader(Object object) {
            return this.simpleDepthF;
        }

        protected void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
            Dimension dimension = gLSLDisplay.getView().getSize();
            gL.glUniform2f(this.screenDimLoc, 1.0f / (float)dimension.width, 1.0f / (float)dimension.height);
        }

        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "DepthMaxTex");
            gL.glUniform1i(n, 1);
            this.screenDimLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), "screenDim");
        }
    }
}

