/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderable;

import de.grogra.graph.GraphState;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderable.GLSLBox;
import de.grogra.imp3d.glsl.renderable.GLSLCone;
import de.grogra.imp3d.glsl.renderable.GLSLCylinder;
import de.grogra.imp3d.glsl.renderable.GLSLFrustum;
import de.grogra.imp3d.glsl.renderable.GLSLNURBSCurve;
import de.grogra.imp3d.glsl.renderable.GLSLNullRenderable;
import de.grogra.imp3d.glsl.renderable.GLSLPlane;
import de.grogra.imp3d.glsl.renderable.GLSLPolygonizable;
import de.grogra.imp3d.glsl.renderable.GLSLRenderable;
import de.grogra.imp3d.glsl.renderable.GLSLSphere;
import de.grogra.imp3d.objects.MeshNode;
import de.grogra.imp3d.objects.NURBSSurface;
import de.grogra.imp3d.objects.Patch;
import de.grogra.imp3d.objects.Polygon;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class RenderableCollection {
    private HashMap<Class, CachedRessourceStack<GLSLRenderable>> shapeReference = new HashMap();

    public RenderableCollection() {
        this.addToReferenceMap(new GLSLBox());
        this.addToReferenceMap(new GLSLSphere());
        this.addToReferenceMap(new GLSLCylinder());
        this.addToReferenceMap(new GLSLCone());
        this.addToReferenceMap(new GLSLFrustum());
        this.addToReferenceMap(new GLSLNullRenderable());
        this.addToReferenceMap(new GLSLPlane());
        this.addToReferenceMap(new GLSLNURBSCurve());
        this.addToReferenceMap(new GLSLPolygonizable(){

            @Override
            public Class<?> instanceFor() {
                return MeshNode.class;
            }
        });
        this.addToReferenceMap(new GLSLPolygonizable(){

            @Override
            public Class<?> instanceFor() {
                return NURBSSurface.class;
            }
        });
        this.addToReferenceMap(new GLSLPolygonizable(){

            @Override
            public Class<?> instanceFor() {
                return Patch.class;
            }
        });
        this.addToReferenceMap(new GLSLPolygonizable(){

            @Override
            public Class<?> instanceFor() {
                return Polygon.class;
            }
        });
        this.init();
    }

    private final void addToReferenceMap(GLSLRenderable gLSLRenderable) {
        CachedRessourceStack cachedRessourceStack = new CachedRessourceStack(this, gLSLRenderable);
        this.shapeReference.put(gLSLRenderable.instanceFor(), cachedRessourceStack);
    }

    public void init() {
        Iterator<CachedRessourceStack<GLSLRenderable>> iterator = this.shapeReference.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().init();
        }
    }

    public void cleanup() {
        Iterator<CachedRessourceStack<GLSLRenderable>> iterator = this.shapeReference.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().cleanup();
        }
    }

    public GLSLRenderable getInstance(Object object, Object object2, boolean bl, GraphState graphState) {
        if (object == null) {
            System.err.println("NULL SHAPE REQUESTED!");
            return null;
        }
        CachedRessourceStack<GLSLRenderable> cachedRessourceStack = this.shapeReference.get(object.getClass());
        if (cachedRessourceStack == null && (cachedRessourceStack = this.shapeReference.get(null)) == null) {
            System.err.println("NULLSHAPE NOT FOUND --- THIS IS REALLY BAD!");
            return null;
        }
        GLSLRenderable gLSLRenderable = cachedRessourceStack.add();
        gLSLRenderable.updateInstance(object, object2, bl, graphState);
        return gLSLRenderable;
    }

    public void removeUnused(OpenGLState openGLState) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedRessourceStack<T extends GLSLRenderable>
    extends Vector<T> {
        private int elements = 0;
        private T base;
        final /* synthetic */ RenderableCollection this$0;

        public CachedRessourceStack(T t) {
            this.this$0 = var1_1;
            this.base = t;
        }

        public T add() {
            Object object;
            ++this.elements;
            if (this.elements - 1 >= this.elementCount) {
                super.add(((GLSLRenderable)this.base).getInstance());
                object = this.lastElement();
            } else {
                object = (GLSLRenderable)this.get(this.elements - 1);
            }
            return (T)object;
        }

        @Override
        public synchronized int size() {
            return this.elements;
        }

        @Override
        public synchronized T lastElement() {
            if (this.elementCount == 0) {
                throw new NoSuchElementException();
            }
            return (T)((GLSLRenderable)this.elementData[this.elements - 1]);
        }

        public void init() {
            this.elements = 0;
        }

        public void cleanup() {
            this.setSize(this.elements);
        }

        @Override
        public synchronized String toString() {
            return super.toString() + "#:" + this.size() + "[" + "]";
        }
    }
}

